/****************************************************************************************/
/**
  Copyright (c) 2008 Freescale Semiconductor
  Freescale Confidential Proprietary
  \file     	Mcu.c
  \brief    	This file Initialize Mcu resources to emulate Pwm signals.   \n
                Pll setting is handle in this file.
  \author   	Freescale Semiconductor
  \author       r01160
  \author   	Guadalajara Applications Laboratory RTAC Americas
  \version      0.1
  \date     	4/17/2008 11:31:45 AM
  \warning      Any modification to PLL settings will MODIFY the base interrupt \n
                frequency of the PIT module. 
  
  * History:
  
*/
/****************************************************************************************/
#include "Mcu.h"


/**
 * \brief     Configure and Inititlize PLL module.
 * \author    R01160
 * \param     
 * \return    none
 * \todo
 * \warning   Any modification to system clock frequency WILL modify the \n
              interrupt frequency of the PIT module giving as a result a \n
              mofification of the Pwm frequency signals.
 */  
 void vfnInit_PLL(void)
 {
      
    CRP.CLKSRC.B.XOSCEN = 1U;          /* Enable external oscillator */
    FMPLL.ESYNCR2.R = 0x00000007U;     /* Set ERFD to initial value of 7 */
    FMPLL.ESYNCR1.R = 0xF0010030U;     /* Set CLKCFG=PLL, EPREDIV=1, EMFD=0x30 */
    while (FMPLL.SYNSR.B.LOCK != 1U) {}; /* Wait for PLL to LOCK  */
    FMPLL.ESYNCR2.R = 0x00000003U;     /* Set ERFD to final value for 64 MHz sysclk */
    SIU.SYSCLK.B.SYSCLKSEL = 2U;       /* Select PLL for sysclk */
 }