/**
  Copyright (c) 2008 Freescale Semiconductor
  Freescale Confidential Proprietary
  \file       Sci_Cfg.h
  \brief      This file contains all Port Configuration Structures to be used \n
              as virtual sci channels.  
  \author     Freescale Semiconductor
  \author     r01160
  \author     Guadalajara Applications Laboratory RTAC Americas
  \version    0.1
  \date       8/19/2008 12:40:02 PM
    
  * History:
  
*/
#ifndef SCI_CFG_H
 #define SCI_CFG_H
 
 #include "typedefs.h"
  
  /** Boolean Condition definitions */
#ifndef ON
  #define ON   0x01
#endif

#ifndef OFF  
  #define OFF  0x00
#endif  
 
 #define FNC_1     0x0400U
 #define FNC_2     0x0800U
 #define FNC_3     0x0C00U
 #define OUTPUT        0x0200U
 #define INPUT         0x0100U 
 
 /*///////////////////////////// LAYER ENABLING DEFINITIONS ////////////////////////*/
 /** Pit & emios Interrupts shall be handle by Z0 core               */
 #define Z0_CORE         ON
 /*////////////////////////////////////////////////////////////////////////////////*/
  #define EMSCI_ERROR_DETECT   ON
  #define EMSCI0               0U
  #define EMSCI1               1U
  #define EMSCI2               2U
  #define EMSCI3               3U
  
 
  /* user-defined set-up */
  #define EMSCI_BUS_FREQUENCY   SYS_FREQ /* bus frequency in Hz */
  #define EMSCI_BAUD_RATE       9600U     /* symbol rate in baud (the same for all channels in this simplified implementation) */
  #define EMSCI_BIT_COUNT       8U         /* number of data bits to transmit/receive (1..14) */
  #define EMSCI_TIMER_PRESCALER 4U         /* ECT binary prescaler value 0..7 (bus clock divided by 2^EMSCI_TIMER_PRESCALER) */
  #define EMSCI_CHANNELS        1U         /* number of channels (1..4); channel 0 on pins PT0(Rx) & PT1(Tx), channel 1 on pins PT2&PT3, ... */
  #define EMSCI_SEMAPHORE       0U         /* semaphore number to use for access to the timer interrupt enable register */
  #define EMSCI_USE_INTERRUPTS  1U         /* 1 = EMSCI0 Rx uses interrupt vector 0x77 (ECT ch0), EMSCI0 Tx uses 0x76 (ECT ch1), ... ; 0 = no interrupts for the CPU */

  #define EMSCI_TX_FNC_1       vfn_Tx_Fnc_1
  #define EMSCI_RX_FNC_1       vfn_Rx_Fnc_1
 
 
  #define EMSCI_TX_EMPTY        0xFFFFU    /* Tx buffer empty indicator */
  #define EMSCI_RX_EMPTY        0xFFFFU    /* Rx buffer empty indicator */

   /* bit time expressed in timer ticks */
   #define EMSCI_BIT_TIME      ((EMSCI_BUS_FREQUENCY/(EMSCI_TIMER_PRESCALER))/EMSCI_BAUD_RATE)
 
   /* macros for testing and accessing the Tx/Rx buffers */
   #define EMSCI_TX(emsci_no,data)           emsci[(emsci_no)].tx_buffer = (data);   /* copy the data to the buffer */\
                                             EMIOS.CH[(emsci_no)].CCR.B.MODE  = EMIOS_SAOC_MODE;                    \
                                             EMIOS.CH[(emsci_no)].CCR.B.FEN = 1;   /* Enables interrupt generation */
	                                          
   #define EMSCI_TX_BUFFER_EMPTY(emsci_no)   (emsci[(emsci_no)].tx_buffer==EMSCI_TX_EMPTY) /* test for Tx buffer empty */
   #define EMSCI_RX(emsci_no,result_var)     (result_var)=emsci[(emsci_no)].rx_buffer;       /* receive the value from the buffer */\
	                                          emsci[(emsci_no)].rx_buffer=EMSCI_RX_EMPTY;   /* mark the buffer as empty */
   #define EMSCI_RX_BUFFER_FULL(emsci_no)    (emsci[(emsci_no)].rx_buffer!=EMSCI_RX_EMPTY) /* test if the buffer is full */
    
   
 /* Emulated SCI structure */
typedef struct 
{
  uint16_t rx_buffer;         /* buffer for received characters */
  uint16_t tx_buffer;         /* buffer for transmitted characters */
  uint16_t rx_shift;          /* receive shift register */
  uint16_t tx_shift;          /* transmit shift register */
  uint16_t rx_last_edge_time; /* time of the last edge on the Rx pin */
  uint16_t rx_last_edge:1;    /* 0 = last edge was falling, pin is now low; 1 = last edge was rising, pin is now high */  
  uint16_t tx_in_progress:1;  /* 1 = transmission currently in progress, 0 = transmitter idle */
  uint16_t rx_in_progress:1;  /* 1 = reception currently in progress, 0 = receiver idle */
  uint16_t rx_bit_counter:5;  /* count of bits till the end of the character */
  uint16_t unused:8;          /* align the structure to whole number of words */
} temsci_data;

typedef struct
{
  /** Symbolic reference of EMSCI channel*/
  uint32_t u32Emsci_Unit;
  /** Emios channel used as TX channel   */
  uint32_t u32Tx_EmiosChannel;
  /** Emios Interrupt channel number     */
  uint32_t u32Tx_InterruptNum;
  /** Emios Output Pin number            */
  uint32_t u32Tx_OutputPin;
  /** Pin Function enabling Output mode (SIU_PCR)  */
  uint32_t u32Tx_OutputPinFnc;
  /** Tx notification: Empty buffer      */
  void (*TxEndNotification)(void);	
  /** Emios channel used as RX channel   */
  uint32_t u32Rx_EmiosChannel;
  /** Emios Interrupt channel number     */
  uint32_t u32Rx_InterruptNum;
  /** Emios Input Pin number             */
  uint32_t u32Rx_InputPin;
  /** Pin Function enabling input mode (SIU_PCR)  */
  uint32_t u32Rx_InputPinFnc;
  /** Rx notification: Byte sent         */
  void (*RxEndNotification)(void);	  
} Emsci_ConfigType;

 
 
   extern volatile temsci_data emsci[4];
   extern const Emsci_ConfigType Emsci_ChannelConfig[1];

 /*----------------------------- Defines ---------------------------*/

 #endif