/******************************************************************************************************************/
/**
Copyright (c) 2008 Freescale Semiconductor
Freescale Confidential Proprietary
\file		Emios.c
\brief		This file handles Multi-Thread Scheduler timebase
\author  	Freescale Semiconductor
\author  	Guadalajara Applications Laboratory RTAC Americas
\author  	R01160
\version	0.1
\date		5/23/2008 
*/
/******************************************************************************************************************/
/*																									*/
/* All software, source code, included documentation, and any implied know-how are property of		*/
/* Freescale Semiconductor and therefore considered CONFIDENTIAL INFORMATION.						*/
/* This confidential information is disclosed FOR DEMONSTRATION PURPOSES ONLY.						*/
/*																									*/
/* All Confidential Information remains the property of Freescale Semiconductor and will not be  	*/
/* copied or reproduced without the express written permission of the Discloser, except for copies	*/
/* that are absolutely necessary in order to fulfill the Purpose.									*/
/*																									*/
/* Services performed by FREESCALE in this matter are performed AS IS and without any warranty.  	*/
/* CUSTOMER retains the final decision relative to the total design and functionality of the end	*/
/* product.  																						*/
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER for the success of this project.*/
/*																									*/
/* FREESCALE disclaims all warranties, express, implied or statutory including, but not limited to, */
/* implied warranty of merchantability or fitness for a particular purpose on any hardware,  		*/
/* software ore advise supplied to the project by FREESCALE, and or any product resulting from		*/
/* FREESCALE services.																				*/
/* In no event shall FREESCALE be liable for incidental or consequential damages arising out of  	*/
/* this agreement. CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or */
/* actions by anyone on account of any damage,or injury, whether commercial, contractual, or		*/
/* tortuous, rising directly or indirectly as a result of the advise or assistance supplied CUSTOMER*/
/* in connectionwith product, services or goods supplied under this Agreement.						*/
/*																									*/
/******************************************************************************************************************/
#include	 "Emios.h"
#include	 "Emsci_Cfg.h"

/** Emsci Callback types */
	   Emios_CallbackType  Emios_CallBack_1;
	   Emios_CallbackType  Emios_CallBack_2;
	   Emios_CallbackType  Emios_CallBack_3;
	   Emios_CallbackType  Emios_CallBack_4;
	   Emios_CallbackType  Emios_CallBack_5;
	   Emios_CallbackType  Emios_CallBack_6;
	   Emios_CallbackType  Emios_CallBack_7;
	   Emios_CallbackType  Emios_CallBack_8;
	   Emios_CallbackType  Emios_CallBack_9;
	   

/** Configuration Pointer used to configured all necessary Emios channels*/
const  Emsci_ConfigType   * EmsciConfigPtr;



/*----------------------------------------------------------------------------------------------------------------*/
/**
* \brief	Enable General Emios Clocks.   
* \author	R01160
* \param	void
* \return	void
*/
void vfnEmiosConfig_General_Clocks( void  )
{
	eMIOS_SET_GLOBAL_PRESCALER_VALUE( EMSCI_TIMER_PRESCALER - 1 );
																/*	Divide sysclk by (11+1) for eMIOS clock  	  */
	eMIOS_ENABLE_GLOBAL_PRESCALER;								/*	Enable eMIOS clock							  */
	eMIOS_ENABLE_GLOBAL_TIMEBASE;								/*	Enable global time base  					  */
	eMIOS_ENABLE_GLOBAL_FREEZE_IN_DEBUG;						/*	Enable stopping channels when in debug mode   */

}

/*----------------------------------------------------------------------------------------------------------------*/
/**
 * \brief	 Initialize emios channels in pairs to be configured as Input Capture \n 
			 and Output Compare Modes.
 * \author	 R01160
 * \param	 Emsci configuration pointer
 * \return	 void
  * \warning Make sure the emios channels to be used as emulated SCI channels \n 
			 are not shared with other resources.
 */
void vfnEmios_Init_Channels( const Emsci_ConfigType * pEmsci_ChannelConfig )
{
	/** Used to store the inital counter value */
	uint16_t u16CntrMatch = 0;
	uint16_t  u16VarTest = 0;
	
	EmsciConfigPtr = pEmsci_ChannelConfig;					
	
  #if (EMSCI_CHANNELS == 1)
    u16VarTest = EmsciConfigPtr[0].u32Tx_InterruptNum;
    INT_PSR( EmsciConfigPtr[0].u32Tx_InterruptNum, 0x01 );
    u16VarTest = EmsciConfigPtr[0].u32Rx_InterruptNum;
    INT_PSR( EmsciConfigPtr[0].u32Rx_InterruptNum, 0x01 );
    vfnEmios_Set_Callback_Fnc( &EMSCI_TX_FNC_1, 0U );        /* Install function pointer to jump when Tx 1 interrupt occurs	*/
    vfnEmios_Set_Callback_Fnc( &EMSCI_RX_FNC_1, 1U );        /* Install function pointer to jump when Rx 1 interrupt occurs	*/
  #endif
  
  #if (EMSCI_CHANNELS > 1)
    INT_PSR( EmsciConfigPtr[1].u32Tx_InterruptNum, 0x01 );
    INT_PSR( EmsciConfigPtr[1].u32Rx_InterruptNum, 0x01 );
    vfnEmios_Set_Callback_Fnc( &EMSCI_TX_FNC_2, 2U );       /* Install function pointer to jump when Tx 2 interrupt occurs	*/
    vfnEmios_Set_Callback_Fnc( &EMSCI_RX_FNC_2, 3U );       /* Install function pointer to jump when Rx 2 interrupt occurs	*/
  #endif
  
  #if (EMSCI_CHANNELS > 2)
    INT_PSR( EmsciConfigPtr[2].u32Tx_InterruptNum, 0x01 );
    INT_PSR( EmsciConfigPtr[2].u32Rx_InterruptNum, 0x01 );
    vfnEmios_Set_Callback_Fnc( &EMSCI_TX_FNC_3, 4U );       /* Install function pointer to jump when Tx 3 interrupt occurs	*/
    vfnEmios_Set_Callback_Fnc( &EMSCI_RX_FNC_3, 5U );       /* Install function pointer to jump when Rx 3 interrupt occurs	*/
  #endif
  
  #if (EMSCI_CHANNELS > 3)
    INT_PSR( EmsciConfigPtr[3].u32Tx_InterruptNum, 0x01 );
    INT_PSR( EmsciConfigPtr[3].u32Rx_InterruptNum, 0x01 );
    vfnEmios_Set_Callback_Fnc( &EMSCI_TX_FNC_4, 6U );      /* Install function pointer to jump when Tx 4 interrupt occurs	*/
    vfnEmios_Set_Callback_Fnc( &EMSCI_RX_FNC_4, 7U );      /* Install function pointer to jump when Rx 4 interrupt occurs	*/
  #endif
  
	
	/* ------- Configure Tx Channel --------- */
	eMIOS_SET_INTERNAL_TIME_BASE( EmsciConfigPtr->u32Tx_EmiosChannel ); /* Use internal counter */
	eMIOS_ENABLE_LOCAL_PRESCALER( EmsciConfigPtr->u32Tx_EmiosChannel ); /* MPC551x initial name for UCPREN */
	eMIOS_FREEZE_IN_DEBUG( EmsciConfigPtr->u32Tx_EmiosChannel );        /* Stop (freeze) channel registers when in debug mode */
	eMIOS_DISABLE_CHANNEL_INTERRUPT( ( uint16_t )EmsciConfigPtr->u32Tx_EmiosChannel ); /* Flag enables interrupt */
	eMIOS_SET_EDGE_SELECT( EmsciConfigPtr->u32Tx_EmiosChannel, 0 );
	eMIOS_SET_MODE( EmsciConfigPtr->u32Tx_EmiosChannel, EMIOS_GPIO_MODE );
	eMIOS_TIMER_COUNT( EmsciConfigPtr->u32Tx_EmiosChannel ) = 0x0000U;
	u16CntrMatch = eMIOS_TIMER_COUNT( EmsciConfigPtr->u32Tx_EmiosChannel ) + EMSCI_BIT_TIME;
	eMIOS_SET_EDGE_POLARITY( EmsciConfigPtr->u32Tx_EmiosChannel, 1 );
	eMIOS_SET_MODE( EmsciConfigPtr->u32Tx_EmiosChannel, EMIOS_SAOC_MODE );
	eMIOS_MATCH_EVENT_FLAG( EmsciConfigPtr->u32Tx_EmiosChannel ) = 0x01U;
	eMIOS_SET_COUNT_A( EmsciConfigPtr->u32Tx_EmiosChannel,( uint16_t )u16CntrMatch );
	
	/* ------- Configure Rx Channel --------- */
	
	eMIOS_SET_INTERNAL_TIME_BASE( EmsciConfigPtr->u32Rx_EmiosChannel );  /* Use internal counter */
	eMIOS_DISABLE_LOCAL_PRESCALER( EmsciConfigPtr->u32Rx_EmiosChannel ); /* MPC551x initial name for UCPREN */
	eMIOS_FREEZE_IN_DEBUG( EmsciConfigPtr->u32Rx_EmiosChannel );       	 /* Stop (freeze) channel registers when in debug mode */
	eMIOS_ENABLE_CHANNEL_INTERRUPT( EmsciConfigPtr->u32Rx_EmiosChannel );/* Flag enables interrupt */

	EMIOS.CH[ EmsciConfigPtr->u32Rx_EmiosChannel ].CCR.B.IF = 0x10U;
	eMIOS_SET_EDGE_SELECT( EmsciConfigPtr->u32Rx_EmiosChannel, 1 );      /* Triggering on both edges */
	eMIOS_SET_MODE( EmsciConfigPtr->u32Rx_EmiosChannel, EMIOS_GPIO_MODE );
	eMIOS_TIMER_COUNT( EmsciConfigPtr->u32Rx_EmiosChannel ) = 0x0000U;
	eMIOS_SET_EDGE_POLARITY( EmsciConfigPtr->u32Rx_EmiosChannel, 0 );    /* TRIGGER ON FALLING EDGE */
	eMIOS_SET_MODE( EmsciConfigPtr->u32Rx_EmiosChannel, EMIOS_SAIC_MODE ); /* MODE 0x02 = SAIC Mode */
	eMIOS_MATCH_EVENT_FLAG( EmsciConfigPtr->u32Rx_EmiosChannel ) = 0x01U;

}


/*----------------------------------------------------------------------------------------------------------------*/
/**
 * \brief	  Sets the function to which the emios interrupt shall \n
			  jump once interrupt occurs.
 * \author	  R01160
 * \param	  Emios_CallbackType - Callback type definition, Fnc Callback \n
			  to be used.
 * \return	  none
 * \warning   this function will skip any null pointer parameter passed \n
			  as a input parameter.
 */
void vfnEmios_Set_Callback_Fnc( const Emios_CallbackType  Callback_Fnc, uint8_t  u8FncCallback )
{   
  #if (  EMSCI_ERROR_DETECT  ==  ON  )							/*If Pwm Error Layer Enabled validate errors	  */
	if( Callback_Fnc == NULL_PTR )								/*	Pwm module already initilized?				  */
	{
		vfnEmsci_Report_Error( EMSCI_CALLBACK_PTR_ID, EMSCI_E_FNC_CALLBACK_UNINIT );
																/*	  Report None initilized module  			  */
	}
	else
	{
  #endif															
  	 																
	  /*--- MISRA Rule 16.9 violation: A function identifier shal only be used with either a preceding ---*/
	  /*---- & or with parenthisised parameter list                                                       */
	  	  
	  switch(u8FncCallback)
	  {
			case 0U: Emios_CallBack_1 = Callback_Fnc;
				break;
			case 1U: Emios_CallBack_2 = Callback_Fnc;
				break;
			case 2U: Emios_CallBack_3 = Callback_Fnc;
				break;
			case 3U: Emios_CallBack_4 = Callback_Fnc;
				break;
			case 4U: Emios_CallBack_5 = Callback_Fnc;
				break;				
			case 5U: Emios_CallBack_6 = Callback_Fnc;
				break;
			case 6U: Emios_CallBack_7 = Callback_Fnc;
				break;
			case 7U: Emios_CallBack_8 = Callback_Fnc;
				break;
			case 8U: Emios_CallBack_9 = Callback_Fnc;
				break;
			default:
				break;
	  }
	
	
	
#if (  EMSCI_ERROR_DETECT  ==  ON  )
	}
#endif

}

/*----------------------------------------------------------------------------------------------------------------*/
/**
 * \brief	  Service Interrupt routine from Emios channel 0
 * \author	  R01160
 * \param	  none
 * \return	  none
 */
void vfnEmios_Isr_0( void  )
{
	if( eMIOS_STATUS_FLAG( EMIOS_CH0 ) == 1U )
	{
		/* Jump into Tx routine for channel number 1 */
		Emios_CallBack_1( );
	}

	/* clear the interrupt flag */
	eMIOS_STATUS_FLAG( EMIOS_CH0 ) = 0x01U;
}
/*----------------------------------------------------------------------------------------------------------------*/
/**
 * \brief	  Service Interrupt routine from Emios channel 0
 * \author	  R01160
 * \param	  none
 * \return	  none
 */

void vfnEmios_Isr_1( void  )
{
	if( eMIOS_STATUS_FLAG( EMIOS_CH1 ) == 1U )
	{
		/* Jump into Rx routine for channel number 1 */
		Emios_CallBack_2( );
	}

	/* clear the interrupt flag */
	eMIOS_STATUS_FLAG( EMIOS_CH1 ) = 0x01U;
}

/*----------------------------------------------------------------------------------------------------------------*/
/**
 * \brief	  Service Interrupt routine from Emios channel 9 \n
 *          this interrupt calls Scheduler function.
 * \author	R01160
 * \param	  none
 * \return	none
 */
void Emios_Channel_9_Isr(void)
{
  if( eMIOS_STATUS_FLAG( EMIOS_CH9 ) == 1U )
	{
		/* Jump into Rx routine for channel number 1 */
		Emios_CallBack_9( );
	}

	/* clear the interrupt flag */
	eMIOS_STATUS_FLAG( EMIOS_CH9 ) = 0x01U;

}