
/*
 * File:		io.c
 * Purpose:		Serial Input/Output routines
 *
 */

#include "mcf5282.h"
#include "init.h"

/********************************************************************/
int
in_char (void)
{
	/* Wait until character has been received */
	while (!(MCF5282_UART0_USR & MCF5282_UART_USR_RXRDY))
		; 
	return MCF5282_UART0_URB;
}
/********************************************************************/
void
out_char (int ch)
{
	/* Wait until space is available in the FIFO */
	while (!(MCF5282_UART0_USR & MCF5282_UART_USR_TXRDY))
		;
	/* Send the character */
	MCF5282_UART0_UTB = ch;
}

/********************************************************************/
int
uart0_char_present (void)
{
	return (MCF5282_UART0_USR & MCF5282_UART_USR_RXRDY);
}

/********************************************************************/
char
uart1_in_char (void)
{
	/* Wait until character has been received */
	while (!(MCF5282_UART1_USR & MCF5282_UART_USR_RXRDY))
		; 
	return MCF5282_UART1_URB;
}
/********************************************************************/
void
uart1_out_char (char ch)
{
	/* Wait until space is available in the FIFO */
	while (!(MCF5282_UART1_USR & MCF5282_UART_USR_TXRDY))
		;
	/* Send the character */
	MCF5282_UART1_UTB = ch;
}

/********************************************************************/
int
uart1_char_present (void)
{
	return (MCF5282_UART1_USR & MCF5282_UART_USR_RXRDY);
}

/********************************************************************/
char
uart2_in_char (void)
{
	/* Wait until character has been received */
	while (!(MCF5282_UART2_USR & MCF5282_UART_USR_RXRDY))
		; 
	return MCF5282_UART2_URB;
}
/********************************************************************/
void
uart2_out_char (char ch)
{
	/* Wait until space is available in the FIFO */
	while (!(MCF5282_UART2_USR & MCF5282_UART_USR_TXRDY))
		;
	/* Send the character */
	MCF5282_UART2_UTB = ch;
}

/********************************************************************/
int
uart2_char_present (void)
{
	return (MCF5282_UART2_USR & MCF5282_UART_USR_RXRDY);
}

/********************************************************************/