/************************************************************************************************************
*
* Queued Analog to Digital Converter (QADC) Module - operating modes
*
*************************************************************************************************************/

/* Bit level definiton macros for operating modes for QUEUE 1 */

#define Q1_DISABLED                                 (0)
#define Q1_SOFTWARE_TRIGGERED_SINGLE_SCAN           (1)  // started with SSE1
#define Q1_EXT_TRIGGER_SINGLE_SCAN_RISING           (2)
#define Q1_EXT_TRIGGER_SINGLE_SCAN_FALLING          (3)
#define Q1_INTERVAL_TIMER_SINGLE_SCAN_128           (4)  // QCLK period x 2^7
#define Q1_INTERVAL_TIMER_SINGLE_SCAN_256           (5)  // QCLK period x 2^8
#define Q1_INTERVAL_TIMER_SINGLE_SCAN_512           (6)  // QCLK period x 2^9
#define Q1_INTERVAL_TIMER_SINGLE_SCAN_1024          (7)  // QCLK period x 2^10
#define Q1_INTERVAL_TIMER_SINGLE_SCAN_2048          (8)  // QCLK period x 2^11
#define Q1_INTERVAL_TIMER_SINGLE_SCAN_4096          (9)  // QCLK period x 2^12
#define Q1_INTERVAL_TIMER_SINGLE_SCAN_8192          (10) // QCLK period x 2^13
#define Q1_INTERVAL_TIMER_SINGLE_SCAN_16384         (11) // QCLK period x 2^14
#define Q1_INTERVAL_TIMER_SINGLE_SCAN_32768         (12) // QCLK period x 2^15
#define Q1_INTERVAL_TIMER_SINGLE_SCAN_65536         (13) // QCLK period x 2^16
#define Q1_INTERVAL_TIMER_SINGLE_SCAN_131072        (14) // QCLK period x 2^17
#define Q1_EXT_GATED_SINGLE_SCAN                    (15) // started with SSE1
//	    Q1_RESERVED                                 (16)
#define Q1_SOFTWARE_TRIGGERED_CONTINUOUS_SCAN       (17)
#define Q1_EXT_TRIGGER_CONTINUOUS_SCAN_RISING       (18)
#define Q1_EXT_TRIGGER_CONTINUOUS_SCAN_FALLING      (19)
#define Q1_PERIODIC_TIMER_CONTINUOUS_SCAN_128       (20) // QCLK period x 2^7
#define Q1_PERIODIC_TIMER_CONTINUOUS_SCAN_256       (21) // QCLK period x 2^8
#define Q1_PERIODIC_TIMER_CONTINUOUS_SCAN_512       (22) // QCLK period x 2^9
#define Q1_PERIODIC_TIMER_CONTINUOUS_SCAN_1024      (23) // QCLK period x 2^10
#define Q1_PERIODIC_TIMER_CONTINUOUS_SCAN_2048      (24) // QCLK period x 2^11
#define Q1_PERIODIC_TIMER_CONTINUOUS_SCAN_4096      (25) // QCLK period x 2^12
#define Q1_PERIODIC_TIMER_CONTINUOUS_SCAN_8192      (26) // QCLK period x 2^13
#define Q1_PERIODIC_TIMER_CONTINUOUS_SCAN_16384     (27) // QCLK period x 2^14
#define Q1_PERIODIC_TIMER_CONTINUOUS_SCAN_32768     (28) // QCLK period x 2^15
#define Q1_PERIODIC_TIMER_CONTINUOUS_SCAN_65536     (29) // QCLK period x 2^16
#define Q1_PERIODIC_TIMER_CONTINUOUS_SCAN_131072    (30) // QCLK period x 2^17
#define Q1_EXT_GATED_CONTINUOUS_SCAN                (31)

/* Bit level definiton macros for operating modes for QUEUE 2 */

#define Q2_DISABLED                                 (0)
#define Q2_SOFTWARE_TRIGGERED_SINGLE_SCAN           (1)  // started with SSE2
#define Q2_EXT_TRIGGER_SINGLE_SCAN_RISING           (2)
#define Q2_EXT_TRIGGER_SINGLE_SCAN_FALLING          (3)
#define Q2_INTERVAL_TIMER_SINGLE_SCAN_128           (4)  // QCLK period x 2^7
#define Q2_INTERVAL_TIMER_SINGLE_SCAN_256           (5)  // QCLK period x 2^8
#define Q2_INTERVAL_TIMER_SINGLE_SCAN_512           (6)  // QCLK period x 2^9
#define Q2_INTERVAL_TIMER_SINGLE_SCAN_1024          (7)  // QCLK period x 2^10
#define Q2_INTERVAL_TIMER_SINGLE_SCAN_2048          (8)  // QCLK period x 2^11
#define Q2_INTERVAL_TIMER_SINGLE_SCAN_4096          (9)  // QCLK period x 2^12
#define Q2_INTERVAL_TIMER_SINGLE_SCAN_8192          (10) // QCLK period x 2^13
#define Q2_INTERVAL_TIMER_SINGLE_SCAN_16384         (11) // QCLK period x 2^14
#define Q2_INTERVAL_TIMER_SINGLE_SCAN_32768         (12) // QCLK period x 2^15
#define Q2_INTERVAL_TIMER_SINGLE_SCAN_65536         (13) // QCLK period x 2^16
#define Q2_INTERVAL_TIMER_SINGLE_SCAN_131072        (14) // QCLK period x 2^17
//      Q2_RESERVED                                 (15)
//	    Q2_RESERVED                                 (16)
#define Q2_SOFTWARE_TRIGGERED_CONTINUOUS_SCAN       (17)
#define Q2_EXT_TRIGGER_CONTINUOUS_SCAN_RISING       (18)
#define Q2_EXT_TRIGGER_CONTINUOUS_SCAN_FALLING      (19)
#define Q2_PERIODIC_TIMER_CONTINUOUS_SCAN_128       (20) // QCLK period x 2^7
#define Q2_PERIODIC_TIMER_CONTINUOUS_SCAN_256       (21) // QCLK period x 2^8
#define Q2_PERIODIC_TIMER_CONTINUOUS_SCAN_512       (22) // QCLK period x 2^9
#define Q2_PERIODIC_TIMER_CONTINUOUS_SCAN_1024      (23) // QCLK period x 2^10
#define Q2_PERIODIC_TIMER_CONTINUOUS_SCAN_2048      (24) // QCLK period x 2^11
#define Q2_PERIODIC_TIMER_CONTINUOUS_SCAN_4096      (25) // QCLK period x 2^12
#define Q2_PERIODIC_TIMER_CONTINUOUS_SCAN_8192      (26) // QCLK period x 2^13
#define Q2_PERIODIC_TIMER_CONTINUOUS_SCAN_16384     (27) // QCLK period x 2^14
#define Q2_PERIODIC_TIMER_CONTINUOUS_SCAN_32768     (28) // QCLK period x 2^15
#define Q2_PERIODIC_TIMER_CONTINUOUS_SCAN_65536     (29) // QCLK period x 2^16
#define Q2_PERIODIC_TIMER_CONTINUOUS_SCAN_131072    (30) // QCLK period x 2^17
//      Q2_RESERVED                                 (31)
