#include "mcf5282.h"

#define P         MCF5282_QADC_CCW_P       // pause after command
#define BYP       MCF5282_QADC_CCW_BYP     // sample amplifier bypass - usually not used
#define IST(x)    MCF5282_QADC_CCW_IST(x)  // input sample time: 0,1,2,3 => QCLKperiod * 2,4,8,16 

#define CHAN(x)   MCF5282_QADC_CCW_CHAN(x) // input channel number
/* Possible channel numbers depends on used multiplexing:
   internally multiplexed (non-multiplexed): from 0 to 3, 52, 53, 55, 56
   externally multiplexed (multiplexed):	 from 0 to 7, from 16 to 23 , 55, 56

For both also can be used these special cases: 	                                     */		
#define LOW_REF   CHAN(60)  // low reference
#define HIGH_REF  CHAN(61)  // high reference
#define HiLoDiv2  CHAN(62)  // (high ref - low ref) / 2
#define EOQ       CHAN(63)  // end of queue code
#define EOQ1      CHAN(63)  // end of queue code (the rest below it is queue2)
#define EOQ2      CHAN(63)  // end of queue code (the rest below it is ignored)

/* function prototypes */ 
void set_CCW (void);
int32 get_BQ2 (void);
