/*
** ###################################################################
**     This code is generated by the Device Initialization Tool.
**     It is overwritten during code generation.
**     USER MODIFICATION ARE PRESERVED ONLY INSIDE INTERRUPT SERVICE ROUTINES 
**                                                 OR EXPLICITLY MARKED SECTIONS
**
**     Project   : iron
**     Processor : MC9RS08KA2CSC
**     Version   : Bean 01.069, Driver 01.01, CPU db: 3.00.002
**     Datasheet : MC9RS08KA2 Rev. 3 Draft B 4/2007
**     Date/Time : 20.12.2007, 0:08
**     Abstract  :
**         This module contains device initialization code 
**         for selected on-chip peripherals.
**     Contents  :
**         Function "MCU_init" initializes selected peripherals
**
**     (c) Copyright UNIS, spol. s r.o. 1997-2006
**     UNIS, spol s r.o.
**     Jundrovska 33
**     624 00 Brno
**     Czech Republic
**     http      : www.processorexpert.com
**     mail      : info@processorexpert.com
** ###################################################################
*/

/* MODULE MCUinit */

#include <MC9RS08KA2.h>                /* I/O map for MC9RS08KA2CSC */
#include "MCUinit.h"

/* User declarations and definitions */
/*   Code, declarations and definitions here will be preserved during code generation */
/* End of user declarations and definitions */


/*
** ===================================================================
**     Method      :  MCU_init (bean MC9RS08KA2_8)
**
**     Description :
**         Device initialization code for selected peripherals.
** ===================================================================
*/
void MCU_init(void)
{
  /* ### MC9RS08KA2_8 "Cpu" init code ... */
  /*  PE initialization code after reset */
  /* Common initialization of the write once registers */
  /* SOPT: COPE=0,COPT=1,STOPE=0,BKGDPE=0,RSTPE=0 */
  SOPT = 0x40;                                      
  /* SPMSC1: LVDF=0,LVDACK=0,LVDIE=0,LVDRE=1,LVDSE=0,LVDE=1,BGBE=1 */
  SPMSC1 = 0x15;                                      
  /*  System clock initialization */
  ICSTRM = *(unsigned char* __paged)CONVERT_TO_PAGED(0x3FFA); /* Initialize ICSTRM register from a non volatile memory */
  ICSSC = *(unsigned char* __paged)CONVERT_TO_PAGED(0x3FFB); /* Initialize ICSSC register from a non volatile memory */
  /* ICSC1: CLKS=0,IREFSTEN=0 */
  ICSC1 = 0x00;                        /* Initialization of the ICS control register 1 */
  /* ICSC2: BDIV=0,LP=0 */
  ICSC2 = 0x00;                        /* Initialization of the ICS control register 2 */
  /* Common initialization of the CPU registers */
  /* PTASE: PTASE5=1,PTASE4=1,PTASE3=0,PTASE1=1,PTASE0=0 */
  PTASE = (PTASE & (unsigned char)~0x09) | (unsigned char)0x32;
  /* ### Init_ACMP init code */
  /* ACMPSC: ACME=0,ACBGS=1,ACF=1,ACIE=1,ACO=0,ACOPE=0,ACMOD1=0,ACMOD0=0 */
  ACMPSC = 0x70;                                      
  /* ### Init_MTIM init code */
  /* MTIMMOD: MOD7=0,MOD6=0,MOD5=0,MOD4=0,MOD3=0,MOD2=0,MOD1=0,MOD0=0 */
  MTIMMOD = 0x00;                                      
  /* MTIMCLK: CLKS1=0,CLKS0=0,PS3=0,PS2=0,PS1=0,PS0=0 */
  MTIMCLK = 0x00;                                      
  /* MTIMSC: TOF=0,TOIE=0,TRST=0,TSTP=0 */
  MTIMSC = 0x00;                                      
  /* ### Init_KBI init code */
  /* KBISC: KBIE=0 */
  KBISC &= (unsigned char)~0x02;                     
  /* KBIES: KBEDG5=0,KBEDG4=0,KBEDG2=1,KBEDG1=0,KBEDG0=0 */
  KBIES = 0x04;                                      
  /* KBISC: KBIMOD=0 */
  KBISC &= (unsigned char)~0x01;                     
  /* KBIPE: KBIPE5=0,KBIPE4=0,KBIPE2=1,KBIPE1=0,KBIPE0=0 */
  KBIPE = 0x04;                                      
  /* KBISC: KBACK=1 */
  KBISC |= (unsigned char)0x04;                               
  /* KBISC: KBIE=1 */
  KBISC |= (unsigned char)0x02;                               
  /* ### Init_GPIO init code */
  /* PTAD: PTAD4=0,PTAD3=1,PTAD0=0 */
  PTAD = (PTAD & (unsigned char)~0x11) | (unsigned char)0x08;
  /* PTADD: PTADD5=0,PTADD4=0,PTADD0=1 */
  PTADD = (PTADD & (unsigned char)~0x30) | (unsigned char)0x01;
  /* ### Init_COP init code */
  SRS = 0xFF;                          /* Clear WatchDog counter */
  /* ### */
} /*MCU_init*/



/* Initialization of the CPU registers in FLASH */

/* NVOPT: SECD=1 */
const unsigned char NVOPT_INIT @0x00003FFC = 0xFF;


/* Initialization of the reset vector */
extern void _Startup(void);

static const unsigned char JMPOpcode @0x3FFD = 0xBC; /* Opcode of JMP extended */
void far (*const ResetVector)(void)   @0x3FFE = _Startup;

/* END MCUinit */

/*
** ###################################################################
**
**     This file was created by UNIS Processor Expert 3.01 [03.92]
**     for the Freescale RS08 series of microcontrollers.
**
** ###################################################################
*/
