#include <stdio.h>
#include "epic.h"
#include "netcomm.h"
#include "mcc.h"

#ifdef __cplusplus
extern "C" {
#endif

void InterruptHandler(long cause);

extern UBYTE testmode;

#ifdef __cplusplus
}
#endif

void InterruptHandler(long cause)
{

	switch (cause) {
        case 0x0100:
                printf("EXCEPTION 100: A Soft Reset\n\r");
                break;

        case 0x0200:
                printf("EXCEPTION 200: A Machine Check\n\r");
                break;

        case 0x0300:
                printf("EXCEPTION 300: A Data Access\n\r");
                break;

        case 0x0400:
                printf("EXCEPTION 400: An Instruction Access\n\r");
                                           
                break;

        case 0x0500:
        	if (testmode == RUN_ONCE) 
        	{        
                	printf("EXCEPTION 500: An External Interrupt\n\r");
        	}
                epicISR();
                break;
        default:
        	printf("EXCEPTION 600+: Not supported\n\r");
        	break;
	}
}

// EOF


