/*-----------------------------------------------------------------------------
*
* $Header: n:/pcmrcs/NCdrivers/headers/mpq_rio.h 0.1.1.2 2004/07/26 15:37:00 jdabbraccio Exp $
*
* Copyright Freescale Semiconductor, Inc. 2003-2004.  All rights reserved.
*
* Description:	RapidIO (RIO) Registers.
*
*----------------------------------------------------------------------------*/


typedef _Packed struct
{
	reg32 didcar;
	reg32 dicar;
	reg32 aidcar;
	reg32 aicar;
	reg32 pefcar;
	reg32 spicar;
	reg32 socar;
	reg32 docar;
	byte _reserved0[0x20];
	reg32 msr;
	reg32 pwdcsr;
	byte _reserved1[0x04];
	reg32 pellccsr;
	byte _reserved2[0x0C];
	reg32 lcsbacsr;
	reg32 bdidcsr;
	byte _reserved3[0x04];
	reg32 hbdidlcsr;
	reg32 ctcsr;
	byte _reserved4[0x90];
	reg32 pmbh0csr;
	byte _reserved5[0x1C];
	reg32 pltoccsr;
	reg32 prtoccsr;
	byte _reserved6[0x14];
	reg32 pgccsr;
	reg32 plmreqcsr;
	reg32 plmrespcsr;
	reg32 plascsr;
	byte _reserved7[0x0C];
	reg32 pescsr;
	reg32 pccsr;
	byte _reserved8[0xFEA0];
	reg32 cr;
	byte _reserved9[0x0C];
	reg32 pcr;
	reg32 peir;
	byte _reserved10[0x8E8];
	reg32 res11b;
	byte _reserved11[0x2FC];
	reg32 rowtar0;
	byte _reserved12[0x0C];
	reg32 rowar0;
	byte _reserved13[0x0C];
	reg32 rowtar1;
	byte _reserved14[0x04];
	reg32 rowbar1;
	byte _reserved15[0x04];
	reg32 rowar1;
	byte _reserved16[0x0C];
	reg32 rowtar2;
	byte _reserved17[0x04];
	reg32 rowbar2;
	byte _reserved18[0x04];
	reg32 rowar2;
	byte _reserved19[0x0C];
	reg32 rowtar3;
	byte _reserved20[0x04];
	reg32 rowbar3;
	byte _reserved21[0x04];
	reg32 rowar3;
	byte _reserved22[0x0C];
	reg32 rowtar4;
	byte _reserved23[0x04];
	reg32 rowbar4;
	byte _reserved24[0x04];
	reg32 rowar4;
	byte _reserved25[0x0C];
	reg32 rowtar5;
	byte _reserved26[0x04];
	reg32 rowbar5;
	byte _reserved27[0x04];
	reg32 rowar5;
	byte _reserved28[0x0C];
	reg32 rowtar6;
	byte _reserved29[0x04];
	reg32 rowbar6;
	byte _reserved30[0x04];
	reg32 rowar6;
	byte _reserved31[0x0C];
	reg32 rowtar7;
	byte _reserved32[0x04];
	reg32 rowbar7;
	byte _reserved33[0x04];
	reg32 rowar7;
	byte _reserved34[0x0C];
	reg32 rowtar8;
	byte _reserved35[0x04];
	reg32 rowbar8;
	byte _reserved36[0x04];
	reg32 rowar8;
	byte _reserved37[0x4C];
	reg32 riwtar4;
	byte _reserved38[0x04];
	reg32 riwbar4;
	byte _reserved39[0x04];
	reg32 riwar4;
	byte _reserved40[0x0C];
	reg32 riwtar3;
	byte _reserved41[0x04];
	reg32 riwbar3;
	byte _reserved42[0x04];
	reg32 riwar3;
	byte _reserved43[0x0C];
	reg32 riwtar2;
	byte _reserved44[0x04];
	reg32 riwbar2;
	byte _reserved45[0x04];
	reg32 riwar2;
	byte _reserved46[0x0C];
	reg32 riwtar1;
	byte _reserved47[0x04];
	reg32 riwbar1;
	byte _reserved48[0x04];
	reg32 riwar1;
	byte _reserved49[0x0C];
	reg32 riwtar0;
	byte _reserved50[0x0C];
	reg32 riwar0;
	byte _reserved51[0x0C];
	reg32 pnfedr;
	reg32 pnfedir;
	reg32 pnfeier;
	reg32 pecr;
	reg32 pepcsr0;
	reg32 pepr1;
	reg32 pepr2;
	byte _reserved52[0x04];
	reg32 predr;
	byte _reserved53[0x04];
	reg32 pertr;
	reg32 prtr;
	byte _reserved54[0x1D0];
	reg32 omr;
	reg32 osr;
	byte _reserved55[0x04];
	reg32 odqdpar;
	byte _reserved56[0x04];
	reg32 osar;
	reg32 odpr;
	reg32 odatr;
	reg32 odcr;
	byte _reserved57[0x04];
	reg32 odqepar;
	byte _reserved58[0x34];
	reg32 imr;
	reg32 isr;
	byte _reserved59[0x04];
	reg32 ifqdpar;
	byte _reserved60[0x04];
	reg32 ifqepar;
	byte _reserved61[0x3E8];
	reg32 dmr;
	reg32 dsr;
	byte _reserved62[0x04];
	reg32 dqdpar;
	byte _reserved63[0x04];
	reg32 dqepar;
	byte _reserved64[0x68];
	reg32 pwmr;
	reg32 pwsr;
	byte _reserved65[0x04];
	reg32 pwqbar;
	byte _reserved66[0xEB10];
}
_PackedType mpq_rio;

/* Processing Element Features Capability Register (PEFCAR)*/
#define PEFCAR_B				0x80000000
#define PEFCAR_M				0x40000000
#define PEFCAR_P				0x20000000
#define PEFCAR_S				0x10000000
#define PEFCAR_MAILBOX0			0x00800000
#define PEFCAR_MAILBOX1			0x00400000
#define PEFCAR_MAILBOX2			0x00200000
#define PEFCAR_MAILBOX3			0x00100000
#define PEFCAR_D				0x00080000
#define PEFCAR_CTLS				0x00000010
#define PEFCAR_EF				0x00000008
#define PEFCAR_EAS				0x00000007

/* Source Operations Capability Register (SOCAR) */
#define SOCAR_R					0x80000000
#define SOCAR_IR				0x40000000
#define SOCAR_RO				0x20000000
#define SOCAR_DCI				0x10000000
#define SOCAR_C					0x08000000
#define SOCAR_F					0x04000000
#define SOCAR_IOR				0x02000000
#define SOCAR_ICI				0x01000000
#define SOCAR_TIE				0x00800000
#define SOCAR_TIES				0x00400000
#define SOCAR_NR				0x00008000
#define SOCAR_NW				0x00004000
#define SOCAR_SW				0x00002000
#define SOCAR_NWR				0x00001000
#define SOCAR_M					0x00000800
#define SOCAR_D					0x00000400
#define SOCAR_ATS				0x00000100
#define SOCAR_AI				0x00000080
#define SOCAR_AD				0x00000040
#define SOCAR_AS				0x00000020
#define SOCAR_AC				0x00000010
#define SOCAR_PW				0x00000004

/* Destination Operations Capability Register (DOCAR) */
#define DOCAR_R					SOCAR_R
#define DOCAR_IR				SOCAR_IR
#define DOCAR_RO				SOCAR_RO
#define DOCAR_DCI				SOCAR_DCI
#define DOCAR_C					SOCAR_C
#define DOCAR_F					SOCAR_F
#define DOCAR_IOR				SOCAR_IOR
#define DOCAR_ICI				SOCAR_ICI
#define DOCAR_TIE				SOCAR_TIE
#define DOCAR_TIES				SOCAR_TIES
#define DOCAR_NR				SOCAR_NR
#define DOCAR_NW				SOCAR_NW
#define DOCAR_SW				SOCAR_SW
#define DOCAR_NWR				SOCAR_NWR
#define DOCAR_M					SOCAR_M
#define DOCAR_D					SOCAR_D
#define DOCAR_ATS				SOCAR_ATS
#define DOCAR_AI				SOCAR_AI
#define DOCAR_AD				SOCAR_AD
#define DOCAR_AS				SOCAR_AS
#define DOCAR_AC				SOCAR_AC
#define DOCAR_PW				SOCAR_PW

/* Mailbox Command and Status Register (MSR) */
#define MSR_A					0x80000000
#define MSR_FU					0x40000000
#define MSR_EM					0x20000000
#define MSR_B					0x10000000
#define MSR_FA					0x08000000
#define MSR_ERR					0x04000000

/* Port Write and Doorbell Command and Status Register (PWDCSR) */
#define PWDCSR_A				0x80000000
#define PWDCSR_FU				0x40000000
#define PWDCSR_EM				0x20000000
#define PWDCSR_B				0x10000000
#define PWDCSR_FA				0x08000000
#define PWDCSR_ERR				0x04000000
#define PWDCSR_PA				0x00000080
#define PWDCSR_PFU				0x00000040
#define PWDCSR_PEM				0x00000020
#define PWDCSR_PB				0x00000010
#define PWDCSR_PFA				0x00000008
#define PWDCSR_PE				0x00000004

/* Base Device ID Command and Status Register (BDIDCSR) */
#define BDIDCSR_BDID			0x00FF0000
#define BDIDCSR_BDIDs			(31-15)

/* Port Link Time Out Control Command and Status Register (PLTOCCSR) */
#define PLTOCCSR_TV				0xFFFFFF00
#define PLTOCCSR_TVs			(31-23)

/* Port Response Time Out Controll Command and Status Register (PRTOCCSR) */
#define PRTOCCSR_TV				0xFFFFFF00
#define PRTOCCSR_TVs			(31-23)

/* Port General Control and Command Status Register (PGCCSR) */
#define PGCCSR_H				0x80000000
#define PGCCSR_M				0x40000000
#define PGCCSR_D				0x20000000

/* Port Error and Status Command and Status Register (PESCSR) */
#define PESCSR_ORE				0x00100000
#define PESCSR_OR				0x00080000
#define PESCSR_ORS				0x00040000
#define PESCSR_OEE				0x00020000
#define PESCSR_OES				0x00010000
#define PESCSR_IRS				0x00000400
#define PESCSR_IEE				0x00000200
#define PESCSR_IES				0x00000100
#define PESCSR_PP				0x00000008
#define PESCSR_PE				0x00000004
#define PESCSR_PO				0x00000002
#define PESCSR_PU				0x00000001

/* Port Control Command and Status Register (PCCSR) */
#define PCCSR_OPW				0x80000000
#define PCCSR_OPE				0x40000000
#define PCCSR_OPD				0x20000000
#define PCCSR_IPW				0x08000000
#define PCCSR_IPE				0x04000000
#define PCCSR_IPD				0x02000000
#define PCCSR_ECD				0x00800000
#define PCCSR_TOD				0x00400000

/* Configuration Register (CR) */
#define CR_PTE					0x00000002
#define CR_AA					0x00000001

/* Port Configuration Register (PCR) */
#define PCR_RTD					0x00000100
#define PCR_LTD					0x00000080
#define PCR_QD					0x00000040
#define PCR_CB					0x00000020
#define PCR_CCE					0x00000010

/* RapidIO Outbound Window Attributes Register (ROWAR) */
#define ROWAR_EN					0x80000000
#define ROWAR_TFLOLV				0x0c000000
#define ROWAR_TFLOLVs				(31-5)
#define ROWAR_TFLOLV_LOWEST			0x00000000
#define ROWAR_TFLOLV_NEXT_HIGHEST	0x04000000
#define ROWAR_TFLOLV_HIGHEST		0x08000000
#define ROWAR_PCI_ORDERING			0x02000000
#define ROWAR_RDTYP					0x000F0000
#define ROWAR_RDTYPs				(31-15)
#define ROWAR_RDTYP_IO_READ_HOME	0x00020000
#define ROWAR_RDTYP_NREAD			0x00040000
#define ROWAR_RDTYP_MAINTENANCE		0x00020000
#define ROWAR_RDTYP_ATOMIC_INC		0x000C0000
#define ROWAR_RDTYP_ATOMIC_DEC		0x000D0000
#define ROWAR_RDTYP_ATOMIC_SET		0x000E0000
#define ROWAR_RDTYP_ATOMIC_CLR		0x000F0000
#define ROWAR_WRTYP					0x0000F000
#define ROWAR_WRTYPs				(31-19)
#define ROWAR_WRTYP_FLUSH_WITH_DATA	0x00001000
#define ROWAR_WRTYP_DOORBELL		0x00002000
#define ROWAR_WRTYP_SWRITE			0x00003000
#define ROWAR_WRTYP_NWRITE			0x00004000
#define ROWAR_WRTYP_NWRITE_R		0x00005000
#define ROWAR_WRTYP_MAINTENANCE		0x00007000
#define ROWAR_SIZE					0x0000003F
#define ROWAR_SIZEs					(0-0)

/* RapidIO Inbound Window Attributes Register (RIWAR) */
#define RIWAR_EN						0x80000000
#define RIWAR_TGINT						0x00F00000
#define RIWAR_TGINTs					(31-11)
#define RIWAR_TGINT_LOCAL_MEMORY		0x00F00000
#define RIWAR_TGINT_PCI_PCIX			0x00000000
#define RIWAR_RDTYP						0x000F0000
#define RIWAR_RDTYPs					(31-15)
#define RIWAR_RDTYP_READ				0x00040000
#define RIWAR_RDTYP_READ_SNOOP			0x00050000
#define RIWAR_RDTYP_READ_UNLOCK_L2		0x00070000
#define RIWAR_WRTYP						0x0000F000
#define RIWAR_WRTYPs					(31-19)
#define RIWAR_WRTYP_WRITE				0x00004000
#define RIWAR_WRTYP_WRITE_NO_SNOOP		0x00004000
#define RIWAR_WRTYP_WRITE_SNOOP			0x00005000
#define RIWAR_WRTYP_WRITE_ALLOC_L2		0x00006000
#define RIWAR_WRTYP_WRITE_ALLOC_LOCK_L2	0x00007000

/* Port Notification and Fatal Error Detect Register (PNFEDR) */
#define PNFEDR_MFE				0x80000000
#define PNFEDR_AXE				0x40000000
#define PNFEDR_ITE				0x02000000
#define PNFEDR_MSE				0x01000000
#define PNFEDR_NTIE				0x00800000
#define PNFEDR_SE				0x00400000
#define PNFEDR_DSE				0x00200000
#define PNFEDR_BME				0x00100000
#define PNFEDR_ETE				0x00080000
#define PNFEDR_RTE				0x00040000
#define PNFEDR_RERE				0x00020000
#define PNFEDR_LTE				0x00010000
#define PNFEDR_RSTE				0x00008000
#define PNFEDR_NAE				0x00004000
#define PNFEDR_IRFE				0x00002000
#define PNFEDR_URDE				0x00001000
#define PNFEDR_URE				0x00000800
#define PNFEDR_URSE				0x00000400
#define PNFEDR_IWRE				0x00000200
#define PNFEDR_IRSFE			0x00000100
#define PNFEDR_IRTE				0x00000080
#define PNFEDR_BREE				0x00000040
#define PNFEDR_BWRE				0x00000020
#define PNFEDR_URSSE			0x00000010
#define PNFEDR_URESE			0x00000008
#define PNFEDR_URSDE			0x00000004
#define PNFEDR_MERE				0x00000002
#define PNFEDR_MDFE				0x00000001

/* Port Notification and Fatal Error Disable Register (PNFEDIR) */
#define PNFEDIR_AXD				0x40000000
#define PNFEDIR_ITD				0x02000000
#define PNFEDIR_MSD				0x01000000
#define PNFEDIR_NTID			0x00800000
#define PNFEDIR_SD				0x00400000
#define PNFEDIR_DSD				0x00200000
#define PNFEDIR_BMD				0x00100000
#define PNFEDIR_ETD				0x00080000
#define PNFEDIR_RTD				0x00040000
#define PNFEDIR_RERD			0x00020000
#define PNFEDIR_LTD				0x00010000
#define PNFEDIR_RSTD			0x00008000
#define PNFEDIR_NAD				0x00004000
#define PNFEDIR_IRFD			0x00002000
#define PNFEDIR_URDD			0x00001000
#define PNFEDIR_URD				0x00000800
#define PNFEDIR_URSD			0x00000400
#define PNFEDIR_IWRD			0x00000200
#define PNFEDIR_IRSFD			0x00000100
#define PNFEDIR_IRTD			0x00000080
#define PNFEDIR_BRRD			0x00000040
#define PNFEDIR_BWRD			0x00000020
#define PNFEDIR_URSSD			0x00000010
#define PNFEDIR_URESD			0x00000008
#define PNFEDIR_URSDD			0x00000004
#define PNFEDIR_MERD			0x00000002
#define PNFEDIR_MDFD			0x00000001
#define PNFEDIR_DEFAULT			0x00000000

/* Port Notification and Fatal Error Interrupt Enable Register (PNFEIER) */
#define PNFEIER_AXIE			0x40000000
#define PNFEIER_ITIE			0x02000000
#define PNFEIER_MSIE			0x01000000
#define PNFEIER_NTIIE			0x00800000
#define PNFEIER_SIE				0x00400000
#define PNFEIER_DSIE			0x00200000
#define PNFEIER_BMIE			0x00100000
#define PNFEIER_ETIE			0x00080000
#define PNFEIER_RTIE			0x00040000
#define PNFEIER_RERIE			0x00020000
#define PNFEIER_LTIE			0x00010000
#define PNFEIER_RSTIE			0x00008000
#define PNFEIER_NAIE			0x00004000
#define PNFEIER_IRFIE			0x00002000
#define PNFEIER_URDIE			0x00001000
#define PNFEIER_URIE			0x00000800
#define PNFEIER_URSIE			0x00000400
#define PNFEIER_IWRIE			0x00000200
#define PNFEIER_IRSFIE			0x00000100
#define PNFEIER_IRTIE			0x00000080
#define PNFEIER_BRRIE			0x00000040
#define PNFEIER_BWRIE			0x00000020
#define PNFEIER_URSSIE			0x00000010
#define PNFEIER_URESIE			0x00000008
#define PNFEIER_URSDIE			0x00000004
#define PNFEIER_MERIE			0x00000002
#define PNFEIER_MDFIE			0x00000001
#define PNFEIER_DEFAULT			0x00000000

/* Port Recoverable Error Detect Register (PREDR) */
#define PREDR_MRE				0x80000000
#define PREDR_ETE				0x01000000
#define PREDR_ISE				0x00800000
#define PREDR_ICCE				0x00400000
#define PREDR_IAOSE				0x00200000
#define PREDR_IUAE				0x00100000
#define PREDR_IBCE				0x00080000
#define PREDR_IE276E			0x00040000
#define PREDR_INAIE				0x00020000
#define PREDR_INAUA				0x00010000
#define PREDR_INACC				0x00008000
#define PREDR_INAPS				0x00004000
#define PREDR_INABC				0x00002000
#define PREDR_INASE				0x00001000
#define PREDR_INAGE				0x00000800
#define PREDR_URE				0x00000400
#define PREDR_UAE				0x00000200
#define PREDR_ABRE				0x00000100
#define PREDR_UTE				0x00000080
#define PREDR_USE				0x00000040
#define PREDR_ULE				0x00000020
#define PREDR_UEE				0x00000010
#define PREDR_LRE				0x00000008
#define PREDR_FAE				0x00000004
#define PREDR_FTEE				0x00000002
#define PREDR_ATE				0x00000001

/* Outbound Mode Register (OMR) */
#define OMR_MUS					0x00000001
#define OMR_MUI					0x00000002
#define OMR_MUTM				0x00000004
#define OMR_QEIE				0x00000040
#define OMR_QFIE				0x00000100
#define OMR_QOIE				0x00000200
#define OMR_DES_SEN				0x00100000
#define OMR_CIRC_SIZ			0x0000F000
#define OMR_CIRC_SIZs			(31-19)
#define OMR_CIRQ_SIZ_2			0x00000000
#define OMR_CIRQ_SIZ_4			0x00001000
#define OMR_CIRQ_SIZ_8			0x00002000
#define OMR_CIRQ_SIZ_16			0x00003000
#define OMR_CIRQ_SIZ_32			0x00004000
#define OMR_CIRQ_SIZ_64			0x00005000
#define OMR_CIRQ_SIZ_128		0x00006000
#define OMR_CIRQ_SIZ_256		0x00007000
#define OMR_CIRQ_SIZ_512		0x00008000
#define OMR_CIRQ_SIZ_1024		0x00009000
#define OMR_CIRQ_SIZ_2048		0x0000A000

/* Outbound Status Register (OSR) */
#define OSR_QF					0x00100000
#define OSR_TE					0x00000080
#define OSR_QOI					0x00000020
#define OSR_QFI					0x00000010
#define OSR_MUB					0x00000004
#define OSR_EOMI				0x00000002
#define OSR_QEI					0x00000001

/* Outbound Source Address Register (OSAR) */
#define OSAR_SNEN				0x00000004

/* Outbound Destination Port Register (ODPR) */
#define ODPR_MAILBOX			0x00000003

/* Outbound Destination Attributes Register (ODATR) */
#define ODATR_EOMIE						0x20000000
#define ODATR_DTFLOWLVL					0x0C000000
#define ODATR_DTFLOWLVLs				(31-5)
#define ODATR_DTFLOWLVL_LOWEST			0x00000000
#define ODATR_DTFLOWLVL_NEXT_HIGHEST	0x04000000
#define ODATR_DTFLOWLVL_HIGHEST			0x08000000
#define ODATR_DWRITETTYPE				0x00060000
#define ODATR_DTGTROUTE					0x000003FC
#define ODATR_DTGTROUTEs				(31-29)

/* Outbound Double Word Count Register (ODCR) */
#define ODCR_INVALID_SIZE				0
#define ODCR_DCR						0x00001FF8
#define ODCR_DCRs						(31-28)
#define ODCR_DCR_8_BYTES				1<<3
#define ODCR_DCR_16_BYTES				1<<4
#define ODCR_DCR_32_BYTES				1<<5
#define ODCR_DCR_64_BYTES				1<<6
#define ODCR_DCR_128_BYTES				1<<7
#define ODCR_DCR_256_BYTES				1<<8
#define ODCR_DCR_512_BYTES				1<<9
#define ODCR_DCR_1024_BYTES				1<<10
#define ODCR_DCR_2048_BYTES				1<<11
#define ODCR_DCR_4096_BYTES				1<<12

/* Inbound Mode Register (IMR) */
#define IMR_ME					0x00000001
#define IMR_MI					0x00000002
#define IMR_MIQIE				0x00000040
#define IMR_QFIE				0x00000100
#define IMR_CIRQ_SIZ			0x0000F000
#define IMR_CIRQ_SIZs			(31-19)
#define IMR_CIRQ_SIZ_2			OMR_CIRQ_SIZ_2
#define IMR_CIRQ_SIZ_4			OMR_CIRQ_SIZ_4
#define IMR_CIRQ_SIZ_8			OMR_CIRQ_SIZ_8
#define IMR_CIRQ_SIZ_16			OMR_CIRQ_SIZ_16
#define IMR_CIRQ_SIZ_32			OMR_CIRQ_SIZ_32
#define IMR_CIRQ_SIZ_64			OMR_CIRQ_SIZ_64
#define IMR_CIRQ_SIZ_128		OMR_CIRQ_SIZ_128
#define IMR_CIRQ_SIZ_256		OMR_CIRQ_SIZ_256
#define IMR_CIRQ_SIZ_512		OMR_CIRQ_SIZ_512
#define IMR_CIRQ_SIZ_1024		OMR_CIRQ_SIZ_1024
#define IMR_CIRQ_SIZ_2048		OMR_CIRQ_SIZ_2048
#define IMR_FRM_SIZ				0x000F0000
#define IMR_FRM_SIZs			(31-15)
#define IMR_FRM_SIZ_8			0x00020000
#define IMR_FRM_SIZ_16			0x00030000
#define IMR_FRM_SIZ_32			0x00040000
#define IMR_FRM_SIZ_64			0x00050000
#define IMR_FRM_SIZ_128			0x00060000
#define IMR_FRM_SIZ_256			0x00070000
#define IMR_FRM_SIZ_512			0x00080000
#define IMR_FRM_SIZ_1024 		0x00090000
#define IMR_FRM_SIZ_2048		0x000A0000
#define IMR_FRM_SIZ_4096		0x000B0000
#define IMR_SEN					0x00100000

/* Inbound Status Register (ISR) */
#define ISR_QF					0x00100000
#define ISR_MIQ					0x00010000
#define ISR_TE					0x00000080
#define ISR_QFI					0x00000010
#define ISR_MB					0x00000004
#define ISR_MIQI				0x00000001

/* Doorbell Mode Register (DMR) */
#define DMR_DE					0x00000001
#define DMR_DI					0x00000002
#define DMR_DIQIE				0x00000040
#define DMR_QFIE				0x00000100
#define DMR_SEN					0x00100000

/* Doorbell Status Register (DSR) */
#define DSR_QF					0x00100000
#define DSR_DIQ					0x00010000
#define DSR_TE					0x00000080
#define DSR_QFI					0x00000010
#define DSR_QIQI				0x00000001

/* Port Write Mode Register (PWMR) */
#define PWMR_PWE				0x00000001
#define PWMR_CQ					0x00000002
#define PWMR_QFIE				0x00000100
#define PWMR_SEN				0x00010000

/* Port Write Status Register (PWSR) */
#define PWSR_QF					0x00100000
#define PWSR_TE					0x00000080
#define PWSR_QFI				0x00000010
#define PWSR_PWB				0x00000004

/* Port Error Recovery Threshold Register (PERTR) */
#define PERTR_RCTT				0x00FF0000
#define PERTR_RCTTs				(31-15)

/* Port Retry Threshold Register (PRTR) */
#define PRTR_RCTT				0x00FF0000
#define PRTR_RCTTs				(31-15)

