/*-----------------------------------------------------------------------------
*
* $Header: n:/pcmrcs/NCdrivers/headers/mpq_lbc.h 0.1.1.3 2004/07/26 15:36:59 jdabbraccio Exp $
*
* Copyright Freescale Semiconductor, Inc. 2003-2004.  All rights reserved.
*
* Description:	Local Bus Controller Registers.
*
*----------------------------------------------------------------------------*/


typedef _Packed struct
{
	reg32 br;
	reg32 or;
}
_PackedType br_or;

typedef _Packed struct
{
#if MPC8250 || MPC8255 || MPC8260 || MPC8264 || MPC8265 || MPC8266
	br_or bank[12];
	byte _reserved0[0x08];
#elif MPC8540 || MPC8555 || MPC8560
	br_or bank[8];
	byte _reserved0[0x28];
#endif
	reg32 mar;
	byte _reserved1[0x04];
	reg32 mamr;
	reg32 mbmr;
	reg32 mcmr;
	byte _reserved2[0x08];
#if MPC8250 || MPC8255 || MPC8260 || MPC8264 || MPC8265 || MPC8266
	reg16 mptpr;
	byte _reserved3[0x02];
	reg32 mdr;
	byte _reserved4[0x04];
	reg32 psdmr;
	reg32 lsdmr;
	reg08 purt;
	byte _reserved5[0x03];
	reg08 psrt;
	byte _reserved6[0x03];
	reg08 lurt;
	byte _reserved7[0x03];
	reg08 lsrt;
	byte _reserved8[0x03];
	reg32 immr;
#if MPC8250 || MPC8265 || MPC8266
	reg32 pcibr0;
	reg32 pcibr1;
	byte _reserved9[0x10];
	reg32 pcimsk0;
	reg32 pcimsk1;
	byte _reserved10[0x34];
#else
	byte _reserved9[0x54];
#endif
#elif MPC8540 || MPC8555 || MPC8560
	reg32 mrtpr;
	reg32 mdr;
	byte _reserved3[0x08];
	reg32 lsdmr;
	byte _reserved4[0x08];
	reg32 lurt;
	reg32 lsrt;
	byte _reserved5[0x08];
	reg32 ltesr;
	reg32 ltedr;
	reg32 lteir;
	reg32 lteatr;
	reg32 ltear;
	byte _reserved6[0x0C];
	reg32 lbcr;
	reg32 lcrr;
	byte _reserved7[0x2F28];
#endif
}
_PackedType mpq_lbc, cpm_memc;

