/*-----------------------------------------------------------------------------
*
* $Header: n:/pcmrcs/NCdrivers/headers/mpq_l2sram.h 0.1.1.4 2004/12/20 22:35:43 jdabbraccio Exp $
*
* Copyright Freescale Semiconductor, Inc. 2003-2004.  All rights reserved.
*
* Description:	L2SRAM Registers.
*
*----------------------------------------------------------------------------*/


#define MAX_NUM_CACHE_REGIONS	4
#define L2CEWCR_E				0x80000000
#define L2CEWCR_LOCK			0x40000000
#define L2CEWCR_256_BYTES		0x00FFFFFF
#define L2CEWCR_512_BYTES		0x00FFFFFE
#define L2CEWCR_1024_BYTES		0x00FFFFFC
#define L2CEWCR_2048_BYTES		0x00FFFFF8
#define L2CEWCR_4096_BYTES		0x00FFFFF0
#define L2CEWCR_8192_BYTES		0x00FFFFE0


typedef _Packed struct
{
	reg32 l2cewar;
	byte _reserved[0x04];
	reg32 l2cewcr;
	byte _reserved2[0x04];
}
_PackedType l2sram_ew;

typedef _Packed struct
{
	reg32 l2ctl;
	byte _reserved0[0x0C];
	l2sram_ew l2sram_ew[4];	/* MAX_NUM_CACHE_REGIONS */
	byte _reserved8[0xB0];
	reg32 l2srbar0;
	byte _reserved9[0x04];
	reg32 l2srbar1;
	byte _reserved10[0xCF4];
	reg32 l2errinjhi;
	reg32 l2errinjlo;
	reg32 l2errinjctl;
	byte _reserved11[0x14];
	reg32 l2captdatahi;
	reg32 l2captdatalo;
	reg32 l2captecc;
	byte _reserved12[0x14];
	reg32 l2errdet;
	reg32 l2errdis;
	reg32 l2errinten;
	reg32 l2errattr;
	reg32 l2erraddr;
	byte _reserved13[0x04];
	reg32 l2errctl;
	byte _reserved14[0x2A4];
}
_PackedType mpq_l2sram;
