/*-----------------------------------------------------------------------------
*
* $Header: n:/pcmrcs/NCdrivers/headers/mpq_duart.h 0.0.1.2 2004/07/26 15:36:58 jdabbraccio Exp $
*
* Copyright Freescale Semiconductor, Inc. 2004.  All rights reserved.
*
* Description:	Dual UART (DUART) Registers.
*
*----------------------------------------------------------------------------*/


typedef _Packed struct
{
	reg08 urbr;	/* DLAB = 0, read */
	reg08 uier;	/* DLAB = 0, read/write */
	reg08 uiir;	/* DLAB = 0, read */
	reg08 ulcr;	/* DLAB = x, read/write */
	reg08 umcr;	/* DLAB = x, read/write */
	reg08 ulsr;	/* DLAB = x, read */
	reg08 umsr;	/* DLAB = x, read */
	reg08 uscr;	/* DLAB = x, read/write */
	byte _reserved0[0x08];
	reg08 udsr;	/* DLAB = x, read */
	byte _reserved1[0xEF];
}
_PackedType mpq_uart;

#define	uthr	urbr	/* DLAB = 0, write */
#define	udlb	urbr	/* DLAB = 1, read/write */
#define	udmb	uier	/* DLAB = 1, read/write */
#define	ufcr	uiir	/* DLAB = 0, write */
#define	uafr	uiir	/* DLAB = 1, read/write */
