/*-----------------------------------------------------------------------------
*
* $Header: n:/pcmrcs/NCdrivers/headers/mpq_cpm.h 0.1.1.4 2004/07/26 15:36:56 jdabbraccio Exp $
*
* Copyright Freescale Semiconductor, Inc. 2003-2004.  All rights reserved.
*
* Description:	Structures internal to the CPM.
*
*----------------------------------------------------------------------------*/


#include "mpq_cpm_pram.h"

/*-----------------------------------------------------------------------------
*
*		General purpose Dual Port RAM (DPRAM)
*		Structure within 0x0000_0000 - 0x0000_FFFF (relative)
*
*----------------------------------------------------------------------------*/

typedef _Packed struct
{
#if MPC8555
	byte data[8*KBYTES];
	byte _reserved0[24*KBYTES];
#else
	byte data[16*KBYTES];
#if MPC8560
	byte _reserved0[16*KBYTES];
#endif
#endif
}
_PackedType cpm_dpram1;


#if ((MPC8250 || MPC8255 || MPC8260 || MPC8264 || MPC8265 || MPC8266) && (MPQ_HIP >= 4))
typedef byte dpramuc[8*KBYTES];
#elif MPC8555
typedef byte dpramuc[4*KBYTES];
#elif MPC8560
typedef byte dpramuc[32*KBYTES];
#endif

typedef _Packed struct
{
#if ((MPC8250 || MPC8255 || MPC8260 || MPC8264 || MPC8265 || MPC8266) && (MPQ_HIP >= 4))
	dpramuc ucode;
	byte _reserved0[8*KBYTES];
#elif MPC8555
	dpramuc ucode;
	byte _reserved0[252*KBYTES];
#elif MPC8560
	dpramuc ucode;
	byte _reserved0[96*KBYTES];
#else
	byte _reserved0[16*KBYTES];
#endif
}
_PackedType cpm_dpramuc;


typedef _Packed struct
{
#if MPC8260 || MPC8264 || MPC8265 || MPC8266
	scc_pram scc[4];
	fcc_pram fcc[3];
	mcc_pram mcc[2];
	byte _reserved0[0xFC];
	reg16 spi_base;
	byte _reserved1[0xE2];
	reg32 risc_timer[4];
	reg16 rev_num;
	byte _reserved2[0x06];
	reg32 rand;
	reg16 i2c_base;
	byte _reserved3[0x502];
#elif MPC8555 || MPC8560
	scc_pram scc[4];
	fcc_pram fcc[3];
	mcc_pram mcc[2];
	byte _reserved0[0xFC];
	reg16 spi_base;
	byte _reserved1[0xE2];
	reg32 risc_timer[4];
	reg16 rev_num;
	byte _reserved2[0x06];
	reg32 rand;
	reg16 i2c_base;
	byte _reserved3[0x502];
#else
	byte _reserved0[16*KBYTES];
#endif
}
_PackedType cpm_pram;


typedef _Packed struct
{
	cpm_pram pram;
#if MPC8250 || MPC8255 || MPC8260 || MPC8264 || MPC8265 || MPC8266
#if (MPQ_HIP >= 7)
	byte data[8*KBYTES];
#else
	byte _reserved0[8*KBYTES];
#endif
#elif MPC8555
	byte data[4*KBYTES];
	byte _reserved0[24*KBYTES];
#elif MPC8560
	byte data[12*KBYTES];
	byte _reserved0[16*KBYTES];
#endif
}
_PackedType cpm_dpram2;


typedef _Packed struct
{
	byte data[4*KBYTES];
	byte _reserved0[16*KBYTES];
}
_PackedType cpm_dpram3;


/*-----------------------------------------------------------------------------
*
*		e500 Core Interface (MPC8560 only)
*
*----------------------------------------------------------------------------*/

typedef _Packed struct
{
	reg32 cear;
	reg16 ceer;
	reg16 cemr;
	byte _reserved[0x48];
}
_PackedType cpm_e500core;


/*-----------------------------------------------------------------------------
*
*		General SIU (System Interface Unit)
*
*----------------------------------------------------------------------------*/

typedef _Packed struct
{
#if MPC8555 || MPC8560
	reg32 smaer;
	reg32 smser;
	reg32 smevr;
	reg32 smctr;
	reg32 lmaer;
	reg32 lmser;
	reg32 lmevr;
	reg32 lmctr;
	byte _reserved[0xB90];
#else
	reg32 siumcr;
	reg32 sypcr;
	byte _reserved0[0x06];
	reg16 swsr;
	byte _reserved1[0x14];
	reg32 bcr;
	reg08 ppc_acr;
	byte _reserved2[0x03];
	reg32 ppc_alrh;
	reg32 ppc_alrl;
	reg08 lcl_acr;
	byte _reserved3[0x03];
	reg32 lcl_alrh;
	reg32 lcl_alrl;
	reg32 tescr1;
	reg32 tescr2;
	reg32 l_tescr1;
	reg32 l_tescr2;
	reg32 pdtea;
	reg08 pdtem;
	byte _reserved4[0x03];
	reg32 ldtea;
	reg08 ldtem;
	byte _reserved5[0xA3];
#endif
}
_PackedType cpm_siu;


/*-----------------------------------------------------------------------------
*
*		Memory Controller
*
*----------------------------------------------------------------------------*/

#if !(MPC8555 || MPC8560)
#include "mpq_lbc.h"
#endif

/*-----------------------------------------------------------------------------
*
*		System Integration Timers
*
*----------------------------------------------------------------------------*/

typedef _Packed struct
{
	byte _reserved0[0x20];
	reg16 tmcntsc;
	byte _reserved1[0x02];
	reg32 tmcnt;
	byte _reserved2[0x04];
	reg32 tmcntal;
	byte _reserved3[0x10];
	reg16 piscr;
	byte _reserved4[0x02];
	reg32 pitc;
	reg32 pitr;
	byte _reserved5[0x1B4];
	
}
_PackedType cpm_sitimers;


/*-----------------------------------------------------------------------------
*
*		PCI
*
*----------------------------------------------------------------------------*/

typedef _Packed struct
{
#if MPC8250 || MPC8265 || MPC8266
	byte _reserved0[0x30];
	reg32 omisr;
	reg32 omimr;
	byte _reserved1[0x08];
	/* incomplete */
#else
	byte _reserved0[0x800];
#endif
}
_PackedType cpm_pci;


/*-----------------------------------------------------------------------------
*
*		Interrupt Controller
*
*----------------------------------------------------------------------------*/

typedef _Packed struct
{
	reg16 sicr;
	byte _reserved0[0x02];
	reg32 sivec;
	reg32 sipnr_h;
	reg32 sipnr_l;
	reg32 siprr;
	reg32 scprr_h;
	reg32 scprr_l;
	reg32 simr_h;
	reg32 simr_l;
	reg32 siexr;
	byte _reserved1[0x58];
#if MPC8555 || MPC8560
	reg32 sccr;
	byte _reserved2[0x7C];
#endif
}
_PackedType cpm_ic;

/* Interrupt code in SIU Interrupt Vector Register (SIVEC) */
#define CPM_IRQ_OFFSET		0
#define SIVEC_ERROR			(0x00+CPM_IRQ_OFFSET)
#define SIVEC_I2C			(0x01+CPM_IRQ_OFFSET)
#define SIVEC_SPI			(0x02+CPM_IRQ_OFFSET)
#define SIVEC_RISC_TIMERS	(0x03+CPM_IRQ_OFFSET)
#define SIVEC_SMC1			(0x04+CPM_IRQ_OFFSET)
#define SIVEC_SMC2			(0x05+CPM_IRQ_OFFSET)
#define SIVEC_IDMA1			(0x06+CPM_IRQ_OFFSET)
#define SIVEC_IDMA2			(0x07+CPM_IRQ_OFFSET)
#define SIVEC_IDMA3			(0x08+CPM_IRQ_OFFSET)
#define SIVEC_IDMA4			(0x09+CPM_IRQ_OFFSET)
#define SIVEC_SDMA			(0x0A+CPM_IRQ_OFFSET)
#define SIVEC_TIMER1		(0x0C+CPM_IRQ_OFFSET)
#define SIVEC_TIMER2		(0x0D+CPM_IRQ_OFFSET)
#define SIVEC_TIMER3		(0x0E+CPM_IRQ_OFFSET)
#define SIVEC_TIMER4		(0x0F+CPM_IRQ_OFFSET)
#define SIVEC_TMCNT			(0x10+CPM_IRQ_OFFSET)
#define SIVEC_PIT			(0x11+CPM_IRQ_OFFSET)
#define SIVEC_PCI			(0x12+CPM_IRQ_OFFSET)
#define SIVEC_IRQ1			(0x13+CPM_IRQ_OFFSET)
#define SIVEC_IRQ2			(0x14+CPM_IRQ_OFFSET)
#define SIVEC_IRQ3			(0x15+CPM_IRQ_OFFSET)
#define SIVEC_IRQ4			(0x16+CPM_IRQ_OFFSET)
#define SIVEC_IRQ5			(0x17+CPM_IRQ_OFFSET)
#define SIVEC_IRQ6			(0x18+CPM_IRQ_OFFSET)
#define SIVEC_IRQ7			(0x19+CPM_IRQ_OFFSET)
#define SIVEC_FCC1			(0x20+CPM_IRQ_OFFSET)
#define SIVEC_FCC2			(0x21+CPM_IRQ_OFFSET)
#define SIVEC_FCC3			(0x22+CPM_IRQ_OFFSET)
#define SIVEC_MCC1			(0x24+CPM_IRQ_OFFSET)
#define SIVEC_MCC2			(0x25+CPM_IRQ_OFFSET)
#define SIVEC_SCC1			(0x28+CPM_IRQ_OFFSET)
#define SIVEC_SCC2			(0x29+CPM_IRQ_OFFSET)
#define SIVEC_SCC3			(0x2A+CPM_IRQ_OFFSET)
#define SIVEC_SCC4			(0x2B+CPM_IRQ_OFFSET)
#define SIVEC_TC_LAYER		(0x2C+CPM_IRQ_OFFSET)
#define SIVEC_PC15			(0x30+CPM_IRQ_OFFSET)
#define SIVEC_PC14			(0x31+CPM_IRQ_OFFSET)
#define SIVEC_PC13			(0x32+CPM_IRQ_OFFSET)
#define SIVEC_PC12			(0x33+CPM_IRQ_OFFSET)
#define SIVEC_PC11			(0x34+CPM_IRQ_OFFSET)
#define SIVEC_PC10			(0x35+CPM_IRQ_OFFSET)
#define SIVEC_PC9			(0x36+CPM_IRQ_OFFSET)
#define SIVEC_PC8			(0x37+CPM_IRQ_OFFSET)
#define SIVEC_PC7			(0x38+CPM_IRQ_OFFSET)
#define SIVEC_PC6			(0x39+CPM_IRQ_OFFSET)
#define SIVEC_PC5			(0x3A+CPM_IRQ_OFFSET)
#define SIVEC_PC4			(0x3B+CPM_IRQ_OFFSET)
#define SIVEC_PC3			(0x3C+CPM_IRQ_OFFSET)
#define SIVEC_PC2			(0x3D+CPM_IRQ_OFFSET)
#define SIVEC_PC1			(0x3E+CPM_IRQ_OFFSET)
#define SIVEC_PC0			(0x3F+CPM_IRQ_OFFSET)
#define SIVEC_LAST			SIVEC_PC0

/* SIU Interrupt Mask Register - low (SIMR_L) */
#define SIMR_L_FCC1			0x80000000
#define SIMR_L_FCC2			0x40000000
#define SIMR_L_FCC3			0x20000000
#define SIMR_L_MCC1			0x08000000
#define SIMR_L_MCC2			0x04000000
#define SIMR_L_SCC1			0x00800000
#define SIMR_L_SCC2			0x00400000
#define SIMR_L_SCC3			0x00200000
#define SIMR_L_SCC4			0x00100000
#define SIMR_L_I2C			0x00008000
#define SIMR_L_SDMA			0x00000040
#define SIMR_L_TIMER1		0x00000010
#define SIMR_L_TIMER2		0x00000008
#define SIMR_L_TIMER3		0x00000004
#define SIMR_L_TIMER4		0x00000002


/*-----------------------------------------------------------------------------
*
*		Clocks and Reset
*
*----------------------------------------------------------------------------*/

typedef _Packed struct
{
	reg32 sccr;
	byte _reserved0[0x04];
	reg32 scmr;
	byte _reserved1[0x04];
	reg32 rsr;
	reg32 rmr;
	byte _reserved2[0x68];
}
_PackedType cpm_clocks;

#define SCCR_DFBRG		0x00000003
#define SCCR_DFBRGs		(31-31)

#define SCMR_PLLDF		0x00001000
#define SCMR_PLLDFs		(31-19)
#define SCMR_PLLMF		0x00000fff
#define SCMR_PLLMFs		(31-31)


/*-----------------------------------------------------------------------------
*
*		Input/Output Port
*
*----------------------------------------------------------------------------*/

typedef _Packed struct
{
	reg32 pdir;
	reg32 ppar;
	reg32 psor;
	reg32 podr;
	reg32 pdat;
	reg08 reserved41[0x0C];
}
_PackedType cpm_iop;


/*-----------------------------------------------------------------------------
*
*		CPM Timers
*
*----------------------------------------------------------------------------*/

typedef _Packed struct
{
	reg08 tgcr1;
	byte _reserved0[0x03];
	reg08 tgcr2;
	byte _reserved1[0x0B];
	reg16 tmr1;
	reg16 tmr2;
	reg16 trr1;
	reg16 trr2;
	reg16 tcr1;
	reg16 tcr2;
	reg16 tcn1;
	reg16 tcn2;
	reg16 tmr3;
	reg16 tmr4;
	reg16 trr3;
	reg16 trr4;
	reg16 tcr3;
	reg16 tcr4;
	reg16 tcn3;
	reg16 tcn4;
	reg16 ter1;
	reg16 ter2;
	reg16 ter3;
	reg16 ter4;
	byte _reserved2[0x260];
}
_PackedType cpm_timers;


/*-----------------------------------------------------------------------------
*
*		SDMA-General
*
*----------------------------------------------------------------------------*/

typedef _Packed struct
{
	reg08 sdsr;
	byte _reserved0[0x03];
	reg08 sdma_sdmr;
	byte _reserved1[0x03];
}
_PackedType cpm_sdma;


/*-----------------------------------------------------------------------------
*
*		IDMA
*
*----------------------------------------------------------------------------*/

typedef _Packed struct
{
	reg08 idsr;
	byte _reserved0[0x03];
	reg08 idmr;
	byte _reserved1[0x03];
}
_PackedType cpm_idma;


/*-----------------------------------------------------------------------------
*
*		FCC
*
*----------------------------------------------------------------------------*/

typedef _Packed struct
{
	reg32 gfmr;
	reg32 fpsmr;
	reg16 ftodr;
	byte _reserved0[0x02];
	reg16 fdsr;
	byte _reserved1[0x02];
	reg32 fcce;
	reg32 fccm;
	reg08 fccs;
	byte _reserved4[0x03];
	reg08 ftirr_phy[4];
}
_PackedType cpm_fcc;

typedef _Packed struct
{
	reg32 firper;
	reg32 firer;
	reg32 firsr_hi;
	reg32 firsr_lo;
	reg08 gfemr;
	byte _reserved0[0x0F];
}
_PackedType cpm_fccir;

/* General FCC Mode Register (GFMR) */
#define GFMR_DIAG			0xC0000000
#define GFMR_TCI			0x20000000
#define GFMR_TRX			0x10000000
#define GFMR_TTX			0x08000000
#define GFMR_CDP			0x04000000
#define GFMR_CTSP			0x02000000
#define GFMR_CDS			0x01000000
#define GFMR_CTSS			0x00800000
#define GFMR_SYNL			0x0000C000
#define GFMR_RTSM			0x00002000
#define GFMR_RENC			0x00001800
#define GFMR_REVD			0x00000400
#define GFMR_TENC			0x00000300
#define GFMR_TCRC			0x000000C0
#define GFMR_ENR			0x00000020
#define GFMR_ENT			0x00000010
#define GFMR_MODE			0x0000000F
#define GFMR_MODE_HDLC		0x00000000
#define GFMR_MODE_ATM		0x0000000A
#define GFMR_MODE_ENET		0x0000000C

/* FCC Protocol Specific Mode Register (FPSMR) */
#define FPSMR_HBC			0x80000000
#define FPSMR_FC			0x40000000
#define FPSMR_SBT			0x20000000
#define FPSMR_LPB			0x10000000
#define FPSMR_LCW			0x08000000
#define FPSMR_FDE			0x04000000
#define FPSMR_MON			0x02000000
#define FPSMR_PRO			0x00400000
#define FPSMR_FCE			0x00200000
#define FPSMR_RSH			0x00100000
#define FPSMR_CAM			0x00000400
#define FPSMR_BRO			0x00000200
#define FPSMR_CRC			0x000000C0

/* FDSR value for Ethernet */
#define FDSR_FCC_ENET		0xD555

/* FCC Ethernet Event/Mask Register (FCCE/FCCM) */
#define FCCE_GRA			0x00800000
#define FCCE_RXC			0x00400000
#define FCCE_TXC			0x00200000
#define FCCE_TXE			0x00100000
#define FCCE_RXF			0x00080000
#define FCCE_BSY			0x00040000
#define FCCE_TXB			0x00020000
#define FCCE_RXB			0x00010000


/*-----------------------------------------------------------------------------
*
*		TC Layer
*
*----------------------------------------------------------------------------*/

typedef _Packed struct
{
	reg16 tcmode;
	reg16 cdsmr;
	reg16 tcer;
	reg16 tc_rcc;
	reg16 tcmr;
	reg16 tc_fcc;
	reg16 tc_ccc;
	reg16 tc_icc;
	reg16 tc_tcc;
	reg16 tc_ecc;
	byte _reserved0[0x0C];
}
_PackedType cpm_tc;


typedef _Packed struct
{
	reg16 tcgsr;
	reg16 tcger;
	byte _reserved0[0xEC];
}
_PackedType cpm_tcgen;


/*-----------------------------------------------------------------------------
*
*		BRGs
*
*----------------------------------------------------------------------------*/

/* Baud Rate Generator Configuration Register (BRGC) */
#define BRGC_RST			0x00020000
#define BRGC_EN				0x00010000
#define BRGC_EXTC			0x0000C000
#define BRGC_ATB			0x00002000
#define BRGC_CD				0x00001FFE
#define BRGC_DIV16			0x00000001


/*-----------------------------------------------------------------------------
*
*		I2C
*
*----------------------------------------------------------------------------*/

typedef _Packed struct
{
	reg08 i2mod;
	byte _reserved0[0x03];
	reg08 i2add;
	byte _reserved1[0x03];
	reg08 i2brg;
	byte _reserved2[0x03];
	reg08 i2com;
	byte _reserved3[0x03];
	reg08 i2cer;
	byte _reserved4[0x03];
	reg08 i2cmr;
	byte _reserved5[0x14B];
}
_PackedType cpm_i2c;

/* I2C Event/MASK Register */
#define I2CER_TXE		0x10
#define I2CER_BSY		0x04
#define I2CER_TXB		0x02
#define I2CER_RXB		0x01

/* I2CMOD masks for I2C Mode Register */
#define I2MOD_REVD		0x20
#define I2MOD_GCD		0x10
#define I2MOD_FLT		0x08
#define I2MOD_PDIV		0x06
#define I2MOD_PDIVs	(7-6)
#define I2MOD_EN		0x01

/* I2CADD: I2C Address Register */
#define I2ADD_SAD		0xFE

/* I2BRG: I2C Baud Rate Generator Register */
#define I2BRG_DIV		0xFF

/* I2COM: I2C Command Register */
#define I2COM_STR		0x80
#define I2COM_MS		0x01

/*-----------------------------------------------------------------------------
*
*		Communications Processor
*
*----------------------------------------------------------------------------*/

typedef _Packed struct
{
	reg32 cpcr;
	reg32 rccr;
	byte _reserved0[0x0E];
	reg16 rter;
	byte _reserved1[0x02];
	reg16 rtmr;
	reg16 rtscr;
	byte _reserved2[0x02];
	reg32 rtsr;
	byte _reserved3[0x0C];
}
_PackedType cpm_cp;

/* CPCR MASKS for CPCR register in CP */
#define CPCR_RST				0x80000000
#define CPCR_PAGE				0x7C000000
#define CPCR_SBC				0x03E00000
#define CPCR_PAGE_SBC_FCC1		0x12000000
#define CPCR_PAGE_SBC_FCC2		0x16200000
#define CPCR_PAGE_SBC_FCC3		0x1A400000
#define CPCR_PAGE_SBC_SCC1		0x00800000
#define CPCR_PAGE_SBC_SCC2		0x04A00000
#define CPCR_PAGE_SBC_SCC3		0x08C00000
#define CPCR_PAGE_SBC_SCC4		0x0CE00000
#define CPCR_PAGE_SBC_I2C		0x29600000
#define CPCR_PAGE_SBC_MCC1		0x1F800000
#define CPCR_PAGE_SBC_MCC2		0X23A00000
#define CPCR_FLG				0x00010000
#define CPCR_FLG_READY_TO_RX	0x00000000

#define CPCR_MCN_SHIFT			(31-25)	/* shift amount to position bits in the field */
#define CPCR_MCN				0x00003FC0
#define CPCR_FCC_PROTOCOL_HDLC	0x00
#define CPCR_FCC_PROTOCOL_ATM	0x0A
#define CPCR_FCC_PROTOCOL_ENET	0x0C
#define CPCR_FCC_PROTOCOL_TRANS	0x0F
#define CPCR_MCN_HDLC			(CPCR_FCC_PROTOCOL_HDLC  << CPCR_MCN_SHIFT)
#define CPCR_MCN_ATM			(CPCR_FCC_PROTOCOL_ATM   << CPCR_MCN_SHIFT)
#define CPCR_MCN_ENET			(CPCR_FCC_PROTOCOL_ENET  << CPCR_MCN_SHIFT)
#define CPCR_MCN_TRANS			(CPCR_FCC_PROTOCOL_TRANS << CPCR_MCN_SHIFT)

#define CPCR_OPCODE				0x0000000F
#define CPCR_INIT_TX_RX_PARAMS	0x00000000
#define CPCR_INIT_RX_PARAMS		0x00000001
#define CPCR_INIT_TX_PARAMS		0x00000002
#define CPCR_MCC_STOP_TX		0x00000004
#define CPCR_GRSTOP_TX			0x00000005
#define CPCR_MCC_INIT_1CH_TX	0x00000005
#define CPCR_RESTART_TX			0x00000006
#define CPCR_MCC_INIT_1CH_RX	0x00000006
#define CPCR_MCC_RESET			0x00000007
#define CPCR_SET_GROUP_ADDRESS	0x00000008
#define CPCR_MCC_STOP_RX		0x00000009
#define CPCR_ATM_TRANSMIT		0x0000000A

#define CPCR_FCC1_ENET			(CPCR_PAGE_SBC_FCC1 | CPCR_MCN_ENET)
#define CPCR_FCC2_ENET			(CPCR_PAGE_SBC_FCC2 | CPCR_MCN_ENET)
#define CPCR_FCC3_ENET			(CPCR_PAGE_SBC_FCC3 | CPCR_MCN_ENET)


/*-----------------------------------------------------------------------------
*
*		SCC
*
*----------------------------------------------------------------------------*/

typedef _Packed struct
{
	reg32 gsmr_l;
	reg32 gsmr_h;
	reg16 psmr;
	byte _reserved0[0x02];
	reg16 todr;
	reg16 dsr;
	reg16 scce;
	byte _reserved1[0x02];
	reg16 sccm;
	byte _reserved2[0x01];
	reg08 sccs;
	byte _reserved3[0x08];
}
_PackedType cpm_scc;

/* SCC (GSMR_L) */
#define GSMR_L_DIAG		0x000000C0
#define GSMR_L_ENR		0x00000020
#define GSMR_L_ENT		0x00000010
#define GSMR_L_MODE		0x0000000F
/* #define GFMR_H_ */

/* SCC UART Event/MASK Register (SCCE/SCCM) */
#define SCCE_GLR		0x1000
#define SCCE_GLT		0x0800
#define SCCE_AB			0x0200
#define SCCE_IDL		0x0100
#define SCCE_GRA		0x0080
#define SCCE_BRKE		0x0040
#define SCCE_BRKS		0x0020
#define SCCE_CCR		0x0008
#define SCCE_BSY		0x0004
#define SCCE_TX			0x0002
#define SCCE_RX			0x0001


/*-----------------------------------------------------------------------------
*
*		SMC
*
*----------------------------------------------------------------------------*/

typedef _Packed struct
{
	byte _reserved0[0x02];
	reg16 smcmr;			
	byte _reserved1[0x02];
	reg08 smce;
	byte _reserved2[0x03];
	reg08 smcm;
	byte _reserved3[0x05];
}
_PackedType cpm_smc;


/*-----------------------------------------------------------------------------
*
*		SPI
*
*----------------------------------------------------------------------------*/

typedef _Packed struct
{
	reg16 spmode;
	byte _reserved0[0x04];
	reg08 spie;
	byte _reserved1[0x03];
	reg08 spim;
	byte _reserved2[0x02];
	reg08 spcom;
	byte _reserved3[0x52];
}
_PackedType cpm_spi;


/*-----------------------------------------------------------------------------
*
*		CPM Mux
*
*----------------------------------------------------------------------------*/

typedef _Packed struct
{
	reg08 cmxsi1cr;
	byte _reserved0[0x01];
	reg08 cmxsi2cr;
	byte _reserved1[0x01];
	reg32 cmxfcr;
	reg32 cmxscr;
	reg08 cmxsmr;
	byte _reserved2[0x01];
#if !MPC_8250
	reg16 cmxuar;
#endif
	byte _reserved3[0x10];
}
_PackedType cpm_mux;


/*-----------------------------------------------------------------------------
*
*		SI / MCC Registers
*
*----------------------------------------------------------------------------*/

typedef _Packed struct
{
	reg16 sixmr[4];
	reg08 sigmr;
	byte _reserved0[0x01];
	reg08 sicmdr;
	byte _reserved1[0x01];
	reg08 sistr;
	byte _reserved2[0x01];
	reg16 sirsr;
	reg16 mcce;
	byte _reserved3[0x02];
	reg16 mccm;
	byte _reserved4[0x02];
	reg08 mccf;
	byte _reserved5[0x07];
}
_PackedType cpm_simcc;

/* MCC Event/Mask Register (MCCE/MCCM) */
#define MCCE_QOV0		0x8000
#define MCCE_RINT0		0x4000
#define MCCE_QOV1		0x2000
#define MCCE_RINT1		0x1000
#define MCCE_QOV2		0x0800
#define MCCE_RINT2		0x0400
#define MCCE_QOV3		0x0200
#define MCCE_RINT3		0x0100
#define MCCE_TQOV		0x0008
#define MCCE_TINT		0x0004
#define MCCE_GUN		0x0002
#define MCCE_GOV		0x0001


/*-----------------------------------------------------------------------------
*
*		SI RAM
*
*----------------------------------------------------------------------------*/

typedef _Packed struct
{
	reg16 tx[0x100];
	byte _reserved0[0x200];
	reg16 rx[0x100];
	byte _reserved1[0x200];
}
_PackedType cpm_siram;

