#ifndef __INCcprmh
#define __INCcprmh

/*-----------------------------------------------------------------------------
*
* $Header: n:/pcmrcs/NCdrivers/system/cprm.h 0.1.1.3 2004/12/20 22:59:55 jdabbraccio Exp $
*
* Copyright Freescale Semiconductor, Inc. 2002-2004.  All rights reserved.
*
* Description:	Communications Processor Resource Manager APIs.
*
*----------------------------------------------------------------------------*/


#if 0

typedef enum _CPRM_PROTOCOL
{
	PROT_AAL0 = 0, PROT_AAL1, PROT_AAL2, PROT_AAL5,
	PROT_APPLETALK,
	PROT_BISYNC,
	PROT_ETHERNET,
	PROT_HDLC, PROT_HDLC_TDM,
	PROT_MSP,
	PROT_TRANSPARENT, PROT_TRANSPARENT_TDM,
	PROT_UART, PROT_I2C, PROT_INVALID
}
CPRM_PROTOCOL;


typedef struct _CPRM_RESOURCE
{
	CPRM_PROTOCOL protocol;
	CPRM_DEVICE device;
	int MaxNumCh;
	struct _CPRM_RESOURCE *next;
}
CPRM_RESOURCE, *PCPRM_RESOURCE;

typedef struct _CPRM_PARAM
{
	PCPRM_RESOURCE resources;	/* all protocols expected to be run */
}
CPRM_PARAM, *PCPRM_PARAM;
#endif

typedef struct _CPRM_PARAM
{
	PMEMORY pMemory;			/* pointer to the system memory definition struct */
	int32u SysClk;				/* System Clock in Hz */
}
CPRM_PARAM, *PCPRM_PARAM;


typedef enum _CPRM_DEVICE
{
	CPRM_DEVICE_BAD = 0,

	CPRM_DEVICE_FCC1,
	CPRM_DEVICE_FCC2,
	CPRM_DEVICE_FCC3,

	CPRM_DEVICE_SCC1,
	CPRM_DEVICE_SCC2,
	CPRM_DEVICE_SCC3,
	CPRM_DEVICE_SCC4,

	CPRM_DEVICE_MCC1,
	CPRM_DEVICE_MCC2,

	CPRM_DEVICE_SMC1,
	CPRM_DEVICE_SMC2,

	CPRM_DEVICE_SPI,

	CPRM_DEVICE_I2C,

	CPRM_DEVICE_PCI,

	CPRM_DEVICE_RIO,

	CPRM_DEVICE_TSEC1,
	CPRM_DEVICE_TSEC2,

	CPRM_DEVICE_BRG1,
	CPRM_DEVICE_BRG2,
	CPRM_DEVICE_BRG3,
	CPRM_DEVICE_BRG4,
	CPRM_DEVICE_BRG5,
	CPRM_DEVICE_BRG6,
	CPRM_DEVICE_BRG7,
	CPRM_DEVICE_BRG8,

	CPRM_DEVICE_PORTA0,
	CPRM_DEVICE_PORTA1,
	CPRM_DEVICE_PORTA2,
	CPRM_DEVICE_PORTA3,
	CPRM_DEVICE_PORTA4,
	CPRM_DEVICE_PORTA5,
	CPRM_DEVICE_PORTA6,
	CPRM_DEVICE_PORTA7,
	CPRM_DEVICE_PORTA8,
	CPRM_DEVICE_PORTA9,
	CPRM_DEVICE_PORTA10,
	CPRM_DEVICE_PORTA11,
	CPRM_DEVICE_PORTA12,
	CPRM_DEVICE_PORTA13,
	CPRM_DEVICE_PORTA14,
	CPRM_DEVICE_PORTA15,
	CPRM_DEVICE_PORTA16,
	CPRM_DEVICE_PORTA17,
	CPRM_DEVICE_PORTA18,
	CPRM_DEVICE_PORTA19,
	CPRM_DEVICE_PORTA20,
	CPRM_DEVICE_PORTA21,
	CPRM_DEVICE_PORTA22,
	CPRM_DEVICE_PORTA23,
	CPRM_DEVICE_PORTA24,
	CPRM_DEVICE_PORTA25,
	CPRM_DEVICE_PORTA26,
	CPRM_DEVICE_PORTA27,
	CPRM_DEVICE_PORTA28,
	CPRM_DEVICE_PORTA29,
	CPRM_DEVICE_PORTA30,
	CPRM_DEVICE_PORTA31,

	CPRM_DEVICE_PORTB4,
	CPRM_DEVICE_PORTB5,
	CPRM_DEVICE_PORTB6,
	CPRM_DEVICE_PORTB7,
	CPRM_DEVICE_PORTB8,
	CPRM_DEVICE_PORTB9,
	CPRM_DEVICE_PORTB10,
	CPRM_DEVICE_PORTB11,
	CPRM_DEVICE_PORTB12,
	CPRM_DEVICE_PORTB13,
	CPRM_DEVICE_PORTB14,
	CPRM_DEVICE_PORTB15,
	CPRM_DEVICE_PORTB16,
	CPRM_DEVICE_PORTB17,
	CPRM_DEVICE_PORTB18,
	CPRM_DEVICE_PORTB19,
	CPRM_DEVICE_PORTB20,
	CPRM_DEVICE_PORTB21,
	CPRM_DEVICE_PORTB22,
	CPRM_DEVICE_PORTB23,
	CPRM_DEVICE_PORTB24,
	CPRM_DEVICE_PORTB25,
	CPRM_DEVICE_PORTB26,
	CPRM_DEVICE_PORTB27,
	CPRM_DEVICE_PORTB28,
	CPRM_DEVICE_PORTB29,
	CPRM_DEVICE_PORTB30,
	CPRM_DEVICE_PORTB31,

	CPRM_DEVICE_PORTC0,
	CPRM_DEVICE_PORTC1,
	CPRM_DEVICE_PORTC2,
	CPRM_DEVICE_PORTC3,
	CPRM_DEVICE_PORTC4,
	CPRM_DEVICE_PORTC5,
	CPRM_DEVICE_PORTC6,
	CPRM_DEVICE_PORTC7,
	CPRM_DEVICE_PORTC8,
	CPRM_DEVICE_PORTC9,
	CPRM_DEVICE_PORTC10,
	CPRM_DEVICE_PORTC11,
	CPRM_DEVICE_PORTC12,
	CPRM_DEVICE_PORTC13,
	CPRM_DEVICE_PORTC14,
	CPRM_DEVICE_PORTC15,
	CPRM_DEVICE_PORTC16,
	CPRM_DEVICE_PORTC17,
	CPRM_DEVICE_PORTC18,
	CPRM_DEVICE_PORTC19,
	CPRM_DEVICE_PORTC20,
	CPRM_DEVICE_PORTC21,
	CPRM_DEVICE_PORTC22,
	CPRM_DEVICE_PORTC23,
	CPRM_DEVICE_PORTC24,
	CPRM_DEVICE_PORTC25,
	CPRM_DEVICE_PORTC26,
	CPRM_DEVICE_PORTC27,
	CPRM_DEVICE_PORTC28,
	CPRM_DEVICE_PORTC29,
	CPRM_DEVICE_PORTC30,
	CPRM_DEVICE_PORTC31,

	CPRM_DEVICE_PORTD4,
	CPRM_DEVICE_PORTD5,
	CPRM_DEVICE_PORTD6,
	CPRM_DEVICE_PORTD7,
	CPRM_DEVICE_PORTD8,
	CPRM_DEVICE_PORTD9,
	CPRM_DEVICE_PORTD10,
	CPRM_DEVICE_PORTD11,
	CPRM_DEVICE_PORTD12,
	CPRM_DEVICE_PORTD13,
	CPRM_DEVICE_PORTD14,
	CPRM_DEVICE_PORTD15,
	CPRM_DEVICE_PORTD16,
	CPRM_DEVICE_PORTD17,
	CPRM_DEVICE_PORTD18,
	CPRM_DEVICE_PORTD19,
	CPRM_DEVICE_PORTD20,
	CPRM_DEVICE_PORTD21,
	CPRM_DEVICE_PORTD22,
	CPRM_DEVICE_PORTD23,
	CPRM_DEVICE_PORTD24,
	CPRM_DEVICE_PORTD25,
	CPRM_DEVICE_PORTD26,
	CPRM_DEVICE_PORTD27,
	CPRM_DEVICE_PORTD28,
	CPRM_DEVICE_PORTD29,
	CPRM_DEVICE_PORTD30,
	CPRM_DEVICE_PORTD31,

	CPRM_DEVICE_32TIMER1,
	CPRM_DEVICE_32TIMER2,

	CPRM_DEVICE_16TIMER1,
	CPRM_DEVICE_16TIMER2,
	CPRM_DEVICE_16TIMER3,
	CPRM_DEVICE_16TIMER4,

	CPRM_DEVICE_FEC1,
	CPRM_DEVICE_FEC2,

	CPRM_DEVICE_UART1,
	CPRM_DEVICE_UART2
}
CPRM_DEVICE;

#define SIZEOF_CPRM_DEVICE	(CPRM_DEVICE_UART2 + 1)

#if !MPC8540

#if MPC8555 || MPC8255
#define CPRM_DEVICE_CATEGORY_FCCn		2
#define CPRM_DEVICE_CATEGORY_FCCm		0x00000003
#else
#define CPRM_DEVICE_CATEGORY_FCCn		3
#define CPRM_DEVICE_CATEGORY_FCCm		0x00000007
#endif

#if MPC8555
#define CPRM_DEVICE_CATEGORY_SCCn		2
#define CPRM_DEVICE_CATEGORY_SCCm		0x00000003
#else
#define CPRM_DEVICE_CATEGORY_SCCn		4
#define CPRM_DEVICE_CATEGORY_SCCm		0x0000000F
#endif

#if MPC8250 || MPC8255
#define CPRM_DEVICE_CATEGORY_MCCn		1
#define CPRM_DEVICE_CATEGORY_MCCm		0x00000001
#elif MPC8555
#define CPRM_DEVICE_CATEGORY_MCCn		0
#define CPRM_DEVICE_CATEGORY_MCCm		0x00000000
#else
#define CPRM_DEVICE_CATEGORY_MCCn		2
#define CPRM_DEVICE_CATEGORY_MCCm		0x00000003
#endif

#if !MPC8560
#define CPRM_DEVICE_CATEGORY_SMCn		2
#define CPRM_DEVICE_CATEGORY_SMCm		0x00000003
#else
#define CPRM_DEVICE_CATEGORY_SMCn		0
#define CPRM_DEVICE_CATEGORY_SMCm		0x00000000
#endif

#define CPRM_DEVICE_CATEGORY_SPIn		1
#define CPRM_DEVICE_CATEGORY_SPIm		0x00000001

#define CPRM_DEVICE_CATEGORY_I2Cn		1
#define CPRM_DEVICE_CATEGORY_I2Cm		0x00000001
#define CPRM_DEVICE_CATEGORY_PCIn		1
#define CPRM_DEVICE_CATEGORY_PCIm		0x00000001
#define CPRM_DEVICE_CATEGORY_BRGn		8
#define CPRM_DEVICE_CATEGORY_BRGm		0x000000FF
#define CPRM_DEVICE_CATEGORY_PORTAn		32
#define CPRM_DEVICE_CATEGORY_PORTAm		0xFFFFFFFF
#define CPRM_DEVICE_CATEGORY_PORTBn		28
#define CPRM_DEVICE_CATEGORY_PORTBm		0xFFFFFFF0
#define CPRM_DEVICE_CATEGORY_PORTCn		32
#define CPRM_DEVICE_CATEGORY_PORTCm		0xFFFFFFFF
#define CPRM_DEVICE_CATEGORY_PORTDn		28
#define CPRM_DEVICE_CATEGORY_PORTDm		0xFFFFFFF0
#define CPRM_DEVICE_CATEGORY_32TIMERn	2
#define CPRM_DEVICE_CATEGORY_32TIMERm	0x00000003
#define CPRM_DEVICE_CATEGORY_16TIMERn	4
#define CPRM_DEVICE_CATEGORY_16TIMERm	0x0000000F

#else

#define CPRM_DEVICE_CATEGORY_FCCn		0
#define CPRM_DEVICE_CATEGORY_FCCm		0x00000000
#define CPRM_DEVICE_CATEGORY_SCCn		0
#define CPRM_DEVICE_CATEGORY_SCCm		0x00000000
#define CPRM_DEVICE_CATEGORY_MCCn		0
#define CPRM_DEVICE_CATEGORY_MCCm		0x00000000
#define CPRM_DEVICE_CATEGORY_SMCn		0
#define CPRM_DEVICE_CATEGORY_SMCm		0x00000000
#define CPRM_DEVICE_CATEGORY_SPIn		0
#define CPRM_DEVICE_CATEGORY_SPIm		0x00000000
#define CPRM_DEVICE_CATEGORY_I2Cn		1
#define CPRM_DEVICE_CATEGORY_I2Cm		0x00000001
#define CPRM_DEVICE_CATEGORY_PCIn		1
#define CPRM_DEVICE_CATEGORY_PCIm		0x00000001
#define CPRM_DEVICE_CATEGORY_BRGn		0
#define CPRM_DEVICE_CATEGORY_BRGm		0x00000000
#define CPRM_DEVICE_CATEGORY_PORTAn		0
#define CPRM_DEVICE_CATEGORY_PORTAm		0x00000000
#define CPRM_DEVICE_CATEGORY_PORTBn		0
#define CPRM_DEVICE_CATEGORY_PORTBm		0x00000000
#define CPRM_DEVICE_CATEGORY_PORTCn		0
#define CPRM_DEVICE_CATEGORY_PORTCm		0x00000000
#define CPRM_DEVICE_CATEGORY_PORTDn		0
#define CPRM_DEVICE_CATEGORY_PORTDm		0x00000000
#define CPRM_DEVICE_CATEGORY_32TIMERn	0
#define CPRM_DEVICE_CATEGORY_32TIMERm	0x00000000
#define CPRM_DEVICE_CATEGORY_16TIMERn	0
#define CPRM_DEVICE_CATEGORY_16TIMERm	0x00000000

#endif

#if MPC8540 || MPC8555
#define CPRM_DEVICE_CATEGORY_UARTn		2
#define CPRM_DEVICE_CATEGORY_UARTm		0x00000003
#else
#define CPRM_DEVICE_CATEGORY_UARTn		0
#define CPRM_DEVICE_CATEGORY_UARTm		0x00000000
#endif

#if MPC8540 || MPC8560
#define CPRM_DEVICE_CATEGORY_RIOn		1
#define CPRM_DEVICE_CATEGORY_RIOm		0x00000001
#else
#define CPRM_DEVICE_CATEGORY_RIOn		0
#define CPRM_DEVICE_CATEGORY_RIOm		0x00000000
#endif

#if MPC8540
#define CPRM_DEVICE_CATEGORY_FECn		2
#define CPRM_DEVICE_CATEGORY_FECm		0x00000003
#else
#define CPRM_DEVICE_CATEGORY_FECn		0
#define CPRM_DEVICE_CATEGORY_FECm		0x00000000
#endif

#if MPC85xx
#define CPRM_DEVICE_CATEGORY_TSECn		2
#define CPRM_DEVICE_CATEGORY_TSECm		0x00000003
#else
#define CPRM_DEVICE_CATEGORY_TSECn		0
#define CPRM_DEVICE_CATEGORY_TSECm		0x00000000
#endif


typedef enum _CPRM_DEVICE_CATEGORY
{
	CPRM_DEVICE_CATEGORY_BAD = 0,
	CPRM_DEVICE_CATEGORY_FCC,
	CPRM_DEVICE_CATEGORY_SCC,
	CPRM_DEVICE_CATEGORY_MCC,
	CPRM_DEVICE_CATEGORY_SMC,
	CPRM_DEVICE_CATEGORY_SPI,
	CPRM_DEVICE_CATEGORY_I2C,
	CPRM_DEVICE_CATEGORY_PCI,
	CPRM_DEVICE_CATEGORY_RIO,
	CPRM_DEVICE_CATEGORY_TSEC,
	CPRM_DEVICE_CATEGORY_BRG,
	CPRM_DEVICE_CATEGORY_PORTA,
	CPRM_DEVICE_CATEGORY_PORTB,
	CPRM_DEVICE_CATEGORY_PORTC,
	CPRM_DEVICE_CATEGORY_PORTD,
	CPRM_DEVICE_CATEGORY_32TIMER,
	CPRM_DEVICE_CATEGORY_16TIMER,
	CPRM_DEVICE_CATEGORY_FEC,
	CPRM_DEVICE_CATEGORY_UART
}
CPRM_DEVICE_CATEGORY;

#define SIZEOF_CPRM_DEVICE_CATEGORY		CPRM_DEVICE_CATEGORY_UART

/* L2 cache allocation types */
typedef enum _L2_CACHE_ALLOCATION
{
	L2_CACHE_NONE = 0, _L2_CACHE_RESERVED = 1, L2_CACHE_ALLOCATE = 2, L2_CACHE_ALLOCATE_LOCK = 3
}
L2_CACHE_ALLOCATION;


/* API Function Prototypes */
#define CPRM_New		CPRM_Constructor
#define CPRM_Delete	CPRM_Destructor
Handle CPRM_Constructor(PCPRM_PARAM params);
void CPRM_Destructor(Handle object);
int32u CPRM_GetCpmClk(Handle object);
int32u CPRM_GetBrgClk(Handle object);
PMEMORY CPRM_GetMemory(Handle object);
int32u CPRM_GetOneResource(Handle object, const char *owner, CPRM_DEVICE_CATEGORY dev_category,
						   int32u acceptable_mask);
int32u CPRM_GetAllResources(Handle object, const char *owner, CPRM_DEVICE_CATEGORY dev_category,
							int32u all_mask);
int32u CPRM_ReleaseAllResources(Handle object, const char *owner, CPRM_DEVICE_CATEGORY dev_category,
								int32u all_mask);
Boolean CPRM_AddDPRAM(Handle object, ADDRESS start, int32u size);
Boolean CPRM_GetDPRAM(Handle object, ADDRESS start, int32u size);
Boolean CPRM_PutDPRAM(Handle object, ADDRESS start);
Boolean CPRM_DeleteDPRAM(Handle object);
Boolean CPRM_L2CacheAllocate(Handle object, Handle mem_obj, void *address, int16u size,
							 L2_CACHE_ALLOCATION allocation, int8u * region);
Boolean CPRM_L2CacheDeallocate(Handle object, int8u region);

#endif /* __INCcprmh */
