
/***************************************************************************
 *     Copyright Motorola, Inc. 1989-2001 ALL RIGHTS RESERVED
 *
 *  $Id: epic2.S.rca 1.1 Mon Dec  1 14:11:06 2003 r9aahw Experimental $
 *
 * You are hereby granted a copyright license to use, modify, and
 * distribute the SOFTWARE, also know as DINK32 (Dynamic Interactive Nano 
 * Kernel for 32-bit processors) solely in conjunction with the development 
 * and marketing of your products which use and incorporate microprocessors 
 * which implement the PowerPC(TM) architecture manufactured by 
 * Motorola and provided you comply with all of the following restrictions 
 * i) this entire notice is retained without alteration in any
 * modified and/or redistributed versions, and 
 * ii) that such modified versions are clearly identified as such. 
 * No licenses are granted by implication, estoppel or
 * otherwise under any patents or trademarks of Motorola, Inc.
 * 
 * The SOFTWARE is provided on an "AS IS" basis and without warranty. To
 * the maximum extent permitted by applicable law, MOTOROLA DISCLAIMS ALL
 * WARRANTIES WHETHER EXPRESS OR IMPLIED, INCLUDING IMPLIED WARRANTIES OF
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE AND ANY WARRANTY 
 * AGAINST INFRINGEMENT WITH REGARD TO THE SOFTWARE 
 * (INCLUDING ANY MODIFIED VERSIONS THEREOF) AND ANY ACCOMPANYING 
 * WRITTEN MATERIALS.
 * 
 * To the maximum extent permitted by applicable law, IN NO EVENT SHALL
 * MOTOROLA BE LIABLE FOR ANY DAMAGES WHATSOEVER (INCLUDING WITHOUT 
 * LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS, BUSINESS 
 * INTERRUPTION, LOSS OF BUSINESS INFORMATION,
 * OR OTHER PECUNIARY LOSS) ARISING OF THE USE OR INABILITY TO USE THE
 * SOFTWARE.
 * Motorola assumes no responsibility for the maintenance and support of
 * the SOFTWARE.
 ************************************************************************/
#include "config.h"
#ifdef GCC_REGISTERS
#include "gcc_registers.h"
#endif /* GCC_REGISTERS */


.equ sprg0,	272
.equ sprg1,	273
.equ sprg2,	274
.equ sprg3,	275
.equ hid0,	1008
.equ epicModeError,	1

.extern	epicISR				//	In epic1.c
.extern	save_to_dink			//	In reg_swap.s
.extern	restore_to_dink			//	In reg_swap.s
.extern restore_partial_dink		//	In reg_swap.s
.extern	temp_sprg0			//	In except2.s
.extern	temp_sprg1			//	In except2.s
.extern dink_transfer_table		//	In reg_tb.c
	
/*********************************************
 * function: CoreExtIntEnable
 *
 * description: Enable 603e core external interrupt
 *
 * note: mtmsr is context-synchronization
 **********************************************/
	.text
	.align 2
	.global CoreExtIntEnable
CoreExtIntEnable:
	mfmsr    r3
	ori      r3,r3,0x8000	//enable external interrupt
	mtmsr    r3
	blr

/*******************************************
 * function: CoreExtIntDisable
 * 
 * description: Disable 603e core external interrupt
 *
 * note: 
 *******************************************/
	.text
	.align 2
	.global CoreExtIntDisable
CoreExtIntDisable:
	mfmsr	r3
	lis	r4,0xffff
	ori	r4,r4,0x7fff
	and	r3,r3,r4		//disable external interrupt
	mtmsr	r3
	blr

/*******************************************
 * function: epicSetupTransferTable
 * 
 * description: Setup r21 with the address of
 *		dink transfer table so ISRs
 *		can use printf. 
 *
 * note: 
 *******************************************/
	.text
	.align 2
	.global epicSetupTransferTable
epicSetupTransferTable:
	lis	r21,dink_transfer_table@h
	ori	r21,r21,dink_transfer_table@l
	blr


/***********************************************************
 * function: exception routine called by exception vector 
 *           at 0x500, external interrupt
 *
 * description: Kahlua EPIC controller
 *
 * input:  none
 * output: none
 *
 * note: This routine will do the following:
 *	1)	Save the current programming model/state depending
 *		on in_which_code flag.
 *	2)	Call epicISR to service the interrupt
 *	3)	Restore the programming model/state
 *	4)	rfi back to where we where before the interrupt
 ***********************************************************/

       	.text
	.align 2
       	.global epic_exception

epic_exception:

	mfmsr	r4			//turn on Floating Point unit in MSR
	ori	r4,r4,0x2000		//both save_to_dink and save_to_user
	mtmsr	r4			//save the floating point registers.

//	Lets find out if we were in Dink or User code so we know which
//	programming model to save off.
	lis	r3,in_which_code@h	//load in_which_code global
	ori	r3,r3,in_which_code@l
	lwz	r3,0(r3)
	cmpi	0,0,r3,0x0		//were we in DINK or USER code?
	beq	cr0,saveDink

//	USER? save_to_user will save to the user programming model
	bl	save_to_user
	b	saveDone

//	DINK? save_to_dink will save to the dink programming model
saveDink:
	bl	save_to_dink
	
saveDone:

//	Flush the caches
//	bl	cache_flush_all

//	restore_partial_dink (set stackpointer and bats back up)
//	bl	restore_partial_dink

//	Now that the important registers are saved,
//	lets make sure we're not in Pass-through mode.
//	If we are in Pass-through mode, print an error
//	message, disable external interrupts and return.
					//what mode are we in?	
	bl	epicModeGet		//returns mode in R3	
	cmpi	0,0,r3,0x1		//Direct=1, Pass-through=0
	beq	cr0,epicModeOK		//if direct mode continue
	xor	r3,r3,r3
	ori	r3,r3,epicModeError	//setup error code
	bl	epicErrorHandler	//error message
	lis	r3,current_msr@h	//turn off external interrupts
	ori	r3,r3,current_msr@l	//in MSR return value to be
	lwz	r4,0(r3)		//put in SRR1 for RFI
	andi.	r4,r4,0x7fff
	stw	r4,0(r3)
	b	epicRestoreReg		//restore and return

epicModeOK:

//	EPIC Interrupt Service Routine
//	Main routine to handle any EPIC related interrupts
	bl	epicISR

epicRestoreReg:

//	Check if we were in dink or user code so we know which
//	programming model to restore.
	lis	r3,in_which_code@h	//load in_which_code global
	ori	r3,r3,in_which_code@l
	lwz	r3,0(r3)
	cmpi	0,0,r3,0x0		//were we in DINK or USER code?
	beq	cr0,restoreDink

//	USER? restore_to_user will restore the user programming model
	bl	restore_to_user
	b	restoreDone

//	DINK? restore_to_dink will restore the dink programming model
restoreDink:
	bl	restore_to_dink

restoreDone:


//	restore saved registers that were valid prior to the exception
	mfspr	r1,sprg1		//the restore routines leave 
	mfspr	r2,sprg2		//r1 & r2 values in sprg 1 & 2
	sync
		
	lis	r4,current_srr0@h
	ori	r4,r4,current_srr0@l
	lwz	r3,0(r4)
	mtspr	srr0,r3
	sync
	
	lis	r4,current_msr@h
	ori	r4,r4,current_msr@l
	lwz	r3,0(r4)
	mtspr	srr1,r3	
	sync
	
	lis	r4,current_hid0@h
	ori	r4,r4,current_hid0@l
	lwz	r3,0(r4)
	mtspr	hid0,r3
	sync
	
	lis	r4,current_lr@h	
	ori	r4,r4,current_lr@l
	lwz	r3,0(r4)
	mtlr	r3
	sync
	
	lis	r4,current_cr@h
	ori	r4,r4,current_cr@l
	lwz	r3,0(r4)
	mtcr	r3
	sync

//	restore_to_dink/user puts saved sprg0/1 in these temp locations
	lis	r4,temp_sprg0@h
	ori	r4,r4,temp_sprg0@l
	lwz	r3,0(r4)
	mtspr	sprg0,r3
	sync
	
	lis	r4,temp_sprg1@h
	ori	r4,r4,temp_sprg1@l
	lwz	r3,0(r4)
	mtspr	sprg1,r3
	sync

	lis	r4,current_r5@h
	ori	r4,r4,current_r5@l
	lwz	r5,0(r4)
	sync

	lis	r4,current_r3@h
	ori	r4,r4,current_r3@l
	lwz	r3,0(r4)
	sync

	lis	r4,current_r4@h
	ori	r4,r4,current_r4@l
	lwz	r4,0(r4)
	sync

	rfi
	
//	********* END OF FILE *********************
