/* epic_handler.c - contains subroutines to handle interrupts */

/*  Copyright 2005-2006 Freescale Semiconductor */
/*
modification history
--------------------
01a,19jul05,ahk rewritten from edink

AUG07 mj added cpmIsr for mcc1 RX interrupts
*/

/*
DESCRIPTION

INCLUDE Files: epic.h, tsec.h
*/

/* includes */

#include <stdio.h>
#include <string.h>
#include "netcomm.h"
#include "epic.h"
#include "e500.h"
#include "MPC8560.h"
#include "mcc.h"

/* defines */

/* typedefs */

/* globals */

extern VUWORD IntCounter;
extern mpc_imm *pCCSRBAR;
extern VUBYTE MCC;
extern UHWORD BDRxError(UHWORD bd_cstatus);
extern BDRINGS *RxTxBD;
extern VUWORD RxGood; 
extern VUBYTE NotDone;

void cpmIsr(void)
{
	UWORD    ic_sivec;
	UWORD    mcce;
	UHWORD   index;
	UHWORD   offset;

   	IntCounter++;

	//------------------------------------
	// Shift the 5-bit interrupt code     
	// down to the least significant bits 
	//------------------------------------
   	ic_sivec = pCCSRBAR->cpm.ic.sivec >> 26;  // sivec interrupt code 

   	//--------------------------------
   	// Match event against MCC1 value 
   	//--------------------------------

   	// if interrupt NOT from expected source 
   	if (((MCC==MCC1)&&(ic_sivec != SIVEC_MCC1)) ||
   		((MCC==MCC2)&&(ic_sivec != SIVEC_MCC2)) )     
   	{
   		printf("\nINT NOT FROM EXPECTED SOURCE (cpmIsr)\n");
   		while (1){}; 
   	};
   	
	//-----------------------------
	// Copy the MCC event register 
	//-----------------------------
	mcce = pCCSRBAR->cpm.simcc[MCC].mcce; // Save off scce 

	//-------------------------------------------
	// Clear MCC1 Event Register (by writing 1s) 
	//-------------------------------------------
   	pCCSRBAR->cpm.simcc[MCC].mcce = (VUHWORD)ALL_ONES;

	//------------------------------------------------------
	// Process MCC Event if the event flag for RINT0 is set 
	//------------------------------------------------------
   	if (mcce & 0x4000) 
   	{
        	for (offset=0; offset<=CH112BDOFFSET; offset+=8)
        	{
            		for (index=0; index<NUM_RXBDS; index++)
            		{ 
               			//-------------------------------------
               			// checking all status bits for errors 
               			//-------------------------------------
               			if ( BDRxError( RxTxBD->RxBD[index+offset].bd_cstatus )) 
                  			RxGood = FALSE;               

               			if ((RxGood == TRUE)&&(offset<=CH16BDOFFSET))
                		{
               				if (memcmp((const void *) (RxTxBD->RxBD[index+offset].bd_addr),
                    	       			(const void *) (RxTxBD->TxBD[index+offset].bd_addr), 
                        	   		(RxTxBD->TxBD[index+offset].bd_length))) 

                    			RxGood=FALSE;

                			while (RxGood == FALSE)
                			{

    		            			if (memcmp((const void *) (RxTxBD->RxBD[index+offset].bd_addr),
            					   (const void *) (RxTxBD->TxBD[index+offset].bd_addr), 
                				   (RxTxBD->TxBD[index+offset].bd_length))) 
                					RxGood=FALSE;
						else
							RxGood=TRUE;
                			};
               			};

                		if (RxGood == FALSE) 
                		{
                    			printf("\nERROR (cpmIsr)\n");
                    			while (1){}; 	// spin here if error is flagged 
                    		};
            		};
        	};

        	NotDone = FALSE;
   	}    
   	else 
        	RxGood = FALSE; // Expected to see RINT0 event in MCCE 

	//-------------------------------------
	// Here's our error loop. Spin here    
	// indefinitely if there was an error. 
	//-------------------------------------
   	if (RxGood == FALSE) 
   	{
      		printf("\nERROR (cpmIsr)\n");
      		while (1){}; 	// spin here if error is flagged 
   	};
}

//EOF
