#ifndef EPIC_H
#define EPIC_H  

//#include "e500.h" //added by ak
#define MPC8560ADS  //added for epic need

#define LONGSWAP(x) ((((x) & 0x000000ff) << 24) | (((x) & 0x0000ff00) << 8)|\
                     (((x) & 0x00ff0000) >>  8) | (((x) & 0xff000000) >> 24) )

#define ERROR 0xffffffff




extern void I2CISR(void);
extern void IRQ0ISR(void);
extern void IRQ1ISR(void);
extern void IRQ2ISR(void);
extern void IRQ3ISR(void);
extern void IRQ4ISR(void);
extern void IRQ5ISR(void);
extern void IRQ6ISR(void);
extern void IRQ7ISR(void);
extern void IRQ8ISR(void);
extern void IRQ9ISR(void);
extern void IRQ10ISR(void);
extern void IRQ11ISR(void);
extern void IRQ12ISR(void);
extern void IRQ13ISR(void);
extern void IRQ14ISR(void);
extern void IRQ15ISR(void);
extern void Timer0ISR(void);
extern void Timer1ISR(void);
extern void Timer2ISR(void);
extern void Timer3ISR(void);
extern void cpmIsr(void);

typedef void (*VOIDFUNCPTR) ();		/* Point to function returning void */
//#define EPICDBG

#ifndef MPC8560ADS
#define MAXVEC		         26
#else
#define MAXVEC		         56
#endif

#ifndef MPC8560ADS
#define MAXIRQ			  5	/* IRQs */
#else
#define MAXIRQ			  12	/* IRQs */
#endif

#define EPIC_DIRECT_IRQ		  0	/* Direct interrupt type */
#define EPIC_SERIAL_IRQ		  1	/* Serial interrupt type */

/* EPIC register addresses */

#define EUMBBAR			0x40000000	/* CCSRBAR */
#define EPIC_EUMBBAR  		0x00040000	/* offset of PIC map from CCSRBAR  */

//#ifndef MPC8560ADS

#define EPIC_FEATURES_REG	(EPIC_EUMBBAR + 0x01000)/* Feature reporting */
#define EPIC_GLOBAL_REG		(EPIC_EUMBBAR + 0x01020)/* Global config.  */
#define EPIC_INT_CONF_REG	(EPIC_EUMBBAR + 0x01030)/* Interrupt config. */
#define EPIC_VENDOR_ID_REG	(EPIC_EUMBBAR + 0x01080)/* Vendor id */
#define EPIC_PROC_INIT_REG	(EPIC_EUMBBAR + 0x01090)/* Processor init. */
#define EPIC_SPUR_VEC_REG	(EPIC_EUMBBAR + 0x010e0)/* Spurious vector */
#define EPIC_TM_FREQ_REG	(EPIC_EUMBBAR + 0x010f0)/* Timer Frequency */

#define EPIC_TM0_CUR_COUNT_REG	(EPIC_EUMBBAR + 0x01100)/* Gbl TM0 Cur. Count*/
#define EPIC_TM0_BASE_COUNT_REG	(EPIC_EUMBBAR + 0x01110)/* Gbl TM0 Base Count*/
#define EPIC_TM0_VEC_REG	(EPIC_EUMBBAR + 0x01120)/* Gbl TM0 Vector Pri*/
#define EPIC_TM0_DES_REG	(EPIC_EUMBBAR + 0x01130)/* Gbl TM0 Dest. */

#define EPIC_TM1_CUR_COUNT_REG	(EPIC_EUMBBAR + 0x01140)/* Gbl TM1 Cur. Count*/
#define EPIC_TM1_BASE_COUNT_REG	(EPIC_EUMBBAR + 0x01150)/* Gbl TM1 Base Count*/
#define EPIC_TM1_VEC_REG	(EPIC_EUMBBAR + 0x01160)/* Gbl TM1 Vector Pri*/
#define EPIC_TM1_DES_REG	(EPIC_EUMBBAR + 0x01170)/* Gbl TM1 Dest. */

#define EPIC_TM2_CUR_COUNT_REG	(EPIC_EUMBBAR + 0x01180)/* Gbl TM2 Cur. Count*/
#define EPIC_TM2_BASE_COUNT_REG	(EPIC_EUMBBAR + 0x01190)/* Gbl TM2 Base Count*/
#define EPIC_TM2_VEC_REG	(EPIC_EUMBBAR + 0x011a0)/* Gbl TM2 Vector Pri*/
#define EPIC_TM2_DES_REG	(EPIC_EUMBBAR + 0x011b0)/* Gbl TM2 Dest */

#define EPIC_TM3_CUR_COUNT_REG	(EPIC_EUMBBAR + 0x011c0)/* Gbl TM3 Cur. Count*/
#define EPIC_TM3_BASE_COUNT_REG	(EPIC_EUMBBAR + 0x011d0)/* Gbl TM3 Base Count*/
#define EPIC_TM3_VEC_REG	(EPIC_EUMBBAR + 0x011e0)/* Gbl TM3 Vector Pri*/
#define EPIC_TM3_DES_REG	(EPIC_EUMBBAR + 0x011f0)/* Gbl TM3 Dest. */

#define EPIC_EX_INT0_VEC_REG	(EPIC_EUMBBAR + 0x10200)/* Ext. Int. Sr0 Vect */
#define EPIC_EX_INT0_DES_REG	(EPIC_EUMBBAR + 0x10210)/* Ext. Int. Sr0 Dest */
#define EPIC_EX_INT1_VEC_REG	(EPIC_EUMBBAR + 0x10220)/* Ext. Int. Sr1 Vect */
#define EPIC_EX_INT1_DES_REG	(EPIC_EUMBBAR + 0x10230)/* Ext. Int. Sr1 Dest */
#define EPIC_EX_INT2_VEC_REG	(EPIC_EUMBBAR + 0x10240)/* Ext. Int. Sr2 Vect */
#define EPIC_EX_INT2_DES_REG	(EPIC_EUMBBAR + 0x10250)/* Ext. Int. Sr2 Dest */
#define EPIC_EX_INT3_VEC_REG	(EPIC_EUMBBAR + 0x10260)/* Ext. Int. Sr3 Vect */
#define EPIC_EX_INT3_DES_REG	(EPIC_EUMBBAR + 0x10270)/* Ext. Int. Sr3 Dest */
#define EPIC_EX_INT4_VEC_REG	(EPIC_EUMBBAR + 0x10280)/* Ext. Int. Sr4 Vect */
#define EPIC_EX_INT4_DES_REG	(EPIC_EUMBBAR + 0x10290)/* Ext. Int. Sr4 Dest */

#define EPIC_SR_INT0_VEC_REG	(EPIC_EUMBBAR + 0x10200)/* Sr. Int. Sr0 Vect */
#define EPIC_SR_INT0_DES_REG	(EPIC_EUMBBAR + 0x10210)/* Sr. Int. Sr0 Dest */
#define EPIC_SR_INT1_VEC_REG	(EPIC_EUMBBAR + 0x10220)/* Sr. Int. Sr1 Vect */
#define EPIC_SR_INT1_DES_REG	(EPIC_EUMBBAR + 0x10230)/* Sr. Int. Sr1 Dest */
#define EPIC_SR_INT2_VEC_REG	(EPIC_EUMBBAR + 0x10240)/* Sr. Int. Sr2 Vect */
#define EPIC_SR_INT2_DES_REG	(EPIC_EUMBBAR + 0x10250)/* Sr. Int. Sr2 Dest */
#define EPIC_SR_INT3_VEC_REG	(EPIC_EUMBBAR + 0x10260)/* Sr. Int. Sr3 Vect */
#define EPIC_SR_INT3_DES_REG	(EPIC_EUMBBAR + 0x10270)/* Sr. Int. Sr3 Dest */
#define EPIC_SR_INT4_VEC_REG	(EPIC_EUMBBAR + 0x10280)/* Sr. Int. Sr4 Vect */
#define EPIC_SR_INT4_DES_REG	(EPIC_EUMBBAR + 0x10290)/* Sr. Int. Sr4 Dest */

#define EPIC_SR_INT5_VEC_REG	(EPIC_EUMBBAR + 0x102a0)/* Sr. Int. Sr5 Vect */
#define EPIC_SR_INT5_DES_REG	(EPIC_EUMBBAR + 0x102b0)/* Sr. Int. Sr5 Dest */
#define EPIC_SR_INT6_VEC_REG	(EPIC_EUMBBAR + 0x102c0)/* Sr. Int. Sr6 Vect */
#define EPIC_SR_INT6_DES_REG	(EPIC_EUMBBAR + 0x102d0)/* Sr. Int. Sr6 Dest */
#define EPIC_SR_INT7_VEC_REG	(EPIC_EUMBBAR + 0x102e0)/* Sr. Int. Sr7 Vect */
#define EPIC_SR_INT7_DES_REG	(EPIC_EUMBBAR + 0x102f0)/* Sr. Int. Sr7 Dest */
#define EPIC_SR_INT8_VEC_REG	(EPIC_EUMBBAR + 0x10300)/* Sr. Int. Sr8 Vect */
#define EPIC_SR_INT8_DES_REG	(EPIC_EUMBBAR + 0x10310)/* Sr. Int. Sr8 Dest */
#define EPIC_SR_INT9_VEC_REG	(EPIC_EUMBBAR + 0x10320)/* Sr. Int. Sr9 Vect */
#define EPIC_SR_INT9_DES_REG	(EPIC_EUMBBAR + 0x10330)/* Sr. Int. Sr9 Dest */

#define EPIC_SR_INT10_VEC_REG	(EPIC_EUMBBAR + 0x10340)/* Sr. Int. Sr10 Vect */
#define EPIC_SR_INT10_DES_REG	(EPIC_EUMBBAR + 0x10350)/* Sr. Int. Sr10 Dest */
#define EPIC_SR_INT11_VEC_REG	(EPIC_EUMBBAR + 0x10360)/* Sr. Int. Sr11 Vect */
#define EPIC_SR_INT11_DES_REG	(EPIC_EUMBBAR + 0x10370)/* Sr. Int. Sr11 Dest */
#define EPIC_SR_INT12_VEC_REG	(EPIC_EUMBBAR + 0x10380)/* Sr. Int. Sr12 Vect */
#define EPIC_SR_INT12_DES_REG	(EPIC_EUMBBAR + 0x10390)/* Sr. Int. Sr12 Dest */
#define EPIC_SR_INT13_VEC_REG	(EPIC_EUMBBAR + 0x103a0)/* Sr. Int. Sr13 Vect */
#define EPIC_SR_INT13_DES_REG	(EPIC_EUMBBAR + 0x103b0)/* Sr. Int. Sr13 Dest */
#define EPIC_SR_INT14_VEC_REG	(EPIC_EUMBBAR + 0x103c0)/* Sr. Int. Sr14 Vect */
#define EPIC_SR_INT14_DES_REG	(EPIC_EUMBBAR + 0x103d0)/* Sr. Int. Sr14 Dest */
#define EPIC_SR_INT15_VEC_REG	(EPIC_EUMBBAR + 0x103e0)/* Sr. Int. Sr15 Vect */
#define EPIC_SR_INT15_DES_REG	(EPIC_EUMBBAR + 0x103f0)/* Sr. Int. Sr15 Dest */

#define EPIC_I2C_INT_VEC_REG	(EPIC_EUMBBAR + 0x11020)/* I2C Int. Vect Pri.*/
#define EPIC_I2C_INT_DES_REG	(EPIC_EUMBBAR + 0x11030)/* I2C Int. Dest */
#define EPIC_DMA0_INT_VEC_REG	(EPIC_EUMBBAR + 0x11040)/* DMA0 Int. Vect Pri*/
#define EPIC_DMA0_INT_DES_REG	(EPIC_EUMBBAR + 0x11050)/* DMA0 Int. Dest */
#define EPIC_DMA1_INT_VEC_REG	(EPIC_EUMBBAR + 0x11060)/* DMA1 Int. Vect Pri*/
#define EPIC_DMA1_INT_DES_REG	(EPIC_EUMBBAR + 0x11070)/* DMA1 Int. Dest */
#define EPIC_MSG_INT_VEC_REG	(EPIC_EUMBBAR + 0x110c0)/* Msg Int. Vect Pri*/
#define EPIC_MSG_INT_DES_REG	(EPIC_EUMBBAR + 0x110d0)/* Msg Int. Dest  */
#define EPIC_DUART1_INT_VEC_REG	(EPIC_EUMBBAR + 0x11120)/* DUART1 IntVectPri*/
#define EPIC_DUART1_INT_DES_REG	(EPIC_EUMBBAR + 0x11130)/* DUART1 Int Dest  */
#define EPIC_DUART2_INT_VEC_REG	(EPIC_EUMBBAR + 0x11140)/* DUART2 IntVectPri*/
#define EPIC_DUART2_INT_DES_REG	(EPIC_EUMBBAR + 0x11150)/* DUART2 Int Dest  */

#define EPIC_PROC_CTASK_PRI_REG	(EPIC_EUMBBAR + 0x20080)/* Proc. current task*/
#define EPIC_PROC_INT_ACK_REG	(EPIC_EUMBBAR + 0x200a0)/* Int. acknowledge */
#define EPIC_PROC_EOI_REG	(EPIC_EUMBBAR + 0x200b0)/* End of interrupt */


/* All MPC8560 pic related definitions */
//#else
//#define EPIC_PROC_INIT_REG	(EPIC_EUMBBAR + 0x01090)/* Processor init. */
//#define EPIC_GLOBAL_REG		(EPIC_EUMBBAR + 0x01020)/* Global config.  */
//#define EPIC_FEATURES_REG	(EPIC_EUMBBAR + 0x01000)/* Feature reporting */
//#define EPIC_PROC_CTASK_PRI_REG	(EPIC_EUMBBAR + 0x20080)/* Proc. current task*/
//#define EPIC_PROC_INT_ACK_REG	(EPIC_EUMBBAR + 0x200a0)/* Int. acknowledge */
//#define EPIC_PROC_EOI_REG	(EPIC_EUMBBAR + 0x200b0)/* End of interrupt */

/* 12 external internal sources */
#define EPIC_EIVPR0_REG		(EPIC_EUMBBAR + 0x10000)
#define EPIC_EIVPR1_REG		(EPIC_EUMBBAR + 0x10020)
#define EPIC_EIVPR2_REG		(EPIC_EUMBBAR + 0x10040)
#define EPIC_EIVPR3_REG		(EPIC_EUMBBAR + 0x10060)
#define EPIC_EIVPR4_REG		(EPIC_EUMBBAR + 0x10080)
#define EPIC_EIVPR5_REG		(EPIC_EUMBBAR + 0x100a0)
#define EPIC_EIVPR6_REG		(EPIC_EUMBBAR + 0x100c0)
#define EPIC_EIVPR7_REG		(EPIC_EUMBBAR + 0x100e0)
#define EPIC_EIVPR8_REG		(EPIC_EUMBBAR + 0x10100)
#define EPIC_EIVPR9_REG		(EPIC_EUMBBAR + 0x10120)
#define EPIC_EIVPR10_REG	(EPIC_EUMBBAR + 0x10140)
#define EPIC_EIVPR11_REG	(EPIC_EUMBBAR + 0x10160)

/* 4 message sources */
#define EPIC_MIVPR0_REG		(EPIC_EUMBBAR + 0x11600)
#define EPIC_MIVPR1_REG		(EPIC_EUMBBAR + 0x11620)
#define EPIC_MIVPR2_REG		(EPIC_EUMBBAR + 0x11640)
#define EPIC_MIVPR3_REG		(EPIC_EUMBBAR + 0x11660)

/* 4 inter-processor sources */
#define EPIC_IPIVPR0_REG	(EPIC_EUMBBAR + 0x010a0)
#define EPIC_IPIVPR1_REG	(EPIC_EUMBBAR + 0x010b0)
#define EPIC_IPIVPR2_REG	(EPIC_EUMBBAR + 0x010c0)
#define EPIC_IPIVPR3_REG	(EPIC_EUMBBAR + 0x010d0)

/* 4 global timer sources */
#define EPIC_GTVPR0_REG		(EPIC_EUMBBAR + 0x01120)
#define EPIC_GTVPR1_REG		(EPIC_EUMBBAR + 0x01160)
#define EPIC_GTVPR2_REG		(EPIC_EUMBBAR + 0x011a0)
#define EPIC_GTVPR3_REG		(EPIC_EUMBBAR + 0x011e0)

/* 32 internal sources and 23 out of them are used */
#define EPIC_IIVPR0_REG		(EPIC_EUMBBAR + 0x10200)
#define EPIC_IIVPR1_REG		(EPIC_EUMBBAR + 0x10220)
#define EPIC_IIVPR2_REG		(EPIC_EUMBBAR + 0x10240)
#define EPIC_IIVPR3_REG		(EPIC_EUMBBAR + 0x10260)
#define EPIC_IIVPR4_REG		(EPIC_EUMBBAR + 0x10280)
#define EPIC_IIVPR5_REG		(EPIC_EUMBBAR + 0x102a0)
#define EPIC_IIVPR6_REG		(EPIC_EUMBBAR + 0x102c0)
#define EPIC_IIVPR7_REG		(EPIC_EUMBBAR + 0x102e0)
#define EPIC_IIVPR8_REG		(EPIC_EUMBBAR + 0x10300)
#define EPIC_IIVPR9_REG		(EPIC_EUMBBAR + 0x10320)
#define EPIC_IIVPR10_REG		(EPIC_EUMBBAR + 0x10340)
#define EPIC_IIVPR11_REG		(EPIC_EUMBBAR + 0x10360)
#define EPIC_IIVPR12_REG		(EPIC_EUMBBAR + 0x10380)
#define EPIC_IIVPR13_REG		(EPIC_EUMBBAR + 0x103a0)
#define EPIC_IIVPR14_REG		(EPIC_EUMBBAR + 0x103c0)
#define EPIC_IIVPR15_REG		(EPIC_EUMBBAR + 0x103e0)
#define EPIC_IIVPR16_REG		(EPIC_EUMBBAR + 0x10400)
#define EPIC_IIVPR17_REG		(EPIC_EUMBBAR + 0x10420)
#define EPIC_IIVPR18_REG		(EPIC_EUMBBAR + 0x10440)
#define EPIC_IIVPR19_REG		(EPIC_EUMBBAR + 0x10460)
#define EPIC_IIVPR20_REG		(EPIC_EUMBBAR + 0x10480)
#define EPIC_IIVPR21_REG		(EPIC_EUMBBAR + 0x104a0)
#define EPIC_IIVPR22_REG		(EPIC_EUMBBAR + 0x104c0)
#define EPIC_IIVPR23_REG		(EPIC_EUMBBAR + 0x104e0)
#define EPIC_IIVPR24_REG		(EPIC_EUMBBAR + 0x10500)
#define EPIC_IIVPR25_REG		(EPIC_EUMBBAR + 0x10520)
#define EPIC_IIVPR26_REG		(EPIC_EUMBBAR + 0x10540)
#define EPIC_IIVPR27_REG		(EPIC_EUMBBAR + 0x10560)
#define EPIC_IIVPR28_REG		(EPIC_EUMBBAR + 0x10580)
#define EPIC_IIVPR29_REG		(EPIC_EUMBBAR + 0x105a0)
#define EPIC_IIVPR30_REG		(EPIC_EUMBBAR + 0x105c0)
#define EPIC_IIVPR31_REG		(EPIC_EUMBBAR + 0x105e0)

//#endif

/* Error code */

#define OK			0
#define epicModeError		1
#define ULONG unsigned long

/* function prototypes */
/* tpeters Oct.'99 added 3 function prototypes */
void epicErrorHandler(unsigned int error_code);
void epicISR (); 
extern void epicISRConnect (int vector, VOIDFUNCPTR srcISRAddr);

void epicVendorId( unsigned int *step, 
		   unsigned int *devId,  
		   unsigned int *venId
		 );
void epicFeatures( unsigned int *noIRQs,
	           unsigned int *noCPUs,
		   unsigned int *VerId );
extern void epicInit( void);
extern void epicDefault();
ULONG sysEUMBBARRead ( ULONG regNum );
void sysEUMBBARWrite ( ULONG regNum, ULONG regVal);
extern void epicTmFrequencySet( unsigned int frq );
extern unsigned int epicTmFrequencyGet();
extern unsigned int epicTmBaseSet( ULONG srcAddr,
			           unsigned int cnt,
			           unsigned int inhibit );
extern unsigned int epicTmBaseGet ( ULONG srcAddr, unsigned int *val );
extern unsigned int epicTmCountGet( ULONG srcAddr, unsigned int *val );
extern unsigned int epicTmInhibit( ULONG srcAdr );
extern unsigned int epicTmEnable( ULONG srcAdr );
extern void CoreExtIntEnable( );	/* Enable 603e external interrupts */
extern void CoreExtIntDisable( );	/* Disable 603e external interrupts */
extern void epicSetupTransferTable();   /* setup DINK's dynamic functions */
extern unsigned char epicIntTaskGet();
extern unsigned int epicIntAck();
/*added by tpeters Oct 99 */
extern void epicEOI();
extern void epicConfigGet( unsigned int *clkRatio, 
		           unsigned int *serEnable );
extern unsigned int  epicModeGet();
extern void epicIntEnable(int Vect);
extern void epicIntDisable(int Vect);
extern int epicIntSourceConfig(int Vect, int Polarity, int Sense, int Prio);
extern int epicCurTaskPrioSet(int Vect);
extern void epicStatPrint();
extern void epicSourcePrint(int Vect);

/* tpeters Oct 99: modified structure to hold Interrupt Service Routine
   function address for each vector */
struct SrcVecTable 
    {
     ULONG srcAddr;
     char  srcName[40];
     VOIDFUNCPTR isrAddr;
    };

/* The following is needed to set up the Message Unit
   if an agent is detected. The host init code will
   store the IRQ line the agent is in into pmcIntLine.
   The host EPIC unit will set up the interrupt vector
   for that IRQ line.
   The agent init code will set its copy of pmcIntLine
   to AGENT_DETECTED. The agent EPIC unit will set up the
   interrupt vector for the Message Unit (vector 23).

   pmcIntLine is the global to hold Kahlua Agent IRQ line
   pmcIntLine is defined and set in main.c
     pmcIntLine = 0xff	- no agent detected
     pmcIntLine = 0	- agent detected on line 0 
     pmcIntLine = 1	- agent detected on line 1
     pmcIntLine = 2	- agent detected on line 2
     pmcIntLine = 3	- agent detected on line 3 */

extern int pmcIntLine;
#define AGENT_DETECTED	23

#endif   /*  EPIC_H */
