/*
#######################################
#FILE
#	$RCSfile: 8560ads_RevA_init.c,v $
#	$Date: 2004/10/27 12:08:13 $
#	$Revision: 1.2 $
#DESCRIPTION
#	initialization file for 8560ADS Pilot board
#COPYRIGHT	
#	(c) 2003 Metrowerks Corporation
#	All rights reserved.
#HISTORY
#   $Log: 8560ads_RevA_init.c,v $
#   Revision 1.2  2004/10/27 12:08:13  c-dnegrea
#   Enabled PQ3 branch prediction in BUCSR
#
#   Revision 1.1  2004/08/26 16:10:17  vcambrea
#   8560ADS Rev.A specific ROM image init (modified from 8560ADS_init.cfg)
#   changes : Local Bus SDRAM timing, suplimentary delay before accessing internal memory map after relocation
#
#   Revision 1.8  2004/04/21 08:21:36  milies
#   enable L1 cache in usr_init() if CACHE_VERSION defined
#
#   Revision 1.7  2004/02/24 17:38:31  milies
#   set only the necessary bits to enable trap debug event in DBCR0; the other bits left unchanged; fix @MTWX11597
#   
########################################
*/

#pragma section code_type ".init"

#ifdef __cplusplus
extern "C" {
#endif

asm void __reset(void);
asm void usr_init();
extern void __start();
extern unsigned long gInterruptVectorTable;
extern unsigned long gInterruptVectorTableEnd;

#ifdef __cplusplus
}
#endif


asm void __reset(void)
{
	//
	//   Enable machine check exceptions, SPE, debug interrupts
	//
	lis		r3, 0x0200
	ori		r3, r3, 0x1200
	mtmsr	r3
		
	b		__start
}

asm void usr_init()
{
	nofralloc


#ifdef ROM_VERSION

	// init mmu
	////////////////////
	

	// 1MB TLB1 entry 1 - CCSR: 0x40000000 - 0x400FFFFF
	lis		r5, 0x1001
	ori		r5, r5, 0x0000
	mtspr	624, r5

	lis		r5, 0x8000
	ori		r5, r5, 0x0500
	mtspr	625, r5

	lis		r5, 0x4000
	ori		r5, r5, 0x0008
	mtspr	626, r5

	lis		r5, 0x4000
	ori		r5, r5, 0x003f
	mtspr	627, r5

	tlbwe
	msync
	isync


	// 64MB TLB1 entry 2 - SDRAM: 0xC0000000 - 0xC3FFFFFF
	lis		r5, 0x1002
	ori		r5, r5, 0x0000
	mtspr	624, r5

	lis		r5, 0x8000
	ori		r5, r5, 0x0800
	mtspr	625, r5

	lis		r5, 0xc000
	ori		r5, r5, 0x0008 
	mtspr	626, r5

	lis		r5, 0xc000
	ori		r5, r5, 0x003f
	mtspr	627, r5

	tlbwe
	msync
	isync

	// 64MB TLB1 entry 3 - DDR: 0x00000000 - 0x03FFFFFF
	lis		r5, 0x1003
	ori		r5, r5, 0x0000
	mtspr	624, r5

	lis		r5, 0x8000
	ori		r5, r5, 0x0800
	mtspr	625, r5

	lis		r5, 0x0000
	ori		r5, r5, 0x0000	// cacheable
	mtspr	626, r5

	lis		r5, 0x0000
	ori		r5, r5, 0x003f
	mtspr	627, r5

	tlbwe
	msync
	isync

	// 64MB TLB1 entry 4 - DDR: 0x04000000 - 0x07FFFFFF
	lis		r5, 0x1004
	ori		r5, r5, 0x0000
	mtspr	624, r5

	lis		r5, 0x8000
	ori		r5, r5, 0x0800
	mtspr	625, r5

	lis		r5, 0x0400
	ori		r5, r5, 0x0000	// cacheable
	mtspr	626, r5

	lis		r5, 0x0400
	ori		r5, r5, 0x003f
	mtspr	627, r5

	tlbwe
	msync
	isync

	// TLB entry 5 - FLASH: 0xFF000000 - 0xFFFFFFFF
	lis		r5, 0x1005
	ori		r5, r5, 0x0000
	mtspr	624, r5

	lis		r5, 0x8000
	ori		r5, r5, 0x0700
	mtspr	625, r5

	lis		r5, 0xFF00
	ori		r5, r5, 0x0008
	mtspr	626, r5

	lis		r5, 0xFF00
	ori		r5, r5, 0x003f
	mtspr	627, r5

	tlbwe
	msync
	isync

	// 16MB TLB entry 6 - 0xF0000000 - 0xF0FFFFFF
	lis		r5, 0x1006
	ori		r5, r5, 0x0000
	mtspr	624, r5

	lis		r5, 0x8000
	ori		r5, r5, 0x0700
	mtspr	625, r5

	lis		r5, 0xf000
	ori		r5, r5, 0x0008
	mtspr	626, r5

	lis		r5, 0xf000
	ori		r5, r5, 0x003f
	mtspr	627, r5

	tlbwe
	msync
	isync


	// CCSRBAR at 0x40000000	
	lis		r5, 0x0004
	ori		r5, r5, 0x0000
	lis		r4, 0xFF700000@ha
	stw		r5, 0xFF700000@l(r4)

	// wait 200
	addi  r5,0,0x3000
	mtspr CTR,r5
wait_loop_1:
    bc    16,0,wait_loop_1  // Decrement CTR, then branch if CTR is not 0      
	
	// local access window 0 - DDR
	lis		r5, 0x0000			//0x00000000
	ori		r5, r5, 0x0000	
	lis		r4, 0x40000c08@ha
	stw		r5, 0x40000c08@l(r4)
	
	lis		r5, 0x80f0
	ori		r5, r5, 0x001a		// 128MB
	lis		r4, 0x40000c10@ha
	stw		r5, 0x40000c10@l(r4)
	
	// local access window 1 - local bus
	lis		r5, 0x000c			// 0xc0000000
	ori		r5, r5, 0x0000
	lis		r4, 0x40000c28@ha
	stw		r5, 0x40000c28@l(r4)
	
	lis		r5, 0x8040
	ori		r5, r5, 0x001d		//1GB
	lis		r4, 0x40000c30@ha
	stw		r5, 0x40000c30@l(r4)
	
	// ddr initialization
	lis		r5, 0x0000
	ori		r5, r5, 0x0007
	lis		r4, 0x40002000@ha
	stw		r5, 0x40002000@l(r4)
	
	lis		r5, 0x8000
	ori		r5, r5, 0x0002
	lis		r4, 0x40002080@ha
	stw		r5, 0x40002080@l(r4)
	
	lis		r5, 0x3754
	ori		r5, r5, 0x4321
	lis		r4, 0x40002108@ha
	stw		r5, 0x40002108@l(r4)
	
	lis		r5, 0x0000
	ori		r5, r5, 0x0800
	lis		r4, 0x4000210C@ha
	stw		r5, 0x4000210C@l(r4)
	
	lis		r5, 0x0200
	ori		r5, r5, 0x0000
	lis		r4, 0x40002110@ha
	stw		r5, 0x40002110@l(r4)
	
	lis		r5, 0x0000
	ori		r5, r5, 0x0062
	lis		r4, 0x40002118@ha
	stw		r5, 0x40002118@l(r4)
	
	lis		r5, 0x03a3
	ori		r5, r5, 0x0000
	lis		r4, 0x40002124@ha
	stw		r5, 0x40002124@l(r4)
	
	// wait 200
	addi  r5,0,0x0200
	mtspr CTR,r5
wait_loop:
    bc    16,0,wait_loop  // Decrement CTR, then branch if CTR is not 0      

	lis		r5, 0xc200
	ori		r5, r5, 0x0000
	lis		r4, 0x40002110@ha
	stw		r5, 0x40002110@l(r4)
	
	// configure local bus memory controller

	lis		r5, 0xff00
	ori		r5, r5, 0x1801
	lis		r4, 0x40005000@ha
	stw		r5, 0x40005000@l(r4)
	
	lis		r5, 0xff00
	ori		r5, r5, 0x6ff7
	lis		r4, 0x40005004@ha
	stw		r5, 0x40005004@l(r4)
	
	lis		r5, 0xfc00
	ori		r5, r5, 0x6901
	lis		r4, 0x40005014@ha
	stw		r5, 0x40005014@l(r4)
	
	lis		r5, 0xc000
	ori		r5, r5, 0x1861
	lis		r4, 0x40005010@ha
	stw		r5, 0x40005010@l(r4)
	
	lis		r5, 0x0000
	ori		r5, r5, 0x0000
	lis		r4, 0x400050d0@ha
	stw		r5, 0x400050d0@l(r4)
	
	lis		r5, 0x0003
	ori		r5, r5, 0x0004
	lis		r4, 0x400050d4@ha
	stw		r5, 0x400050d4@l(r4)
	
	lis		r5, 0x2000
	ori		r5, r5, 0x0000
	lis		r4, 0x400050a4@ha
	stw		r5, 0x400050a4@l(r4)
	
	lis		r5, 0x2000
	ori		r5, r5, 0x0000
	lis		r4, 0x40005084@ha
	stw		r5, 0x40005084@l(r4)
	
	lis		r5, 0x0061
	ori		r5, r5, 0xb723
	lis		r4, 0x40005094@ha
	stw		r5, 0x40005094@l(r4)
	
	lis		r5, 0x2861
	ori		r5, r5, 0xb723
	lis		r4, 0x40005094@ha
	stw		r5, 0x40005094@l(r4)
	
	lis		r5, 0x0000
	ori		r5, r5, 0x00ff
	lis		r4, 0xC0000000@ha
	stw		r5, 0xC0000000@l(r4)
	
	lis		r5, 0x0861
	ori		r5, r5, 0xb723
	lis		r4, 0x40005094@ha
	stw		r5, 0x40005094@l(r4)
	
	addi  r6,0,0x0008
	mtspr CTR,r6
	lis		r5, 0x0000
	ori		r5, r5, 0x00ff
	lis		r4, 0xC0000000@ha
write_loop:
	stw		r5, 0xC0000000@l(r4)
    bc    16,0,write_loop  // Decrement CTR, then branch if CTR is not 0      

	
	lis		r5, 0x1861
	ori		r5, r5, 0xB723
	lis		r4, 0x40005094@ha
	stw		r5, 0x40005094@l(r4)
	
	lis		r5, 0x0000
	ori		r5, r5, 0x00ff
	lis		r4, 0xC00000cc@ha
	stw		r5, 0xC00000cc@l(r4)
	
	lis		r5, 0x4061
	ori		r5, r5, 0xB723
	lis		r4, 0x40005094@ha
	stw		r5, 0x40005094@l(r4)
	
	// ADS communication control registers initialization	
	lis		r5, 0xF050
	ori		r5, r5, 0x8801
	lis		r4, 0x40005020@ha
	stw		r5, 0x40005020@l(r4)
	
	lis		r5, 0xffff
	ori		r5, r5, 0xE9F7
	lis		r4, 0x40005024@ha
	stw		r5, 0x40005024@l(r4)
	

	// interrupt vectors initialization
	lis		r4, 0x0000
	lis		r5, 0x0000
	ori		r5, r5, 0x0000
	mtspr	IVPR, r5

	ori		r4, r5, 0x0100
	mtspr	IVOR0, r4
	ori		r4, r5, 0x0200
	mtspr	IVOR1, r4
	ori		r4, r5, 0x0300
	mtspr	IVOR2, r4
	ori		r4, r5, 0x0400
	mtspr	IVOR3, r4
	ori		r4, r5, 0x0500
	mtspr	IVOR4, r4
	ori		r4, r5, 0x0600
	mtspr	IVOR5, r4
	ori		r4, r5, 0x0700
	mtspr	IVOR6, r4
	ori		r4, r5, 0x0c00
	mtspr	IVOR8, r4
	ori		r4, r5, 0x0900
	mtspr	IVOR10, r4
	ori		r4, r5, 0x0f00
	mtspr	IVOR11, r4
	ori		r4, r5, 0x0b00
	mtspr	IVOR12, r4
	ori		r4, r5, 0x1100
	mtspr	IVOR13, r4
	ori		r4, r5, 0x1000
	mtspr	IVOR14, r4
	ori		r4, r5, 0x1500
	mtspr	IVOR15, r4
	ori		r4, r5, 0x1600
	mtspr	IVOR32, r4
	ori		r4, r5, 0x1700
	mtspr	IVOR33, r4
	ori		r4, r5, 0x1800
	mtspr	IVOR34, r4
	ori		r4, r5, 0x1900
	mtspr	IVOR35, r4

	//enable trap debug event in DBCR0
	mfspr	r5, 308
	oris	r5, r5, 0x4100
	ori		r5, r5, 0x0000
	mtspr	308, r5
	

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Copy the exception vectors from ROM to RAM
//
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	
	lis			r3, gInterruptVectorTable@h
	ori			r3, r3, gInterruptVectorTable@l
	subi		r3,r3,0x0004
	
	lis			r4, gInterruptVectorTableEnd@h
	ori			r4, r4, gInterruptVectorTableEnd@l
	
	lis			r5, 0xFFFF
	ori			r5,r5,0xFFFC
	
loop:
	lwzu		r6, 4(r3)
	stwu		r6, 4(r5)
	
	cmpw		r3,r4
	blt			loop
#endif  

#ifdef CACHE_VERSION
	mfspr	r3,L1CSR0	/* enable d-cache */
	ori		r3, r3, 0x0001
	mtspr	L1CSR0,r3

	mfspr	r3,L1CSR1	/* enable i-cache */
	ori		r3, r3, 0x0001
	mtspr	L1CSR1,r3
	
	mfspr	r3,BUCSR 	/* enable branch prediction in BUCSR */
	ori		r3, r3, 0x0001
	mtspr	BUCSR,r3 

	isync		
	msync		
#endif
  
   blr 
}
