//////////////////////////
//	Project Stationery  //
//////////////////////////

#include <stdio.h>



/*
   System Memory Base Address.
*/
#define     MBAR_ADDR                   0xE0000000



/*
   Registers' offsets.
*/
#define     ERR_INJECT_OFFSET           0x2E08
#define     ERR_DISABLE_OFFSET          0x2E44
#define     ERR_INT_EN_OFFSET           0x2E48
#define     ERR_SBE_OFFSET              0x2E58
#define     SICFR_OFFSET                0x700
#define     SIMSR_L_OFFSET              0x724



/*   
   This value defines the number of single bit errors to be detected before
   raising an exception. For additional detail see the Reference Manual.
*/
#define     ERR_SBE_THRESHOLD      0x00A00000



/*
   NUM_CHARS defines the number of char's accessed in order to generate
   single-bit errors. Here's how to calculate the number of exceptions
   generated (approximately):

                          NUM_CHARS - CACHE_SIZE
       NumExceptions = -----------------------------
                        8 bytes x ERR_SBE_THRESHOLD

   The cache size (32k) is subtracted because only accesses to data in
   memory generate errors. The division by 8 is performed because 64 bits
   (8 bytes) are read per memory access. It is also necessary to divide
   by ERR_SBE_THRESHOLD because an exception will only occur when that
   threshold is exceed.
   Note that this is an aproximate formula valid for some, but by no means
   all, values of NumExceptions.
   The value 37248 was calculated so that 3 exceptions would be generated
   during program execution, and based on ERR_SBE_THRESHOLD = 0xA0 and
   CACHE_SIZE = 32 kbytes. To generate 3 exceptions, the NumExceptions used
   used was 3.5 (to be well between 3 and 4).
*/
#define     NUM_CHARS     37248



int main ()
{
    
    /* Local variables */

    /* Pointers to char to address memory */
    unsigned char *charPtr1, *charPtr2;
    /* Index for 'for' loops */
    unsigned int i;


    /*
       Set the pointers to some harmless addresses in memory. Make sure this
       addresses exist and are free on your system.
     */
    charPtr1 = (unsigned char*)0x00100000;
    charPtr2 = (unsigned char*)0x00200000;



    /*
       Set DDR as the source for the Highest Priority Interrupt (HPI) and
       select Critical Interrupt (cint) as the output for HPI.
       
       SICFR: System Global Interrupt Configuration Register
     
       SICFR[HPI]  = 0x4C (DDR)
       SICFR[HPIT] = 0x2  (cint)
     */
    *((unsigned int*)(MBAR_ADDR + SICFR_OFFSET)) = 0x4C000200;



    /*
       Unmask interrupts originated by DDR.
       
       SIMSR_L: System Internal Interrupt Mask Register (Low)
     
       SIMSR_L = 0x00080000 <=> SIMSR_L[12] = 1 <=> DDR interrupts not masked.
     */
    *((unsigned int*)(MBAR_ADDR + SIMSR_L_OFFSET)) = 0x00080000;



    /* 
       Enable External and Critical interrupts in the Machine State Register.
       
       MSR[EE]=1 (External interrupt enable)
       MSR[CE]=1 (Critical interrupt enable)
     */
    asm("mfmsr r5");
    asm("ori r4, r5, 0x8080");
    asm("mtmsr r4");
    asm("isync");
    asm("sync");



    /*
       Enable interrupt generation when ECC single-bit errors are detected.
       
       ERR_INT_EN: Memory Error Interrupt Enable
    
       ERR_INT_EN[SBEE]=1;
     */
    *((unsigned int*)(MBAR_ADDR + ERR_INT_EN_OFFSET)) = 0x00000004;



    /*
       Set the number of single-bit errors to be detected before an exception
       is generated.
       
       ERR_SBE: Single-Bit ECC Memory Error Management 
    
       Example: ERR_SBE[SBET]=0xA0 (other values can be chosen)
     */
    *((unsigned int*)(MBAR_ADDR + ERR_SBE_OFFSET)) = ERR_SBE_THRESHOLD;



    /*
       Temporarily enable single-bit error injection to generate single-bit
       errors in memory.

       ERR_INJECT: Memory Data Path Error Injection Mask ECC 
           
       ERR_INJECT[EIEN]=1
       ERR_INJECT[EEIM]=0x01
     */
    *((unsigned int*)(MBAR_ADDR + ERR_INJECT_OFFSET)) = 0x00000110;



    /*
       Inject single-bit errors in the memory area starting at the address
       pointed to by charPtr1.
     */
    for (i = 0; i < NUM_CHARS; i++)
    {
        charPtr1[i] = 0xAB;
    }



    /*
       Single-bit errors already generated and stored in memory, therefore
       disable single-sit error injection.

       ERR_INJECT: Memory Data Path Error Injection Mask ECC

       ERR_INJECT[EIEN]=0
       ERR_INJECT[EEIM]=0
     */
    *((unsigned int*)(MBAR_ADDR + ERR_INJECT_OFFSET)) = 0x00000000;



   /*
      This 'for' cycle, if uncommented, assigns charPtr1's contents to itself.
      This will cause writes to memory during which the single-bit errors
      previously generated will be corrected. This highlights the DDR
      controller's single-bit error correction capabilities. Please note
      that to ensure that memory is effectively written, NUM_CHARS must be
      bigger than the size of the Data-Cache. Uncommenting this cycle allows
      the program to run without generating any exceptions.

    for (i = 0; i < NUM_CHARS; i++)
    {
        charPtr1[i] = charPtr1[i];
    }
      
    */



    /*
       Enable single-bit error detection (SBED). All other errors are not
       detected nor reported.
       
       ERR_DISABLE: Memory Error Disable
       
       ERR_DISABLE[ACED, MBED, MSED] = 1 (disabled)
       ERR_DISABLE[SBED] = 0 (enabled)
       
     */
    *((unsigned int*)(MBAR_ADDR + ERR_DISABLE_OFFSET)) = 0x000000089;



    /*
       Each iteration of this "for" loop causes one read access to the
       single-bit-errored memory area pointed by charPtr - when the accessed
       area is not in Data-Cache. When the number of single-bit errors
       caused by the memory accesses exceeds the threshold set in
       ERR_SBE[SBET], the exception is generated and the PC jumps to the
       corresponding interrupt vector address.
       
       IMPORTANT NOTE: When single-stepping through the code with JTAG,
       the program is unable to return from the exception handler routine
       (not tested with other target debuggers). It is advised to set a
       breakpoint before the end of main(), run the program and then check
       the number of times the exception-handling routine printed on the
       console.
     */
    for (i = 0; i < NUM_CHARS; i++)
    {
        charPtr2[i] = charPtr1[i];
    }



    /*
       Place a break point here to make sure the program returns from the
       interrupt-handling routine.     
     */
    return 0;

}

