; Based on CPU DB MC9RS08KA2_8, version 2.87.036 (RegistersPrg V2.05)

; ###################################################################
;     Filename  : MC9RS08KA2.inc
;     Processor : MC9RS08KA2DN
;     FileFormat: V2.05
;     DataSheet : MC9RS08KA2 Rev. 0.09 03/10/2006
;     Compiler  : CodeWarrior compiler
;     Date/Time : 30.03.2006, 15:19
;     Abstract  :
;         This header implements the mapping of I/O devices.
;
;     (c) Copyright UNIS, spol. s r.o. 1997-2006
;     UNIS, spol. s r.o.
;     Jundrovska 33
;     624 00 Brno
;     Czech Republic
;     http      : www.processorexpert.com
;     mail      : info@processorexpert.com
;
;     File-Format-Revisions:
;      - 24.03.2006, V2.05 :
;               - Fixed macro __RESET_WATCHDOG for HCS12 family - address and correct write order.
;
;     CPU Registers Revisions:
;               - none
; ###################################################################

;*** Memory Map
;******************************************
TINY_RAMStart:      equ   $00000000
TINY_RAMEnd:        equ   $0000000D
RAMStart:           equ   $00000020
RAMEnd:             equ   $0000004F
ROMStart:           equ   $00003800
ROMEnd:             equ   $00003FF7
RESET_JMP_AREAStart: equ   $00003FFD
RESET_JMP_AREAEnd:  equ   $00003FFF
;
;


;*** PTAD - Port A Data Register; 0x00000010 ***
PTAD:               equ    $00000010                                ;*** PTAD - Port A Data Register; 0x00000010 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTAD_PTAD0:         equ    0                                         ; Port A Data Register Bit 0
PTAD_PTAD1:         equ    1                                         ; Port A Data Register Bit 1
PTAD_PTAD2:         equ    2                                         ; Port A Data Register Bit 2
PTAD_PTAD3:         equ    3                                         ; Port A Data Register Bit 3
PTAD_PTAD4:         equ    4                                         ; Port A Data Register Bit 4
PTAD_PTAD5:         equ    5                                         ; Port A Data Register Bit 5
; bit position masks
mPTAD_PTAD0:        equ    %00000001
mPTAD_PTAD1:        equ    %00000010
mPTAD_PTAD2:        equ    %00000100
mPTAD_PTAD3:        equ    %00001000
mPTAD_PTAD4:        equ    %00010000
mPTAD_PTAD5:        equ    %00100000


;*** PTADD - Data Direction Register A; 0x00000011 ***
PTADD:              equ    $00000011                                ;*** PTADD - Data Direction Register A; 0x00000011 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTADD_PTADD0:       equ    0                                         ; Data Direction for Port A Bit 0
PTADD_PTADD1:       equ    1                                         ; Data Direction for Port A Bit 1
PTADD_PTADD4:       equ    4                                         ; Data Direction for Port A Bit 4
PTADD_PTADD5:       equ    5                                         ; Data Direction for Port A Bit 5
; bit position masks
mPTADD_PTADD0:      equ    %00000001
mPTADD_PTADD1:      equ    %00000010
mPTADD_PTADD4:      equ    %00010000
mPTADD_PTADD5:      equ    %00100000


;*** ACMPSC - Analog Comparator Status and Control Register; 0x00000013 ***
ACMPSC:             equ    $00000013                                ;*** ACMPSC - Analog Comparator Status and Control Register; 0x00000013 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ACMPSC_ACMOD0:      equ    0                                         ; Analog Comparator Mode Bit 0
ACMPSC_ACMOD1:      equ    1                                         ; Analog Comparator Mode Bit 1
ACMPSC_ACOPE:       equ    2                                         ; Analog Comparator Output Pin Enable
ACMPSC_ACO:         equ    3                                         ; Analog Comparator Output
ACMPSC_ACIE:        equ    4                                         ; Analog Comparator Interrupt Enable
ACMPSC_ACF:         equ    5                                         ; Analog Comparator Flag
ACMPSC_ACBGS:       equ    6                                         ; Analog Comparator Bandgap Select
ACMPSC_ACME:        equ    7                                         ; Analog Comparator Module Enable
; bit position masks
mACMPSC_ACMOD0:     equ    %00000001
mACMPSC_ACMOD1:     equ    %00000010
mACMPSC_ACOPE:      equ    %00000100
mACMPSC_ACO:        equ    %00001000
mACMPSC_ACIE:       equ    %00010000
mACMPSC_ACF:        equ    %00100000
mACMPSC_ACBGS:      equ    %01000000
mACMPSC_ACME:       equ    %10000000


;*** ICSC1 - ICS Control Register 1; 0x00000014 ***
ICSC1:              equ    $00000014                                ;*** ICSC1 - ICS Control Register 1; 0x00000014 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ICSC1_IREFSTEN:     equ    0                                         ; Internal Reference Stop Enable
ICSC1_CLKS:         equ    6                                         ; Clock Source Select
; bit position masks
mICSC1_IREFSTEN:    equ    %00000001
mICSC1_CLKS:        equ    %01000000


;*** ICSC2 - ICS Control Register 2; 0x00000015 ***
ICSC2:              equ    $00000015                                ;*** ICSC2 - ICS Control Register 2; 0x00000015 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ICSC2_LP:           equ    3                                         ; Low Power Select
ICSC2_BDIV:         equ    6                                         ; Bus Frequency Divider
; bit position masks
mICSC2_LP:          equ    %00001000
mICSC2_BDIV:        equ    %11000000


;*** ICSTRM - ICS Trim Register; 0x00000016 ***
ICSTRM:             equ    $00000016                                ;*** ICSTRM - ICS Trim Register; 0x00000016 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ICSTRM_TRIM:        equ    0                                         ; ICS Trim Setting
; bit position masks
mICSTRM_TRIM:       equ    %11111111


;*** ICSSC - ICS Status and Control; 0x00000017 ***
ICSSC:              equ    $00000017                                ;*** ICSSC - ICS Status and Control; 0x00000017 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ICSSC_FTRIM:        equ    0                                         ; ICS Fine Trim
ICSSC_CLKST:        equ    2                                         ; Clock Mode Status
; bit position masks
mICSSC_FTRIM:       equ    %00000001
mICSSC_CLKST:       equ    %00000100


;*** MTIMSC - MTIM Status and Control Register; 0x00000018 ***
MTIMSC:             equ    $00000018                                ;*** MTIMSC - MTIM Status and Control Register; 0x00000018 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MTIMSC_TSTP:        equ    4                                         ; MTIM Counter Stop
MTIMSC_TRST:        equ    5                                         ; MTIM Counter Reset
MTIMSC_TOIE:        equ    6                                         ; MTIM Overflow Interrupt Enable
MTIMSC_TOF:         equ    7                                         ; MTIM Overflow Flag
; bit position masks
mMTIMSC_TSTP:       equ    %00010000
mMTIMSC_TRST:       equ    %00100000
mMTIMSC_TOIE:       equ    %01000000
mMTIMSC_TOF:        equ    %10000000


;*** MTIMCLK - MTIM Clock Configuration Register; 0x00000019 ***
MTIMCLK:            equ    $00000019                                ;*** MTIMCLK - MTIM Clock Configuration Register; 0x00000019 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MTIMCLK_PS:         equ    0                                         ; Clock Source Prescaler
MTIMCLK_CLKS:       equ    4                                         ; Clock Source Select
; bit position masks
mMTIMCLK_PS:        equ    %00001111
mMTIMCLK_CLKS:      equ    %00110000


;*** MTIMCNT - MTIM Counter Register; 0x0000001A ***
MTIMCNT:            equ    $0000001A                                ;*** MTIMCNT - MTIM Counter Register; 0x0000001A ***


;*** MTIMMOD - MTIM Modulo Register; 0x0000001B ***
MTIMMOD:            equ    $0000001B                                ;*** MTIMMOD - MTIM Modulo Register; 0x0000001B ***


;*** KBISC - KBI Status and Control; 0x0000001C ***
KBISC:              equ    $0000001C                                ;*** KBISC - KBI Status and Control; 0x0000001C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
KBISC_KBIMOD:       equ    0                                         ; Keyboard Detection Mode
KBISC_KBIE:         equ    1                                         ; Keyboard Interrupt Enable
KBISC_KBACK:        equ    2                                         ; Keyboard Interrupt Acknowledge
KBISC_KBF:          equ    3                                         ; Keyboard Interrupt Flag
; bit position masks
mKBISC_KBIMOD:      equ    %00000001
mKBISC_KBIE:        equ    %00000010
mKBISC_KBACK:       equ    %00000100
mKBISC_KBF:         equ    %00001000


;*** KBIPE - KBI Pin Enable Register; 0x0000001D ***
KBIPE:              equ    $0000001D                                ;*** KBIPE - KBI Pin Enable Register; 0x0000001D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
KBIPE_KBIPE0:       equ    0                                         ; Keyboard Pin Enable for Port A Bit 0
KBIPE_KBIPE1:       equ    1                                         ; Keyboard Pin Enable for Port A Bit 1
KBIPE_KBIPE2:       equ    2                                         ; Keyboard Pin Enable for Port A Bit 2
KBIPE_KBIPE4:       equ    4                                         ; Keyboard Pin Enable for Port A Bit 4
KBIPE_KBIPE5:       equ    5                                         ; Keyboard Pin Enable for Port A Bit 5
; bit position masks
mKBIPE_KBIPE0:      equ    %00000001
mKBIPE_KBIPE1:      equ    %00000010
mKBIPE_KBIPE2:      equ    %00000100
mKBIPE_KBIPE4:      equ    %00010000
mKBIPE_KBIPE5:      equ    %00100000


;*** KBIES - KBI Edge Select Register; 0x0000001E ***
KBIES:              equ    $0000001E                                ;*** KBIES - KBI Edge Select Register; 0x0000001E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
KBIES_KBEDG0:       equ    0                                         ; Keyboard Edge Select Bit 0
KBIES_KBEDG1:       equ    1                                         ; Keyboard Edge Select Bit 1
KBIES_KBEDG2:       equ    2                                         ; Keyboard Edge Select Bit 2
KBIES_KBEDG4:       equ    4                                         ; Keyboard Edge Select Bit 4
KBIES_KBEDG5:       equ    5                                         ; Keyboard Edge Select Bit 5
; bit position masks
mKBIES_KBEDG0:      equ    %00000001
mKBIES_KBEDG1:      equ    %00000010
mKBIES_KBEDG2:      equ    %00000100
mKBIES_KBEDG4:      equ    %00010000
mKBIES_KBEDG5:      equ    %00100000


;*** PAGESEL - Page Register; 0x0000001F ***
PAGESEL:            equ    $0000001F                                ;*** PAGESEL - Page Register; 0x0000001F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PAGESEL_AD6:        equ    0                                         ; Page Selector Bit 6
PAGESEL_AD7:        equ    1                                         ; Page Selector Bit 7
PAGESEL_AD8:        equ    2                                         ; Page Selector Bit 8
PAGESEL_AD9:        equ    3                                         ; Page Selector Bit 9
PAGESEL_AD10:       equ    4                                         ; Page Selector Bit 10
PAGESEL_AD11:       equ    5                                         ; Page Selector Bit 11
PAGESEL_AD12:       equ    6                                         ; Page Selector Bit 12
PAGESEL_AD13:       equ    7                                         ; Page Selector Bit 13
; bit position masks
mPAGESEL_AD6:       equ    %00000001
mPAGESEL_AD7:       equ    %00000010
mPAGESEL_AD8:       equ    %00000100
mPAGESEL_AD9:       equ    %00001000
mPAGESEL_AD10:      equ    %00010000
mPAGESEL_AD11:      equ    %00100000
mPAGESEL_AD12:      equ    %01000000
mPAGESEL_AD13:      equ    %10000000


;*** SRS - System Reset Status Register; 0x00000200 ***
SRS:                equ    $00000200                                ;*** SRS - System Reset Status Register; 0x00000200 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SRS_LVD:            equ    1                                         ; Low Voltage Detect
SRS_ILAD:           equ    3                                         ; Illegal Address
SRS_ILOP:           equ    4                                         ; Illegal Opcode
SRS_COP:            equ    5                                         ; Computer Operating Properly (COP) Watchdog
SRS_PIN:            equ    6                                         ; External Reset Pin
SRS_POR:            equ    7                                         ; Power-On Reset
; bit position masks
mSRS_LVD:           equ    %00000010
mSRS_ILAD:          equ    %00001000
mSRS_ILOP:          equ    %00010000
mSRS_COP:           equ    %00100000
mSRS_PIN:           equ    %01000000
mSRS_POR:           equ    %10000000


;*** SOPT - System Options Register; 0x00000201 ***
SOPT:               equ    $00000201                                ;*** SOPT - System Options Register; 0x00000201 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SOPT_RSTPE:         equ    0                                         ; RESET Pin Enable
SOPT_BKGDPE:        equ    1                                         ; Background Debug Mode Pin Enable
SOPT_STOPE:         equ    5                                         ; Stop Mode Enable
SOPT_COPT:          equ    6                                         ; COP Watchdog Timeout
SOPT_COPE:          equ    7                                         ; COP Watchdog Enable
; bit position masks
mSOPT_RSTPE:        equ    %00000001
mSOPT_BKGDPE:       equ    %00000010
mSOPT_STOPE:        equ    %00100000
mSOPT_COPT:         equ    %01000000
mSOPT_COPE:         equ    %10000000


;*** SIP1 - System Interrupt Pending Register; 0x00000202 ***
SIP1:               equ    $00000202                                ;*** SIP1 - System Interrupt Pending Register; 0x00000202 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SIP1_LVD:           equ    0                                         ; Low-Voltage Detect Interrupt Pending
SIP1_RTI:           equ    1                                         ; Real-Time Interrupt Pending
SIP1_MTIM:          equ    2                                         ; Modulo Timer Interrupt Pending
SIP1_ACMP:          equ    3                                         ; Analog Comparator Interrupt Pending
SIP1_KBI:           equ    4                                         ; Keyboard Interrupt Pending
; bit position masks
mSIP1_LVD:          equ    %00000001
mSIP1_RTI:          equ    %00000010
mSIP1_MTIM:         equ    %00000100
mSIP1_ACMP:         equ    %00001000
mSIP1_KBI:          equ    %00010000


;*** SDIDH - System Device Identification Register High; 0x00000206 ***
SDIDH:              equ    $00000206                                ;*** SDIDH - System Device Identification Register High; 0x00000206 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SDIDH_ID8:          equ    0                                         ; Part Identification Number 8
SDIDH_ID9:          equ    1                                         ; Part Identification Number 9
SDIDH_ID10:         equ    2                                         ; Part Identification Number 10
SDIDH_ID11:         equ    3                                         ; Part Identification Number 11
SDIDH_REV0:         equ    4                                         ; Revision Number 0
SDIDH_REV1:         equ    5                                         ; Revision Number 1
SDIDH_REV2:         equ    6                                         ; Revision Number 2
SDIDH_REV3:         equ    7                                         ; Revision Number 3
; bit position masks
mSDIDH_ID8:         equ    %00000001
mSDIDH_ID9:         equ    %00000010
mSDIDH_ID10:        equ    %00000100
mSDIDH_ID11:        equ    %00001000
mSDIDH_REV0:        equ    %00010000
mSDIDH_REV1:        equ    %00100000
mSDIDH_REV2:        equ    %01000000
mSDIDH_REV3:        equ    %10000000


;*** SDIDL - System Device Identification Register Low; 0x00000207 ***
SDIDL:              equ    $00000207                                ;*** SDIDL - System Device Identification Register Low; 0x00000207 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SDIDL_ID0:          equ    0                                         ; Part Identification Number 0
SDIDL_ID1:          equ    1                                         ; Part Identification Number 1
SDIDL_ID2:          equ    2                                         ; Part Identification Number 2
SDIDL_ID3:          equ    3                                         ; Part Identification Number 3
SDIDL_ID4:          equ    4                                         ; Part Identification Number 4
SDIDL_ID5:          equ    5                                         ; Part Identification Number 5
SDIDL_ID6:          equ    6                                         ; Part Identification Number 6
SDIDL_ID7:          equ    7                                         ; Part Identification Number 7
; bit position masks
mSDIDL_ID0:         equ    %00000001
mSDIDL_ID1:         equ    %00000010
mSDIDL_ID2:         equ    %00000100
mSDIDL_ID3:         equ    %00001000
mSDIDL_ID4:         equ    %00010000
mSDIDL_ID5:         equ    %00100000
mSDIDL_ID6:         equ    %01000000
mSDIDL_ID7:         equ    %10000000


;*** SRTISC - System RTI Status and Control Register; 0x00000208 ***
SRTISC:             equ    $00000208                                ;*** SRTISC - System RTI Status and Control Register; 0x00000208 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SRTISC_RTIS0:       equ    0                                         ; Real-Time Interrupt Delay Select Bit 0
SRTISC_RTIS1:       equ    1                                         ; Real-Time Interrupt Delay Select Bit 1
SRTISC_RTIS2:       equ    2                                         ; Real-Time Interrupt Delay Select Bit 2
SRTISC_RTIE:        equ    4                                         ; Real-Time Interrupt Enable
SRTISC_RTICLKS:     equ    5                                         ; Real-Time Interrupt Clock Select
SRTISC_RTIACK:      equ    6                                         ; Real-Time Interrupt Acknowledge
SRTISC_RTIF:        equ    7                                         ; Real-Time Interrupt Flag
; bit position masks
mSRTISC_RTIS0:      equ    %00000001
mSRTISC_RTIS1:      equ    %00000010
mSRTISC_RTIS2:      equ    %00000100
mSRTISC_RTIE:       equ    %00010000
mSRTISC_RTICLKS:    equ    %00100000
mSRTISC_RTIACK:     equ    %01000000
mSRTISC_RTIF:       equ    %10000000


;*** SPMSC1 - System Power Management Status and Control 1 Register; 0x00000209 ***
SPMSC1:             equ    $00000209                                ;*** SPMSC1 - System Power Management Status and Control 1 Register; 0x00000209 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPMSC1_BGBE:        equ    0                                         ; Bandgap Buffer Enable
SPMSC1_LVDE:        equ    2                                         ; Low-Voltage Detect Enable
SPMSC1_LVDSE:       equ    3                                         ; Low-Voltage Detect Stop Enable
SPMSC1_LVDRE:       equ    4                                         ; Low-Voltage Detect Reset Enable
SPMSC1_LVDIE:       equ    5                                         ; Low-Voltage Detect Interrrupt Enable
SPMSC1_LVDACK:      equ    6                                         ; Low-Voltage Detect Acknowledge
SPMSC1_LVDF:        equ    7                                         ; Low-Voltage Detect Flag
; bit position masks
mSPMSC1_BGBE:       equ    %00000001
mSPMSC1_LVDE:       equ    %00000100
mSPMSC1_LVDSE:      equ    %00001000
mSPMSC1_LVDRE:      equ    %00010000
mSPMSC1_LVDIE:      equ    %00100000
mSPMSC1_LVDACK:     equ    %01000000
mSPMSC1_LVDF:       equ    %10000000


;*** FOPT - FLASH Options Register; 0x00000210 ***
FOPT:               equ    $00000210                                ;*** FOPT - FLASH Options Register; 0x00000210 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FOPT_SECD:          equ    0                                         ; Security State Code
; bit position masks
mFOPT_SECD:         equ    %00000001


;*** FLCR - FLASH Control Register; 0x00000211 ***
FLCR:               equ    $00000211                                ;*** FLCR - FLASH Control Register; 0x00000211 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FLCR_PGM:           equ    0                                         ; Program Control Bit
FLCR_MASS:          equ    2                                         ; Mass Erase Control Bit
FLCR_HVEN:          equ    3                                         ; High Voltage Enable
; bit position masks
mFLCR_PGM:          equ    %00000001
mFLCR_MASS:         equ    %00000100
mFLCR_HVEN:         equ    %00001000


;*** PTAPE - Internal Pulling Device Enable for Port A Register; 0x00000220 ***
PTAPE:              equ    $00000220                                ;*** PTAPE - Internal Pulling Device Enable for Port A Register; 0x00000220 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTAPE_PTAPE0:       equ    0                                         ; Internal Pulling Device Enable for Port A Bit 0
PTAPE_PTAPE1:       equ    1                                         ; Internal Pulling Device Enable for Port A Bit 1
PTAPE_PTAPE2:       equ    2                                         ; Internal Pulling Device Enable for Port A Bit 2
PTAPE_PTAPE4:       equ    4                                         ; Internal Pulling Device Enable for Port A Bit 4
PTAPE_PTAPE5:       equ    5                                         ; Internal Pulling Device Enable for Port A Bit 5
; bit position masks
mPTAPE_PTAPE0:      equ    %00000001
mPTAPE_PTAPE1:      equ    %00000010
mPTAPE_PTAPE2:      equ    %00000100
mPTAPE_PTAPE4:      equ    %00010000
mPTAPE_PTAPE5:      equ    %00100000


;*** PTAPUD - Pullup/Pulldown Device Control for Port A; 0x00000221 ***
PTAPUD:             equ    $00000221                                ;*** PTAPUD - Pullup/Pulldown Device Control for Port A; 0x00000221 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTAPUD_PTAPUD0:     equ    0                                         ; Pullup/Pulldown Device Control for Port A Bit 0
PTAPUD_PTAPUD1:     equ    1                                         ; Pullup/Pulldown Device Control for Port A Bit 1
PTAPUD_PTAPUD2:     equ    2                                         ; Pullup/Pulldown Device Control for Port A Bit 2
PTAPUD_PTAPUD4:     equ    4                                         ; Pullup/Pulldown Device Control for Port A Bit 4
PTAPUD_PTAPUD5:     equ    5                                         ; Pullup/Pulldown Device Control for Port A Bit 5
; bit position masks
mPTAPUD_PTAPUD0:    equ    %00000001
mPTAPUD_PTAPUD1:    equ    %00000010
mPTAPUD_PTAPUD2:    equ    %00000100
mPTAPUD_PTAPUD4:    equ    %00010000
mPTAPUD_PTAPUD5:    equ    %00100000


;*** PTASE - Slew Rate Enable for Port A Register; 0x00000222 ***
PTASE:              equ    $00000222                                ;*** PTASE - Slew Rate Enable for Port A Register; 0x00000222 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTASE_PTASE0:       equ    0                                         ; Output Slew Rate Enable for Port A Bit 0
PTASE_PTASE1:       equ    1                                         ; Output Slew Rate Enable for Port A Bit 1
PTASE_PTASE3:       equ    3                                         ; Output Slew Rate Enable for Port A Bit 3
PTASE_PTASE4:       equ    4                                         ; Output Slew Rate Enable for Port A Bit 4
PTASE_PTASE5:       equ    5                                         ; Output Slew Rate Enable for Port A Bit 5
; bit position masks
mPTASE_PTASE0:      equ    %00000001
mPTASE_PTASE1:      equ    %00000010
mPTASE_PTASE3:      equ    %00001000
mPTASE_PTASE4:      equ    %00010000
mPTASE_PTASE5:      equ    %00100000


;*** NV_ICSTRM - Nonvolatile ICS Trim Register; 0x00003FFA ***
NV_ICSTRM:          equ    $00003FFA                                ;*** NV_ICSTRM - Nonvolatile ICS Trim Register; 0x00003FFA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NV_ICSTRM_TRIM:     equ    0                                         ; ICS Trim Setting
; bit position masks
mNV_ICSTRM_TRIM:    equ    %11111111


;*** NV_FTRIM - Nonvolatile ICS Fine Trim Register; 0x00003FFB ***
NV_FTRIM:           equ    $00003FFB                                ;*** NV_FTRIM - Nonvolatile ICS Fine Trim Register; 0x00003FFB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NV_FTRIM_FTRIM:     equ    0                                         ; ICS Fine Trim
; bit position masks
mNV_FTRIM_FTRIM:    equ    %00000001


;*** NVOPT - FLASH Options Register; 0x00003FFC ***
NVOPT:              equ    $00003FFC                                ;*** NVOPT - FLASH Options Register; 0x00003FFC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVOPT_SECD:         equ    0                                         ; Security State Code
; bit position masks
mNVOPT_SECD:        equ    %00000001


;***********************************************
;**   D E P R E C I A T E D   S Y M B O L S   **
;***********************************************
        XREF    This_symb_has_been_depreciated

; EOF
