
/************************************************************************************************/
/*                                      Includes Section                                        */
/************************************************************************************************/
#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */
#include "LCD.h"
/************************************************************************************************/
/*                                     Constants Section                                        */
/************************************************************************************************/
unsigned char const TestMsg[] = {"123456789 FREESCALE SEMICONDUCTOR INC"};

/************************************************************************************************/
/*                                Function Prototipes Section                                   */
/************************************************************************************************/


/************************************************************************************************/
/*                                Global Variables Section                                      */
/************************************************************************************************/


/************************************************************************************************/
/*                                      Functions Section                                       */
/************************************************************************************************/

void main(void)
{
     unsigned int u16Delay = 0;
     unsigned long u32Counter = 20000;
     unsigned char u8ContrastFlag = 0;
     unsigned char u8Index = 0;
     unsigned char u8Test1Flag = 0;

	ICGC2 = 0x30;
	ICGC1 = 0x78;                                     /* Set Maximum Bus Frequency */
	while(!(ICGS1_LOCK))                              /* Wait PLL engage */
	{
		__RESET_WATCHDOG(); 	                    /* feeds the dog */
	}

     vfnLCDInit();                                     /* Config LCD Driver */

     /*********         Code Example        *********/

     LCDBuffer[0].u16Word = gau16CharactersArray[u8Index];
     LCDBuffer[1].u16Word = gau16CharactersArray[u8Index];
     LCDBuffer[2].u16Word = gau16CharactersArray[u8Index];
     LCDBuffer[3].u16Word = gau16CharactersArray[u8Index];
     LCDBuffer[4].u16Word = gau16CharactersArray[u8Index];
     LCDBuffer[5].u16Word = gau16CharactersArray[u8Index];
     LCDBuffer[6].u16Word = gau16CharactersArray[u8Index];
     LCDBuffer[7].u16Word = gau16CharactersArray[u8Index];
     u8Index++;
     
     EnableInterrupts;                                 /* enable interrupts */
     



/*
     LCDBuffer[0].u16Word = 0xFFFF;
     LCDBuffer[1].u16Word = 0xFFFF;
     LCDBuffer[2].u16Word = 0xFFFF;
     LCDBuffer[3].u16Word = 0xFFFF;
     LCDBuffer[4].u16Word = 0xFFFF;
     LCDBuffer[5].u16Word = 0xFFFF;
     LCDBuffer[6].u16Word = 0xFFFF;
     LCDBuffer[7].u16Word = 0xFFFF;
     
     g16ContrastValue = CONSTRAST_LOW;
     
     for(;;)
     {
          __RESET_WATCHDOG();
          
          vfnLCDDriver();

     }
*/
     
     
     
     
     for(;;)
     {
          __RESET_WATCHDOG();                          /* feeds the dog */
          
          vfnLCDDriver();                              /* Call LCD Driver */
          
          if (!u8Test1Flag)
          {
               /**************         Run Test 1          **************/
               if((u16Delay++)>340)
               {
                    u16Delay = 0;
                    
                    if(!u8ContrastFlag)
                    {
                         g16ContrastValue++;
                         if(g16ContrastValue == 3000)
                         {
                              u8ContrastFlag = 1;
                         }
                    }
                    else
                    {
                         if(g16ContrastValue >150)
                         {
                              g16ContrastValue--;
                         }
                         else
                         {
                              u8ContrastFlag = 0;
                              LCDBuffer[0].u16Word = gau16CharactersArray[u8Index];
                              LCDBuffer[1].u16Word = gau16CharactersArray[u8Index];
                              LCDBuffer[2].u16Word = gau16CharactersArray[u8Index];
                              LCDBuffer[3].u16Word = gau16CharactersArray[u8Index];
                              LCDBuffer[4].u16Word = gau16CharactersArray[u8Index];
                              LCDBuffer[5].u16Word = gau16CharactersArray[u8Index];
                              LCDBuffer[6].u16Word = gau16CharactersArray[u8Index];
                              LCDBuffer[7].u16Word = gau16CharactersArray[u8Index];
                              u8Index++;
                              if (u8Index == 11)
                              {
                                   u8Index = 0;
                                   u8Test1Flag = 1;
                                   g16ContrastValue = CONSTRAST_LOW;
                              }
                         }
                    }
               }               
          }
          else
          {
               /**************         Run Test 2          **************/
               if(!(--u32Counter))
               {
                    u32Counter = 20000;
                    vfnLCDPrintMessage(&TestMsg[0],sizeof(TestMsg));
               }
          }
     }
}
