#ifndef __LCD_H__
     #define __LCD_H__

     /************************************************************************************************/
     /*                                      Includes Section                                        */
     /************************************************************************************************/
     #include <hidef.h> /* for EnableInterrupts macro */
     #include "derivative.h" /* include peripheral declarations */

     /************************************************************************************************/
     /*                                    Typedef Section                                           */
     /************************************************************************************************/
     typedef union
     {
          struct
          {
               unsigned char u8BackPlane2 :4;
               unsigned char u8BackPlane3 :4;
               unsigned char u8BackPlane0 :4;
               unsigned char u8BackPlane1 :4;
          }_sMergedSegments;
          
          unsigned int u16Word;
     }_uSegments;

     /************************************************************************************************/
     /*                                    Defines & Macros Section                                  */
     /************************************************************************************************/
     #define SEG_DP                          (unsigned int)(1<<0)
     #define SEG_D                           (unsigned int)(1<<1)
     #define SEG_L                           (unsigned int)(1<<2)
     #define SEG_M                           (unsigned int)(1<<3)
     #define SEG_C                           (unsigned int)(1<<4)
     #define SEG_E                           (unsigned int)(1<<5)
     #define SEG_K                           (unsigned int)(1<<6)
     #define SEG_N                           (unsigned int)(1<<7)
     #define SEG_B                           (unsigned int)(1<<8)
     #define SEG_F                           (unsigned int)(1<<9)
     #define SEG_J                           (unsigned int)(1<<10)
     #define SEG_G                           (unsigned int)(1<<11)
     #define SEG_A                           (unsigned int)(1<<12)
     #define SEG_CA                          (unsigned int)(1<<13)
     #define SEG_I                           (unsigned int)(1<<14)
     #define SEG_H                           (unsigned int)(1<<15)

     #define BLANK_DIGIT                     (0x00)
     #define FULL_DIGIT                      (0xFF)
     #define MAX_PHASE                       (5)
     #define MAX_DIGITS                      (8)
     
     #define WAVE_FORM_PERIOD                (390)          //2.5 mS
     #define CONSTRAST_HIGH                  (WAVE_FORM_PERIOD/2)
     #define CONSTRAST_MED                   (WAVE_FORM_PERIOD)
     #define CONSTRAST_LOW                   (WAVE_FORM_PERIOD*2)
     
     #define LCD_INTERRUPT_VECTOR            (9)
     #define TIMER_REGISTER                  (TPM2SC)
     #define TIM_CHANNEL_REGISTER            (TPM2C0SC)
     #define RELOAD_TIMER_VALUE              (TPM2C0V)
     #define CLEAR_TIMER_FLAG                (TPM2C0SC_CH0F = 0)

     /************************************************************************************************/
     /*                                 Hardware Configuration Section
     /************************************************************************************************/
     #define HIGH_NIBBLE                     (0xF0)
     #define LOW_NIBBLE                      (0x0F)
     
     #define LCD_DIGIT1_NIBBLE               (HIGH_NIBBLE)
     #define LCD_DIGIT1_PORT_INIT            (PTADD |= LCD_DIGIT1_NIBBLE)
     #define LCD_DIGIT1_CLEAR_PORT           (PTAD &= ~LCD_DIGIT1_NIBBLE)
     #define LCD_DIGIT1_PORT                 (PTAD)
     
     #define LCD_DIGIT2_NIBBLE               (LOW_NIBBLE)
     #define LCD_DIGIT2_PORT_INIT            (PTADD |= LCD_DIGIT2_NIBBLE)
     #define LCD_DIGIT2_CLEAR_PORT           (PTAD &= ~LCD_DIGIT2_NIBBLE)
     #define LCD_DIGIT2_PORT                 (PTAD)
     
     #define LCD_DIGIT3_NIBBLE               (HIGH_NIBBLE)
     #define LCD_DIGIT3_PORT_INIT            (PTCDD |= LCD_DIGIT3_NIBBLE)
     #define LCD_DIGIT3_CLEAR_PORT           (PTCD &= ~LCD_DIGIT3_NIBBLE)
     #define LCD_DIGIT3_PORT                 (PTCD)
     
     #define LCD_DIGIT4_NIBBLE               (LOW_NIBBLE)
     #define LCD_DIGIT4_PORT_INIT            (PTCDD |= LCD_DIGIT4_NIBBLE)
     #define LCD_DIGIT4_CLEAR_PORT           (PTCD &= ~LCD_DIGIT4_NIBBLE)
     #define LCD_DIGIT4_PORT                 (PTCD)
     
     #define LCD_DIGIT5_NIBBLE               (HIGH_NIBBLE)
     #define LCD_DIGIT5_PORT_INIT            (PTDDD |= LCD_DIGIT5_NIBBLE)
     #define LCD_DIGIT5_CLEAR_PORT           (PTDD &= ~LCD_DIGIT5_NIBBLE)
     #define LCD_DIGIT5_PORT                 (PTDD)
     
     #define LCD_DIGIT6_NIBBLE               (LOW_NIBBLE)
     #define LCD_DIGIT6_PORT_INIT            (PTDDD |= LCD_DIGIT6_NIBBLE)
     #define LCD_DIGIT6_CLEAR_PORT           (PTDD &= ~LCD_DIGIT6_NIBBLE)
     #define LCD_DIGIT6_PORT                 (PTDD)
     
     #define LCD_DIGIT7_NIBBLE               (HIGH_NIBBLE)
     #define LCD_DIGIT7_PORT_INIT            (PTFDD |= LCD_DIGIT7_NIBBLE)
     #define LCD_DIGIT7_CLEAR_PORT           (PTFD &= ~LCD_DIGIT7_NIBBLE)
     #define LCD_DIGIT7_PORT                 (PTFD)
     
     #define LCD_DIGIT8_NIBBLE               (LOW_NIBBLE)
     #define LCD_DIGIT8_PORT_INIT            (PTFDD |= LCD_DIGIT8_NIBBLE)
     #define LCD_DIGIT8_CLEAR_PORT           (PTFD &= ~LCD_DIGIT8_NIBBLE)
     #define LCD_DIGIT8_PORT                 (PTFD)

     #define BACK_PLANE0_DDR                 (PTGDD_PTGDD4)
     #define BACK_PLANE0_PIN                 (PTGD_PTGD4)
     #define BACK_PLANE1_DDR                 (PTGDD_PTGDD5)
     #define BACK_PLANE1_PIN                 (PTGD_PTGD5)
     #define BACK_PLANE2_DDR                 (PTGDD_PTGDD6)
     #define BACK_PLANE2_PIN                 (PTGD_PTGD6)
     #define BACK_PLANE3_DDR                 (PTGDD_PTGDD7)
     #define BACK_PLANE3_PIN                 (PTGD_PTGD7)

     /************************************************************************************************/
     /*                                    Extern Variables Section                                  */
     /************************************************************************************************/
     extern _uSegments LCDBuffer[MAX_DIGITS];
     extern const unsigned int gau16CharactersArray[];
     extern unsigned int g16ContrastValue;
     /************************************************************************************************/
     /*                                  Function Prototipes Section                                 */
     /************************************************************************************************/
     void vfnLCDPrintMessage(unsigned char *u8pTextSource,unsigned char u8TopDigit);
     void vfnLCDInit(void);
     void vfnLCDDriver(void);
     /************************************************************************************************/
#endif