/*
 * File:	mcf5213_pmm.h
 * Purpose:	Register and bit definitions for the MCF5213
 *
 * Notes:	
 *	
 */

#ifndef __MCF5213_PMM_H__
#define __MCF5213_PMM_H__

/*********************************************************************
*
* Power Management Module (PMM)
*
*********************************************************************/

/* Register read/write macros */
#define MCF_PMM_LPICR           (*(vuint8 *)(&__IPSBAR[0x000012]))
#define MCF_PMM_LPCR            (*(vuint8 *)(&__IPSBAR[0x110007]))

/* Bit definitions and macros for MCF_PMM_LPICR */
#define MCF_PMM_LPICR_XIPL(x)   (((x)&0x07)<<4)
#define MCF_PMM_LPICR_ENBSTOP   (0x80)

/* Bit definitions and macros for MCF_PMM_LPCR */
#define MCF_PMM_LPCR_LVDSE      (0x02)
#define MCF_PMM_LPCR_STPMD(x)   (((x)&0x03)<<3)
#define MCF_PMM_LPCR_LPMD(x)    (((x)&0x03)<<6)
#define MCF_PMM_LPCR_LPMD_STOP  (0xC0)
#define MCF_PMM_LPCR_LPMD_WAIT  (0x80)
#define MCF_PMM_LPCR_LPMD_DOZE  (0x40)
#define MCF_PMM_LPCR_LPMD_RUN   (0x00)

/********************************************************************/

#endif /* __MCF5213_PMM_H__ */
