/****************************************************************************
 * ETPU decimate function set 1                COPYRIGHT (c) Freescale 2006 *
 *  NAME: $RCSfile: etpuc_decimate_function.c,v $   All Rights Reserved     *
 * DESCRIPTION:                                                             *
 * This file builds the decimate eTPU function and exports the data         *
 * to a file for the host CPU to use.                                       *
 *==========================================================================*
 * Abbreviated History:                                                     *
 * Original Author: Geoff Emersson [r47354]                            )    *
 * $Log: etpuc_decimate_function.c,v $
 * Revision 1.1  2006/06/14 10:42:20  r47354
 * Initial revision.
 *
 ****************************************************************************/

/* Define a 6k memory map for compatibility with all versions of eTPU module*/
/* The code memory should start at 0 with the entry table at 0 and the */
/*   functions starting at 0x400. This allows for 16 functions if more */
/*   are needed then the ORG should be increased or removed to have it */
/*   assigned automatically.                                           */
#pragma memory ROM[(6 * (1024))] @ 0;
#pragma memory ORG @ 0x400;
#pragma entryaddr 0x0000;


int24 Global_Error = 0xFF;

union Link_t {
	int32 Chans;
	int8  Chan[3];
};

#define GLOBAL_ERROR_FUNC
void Global_Error_Func();

#define REGISTER_PASSING

#ifndef REGISTER_PASSING
void Link4( union Link_t Link  );
#else
void Link4( );
#endif

register_p7_0 p7_0;
register_p15_8 p15_8;
register_p23_16 p23_16;
register_p31_24 p31_24;

/*************************/
/* Include the function  */
/*************************/

/* decimate function */
#define DECIMATE_FUNCTION_NUMBER 0xD
#include "etpuc_decimate.c"

void Global_Error_Func()
{
	ertb = chan;

	if (LinkServiceRequest == 1) ertb+=0x0100;

	if (MatchALatch == 1)  ertb+=0x0200;

	if (MatchBLatch == 1)  ertb+=0x0400;

	if (TransitionALatch == 1)  ertb+=0x0800;

	if (TransitionBLatch == 1)  ertb+=0x1000;

	Global_Error = ertb;

	ClearAllLatches();
}

/* output eTPU code image and information for CPU */
#pragma write h, (::ETPUfilename (etpu_decimate_function.h));
#pragma write h, (/****************************************************************);
#pragma write h, ( * WARNING this file is automatically generated DO NOT EDIT IT! *);
#pragma write h, ( *                                                              *);
#pragma write h, ( * FILE : etpu_decimate_function.h COPYRIGHT (c) Freescale 2006 *);
#pragma write h, ( *                                      All Rights Reserved     *);
#pragma write h, ( * This file generated by:                                      *);
#pragma write h, ( * $RCSfile: etpuc_decimate_function.c,v $ $Revision: 1.1 $);
#pragma write h, ( *                                                              *);
#pragma write h, ( ****************************************************************/);
#pragma write h, (#ifndef _ETPU_DECIMATE_FUNCTION_H_ );
#pragma write h, (#define _ETPU_DECIMATE_FUNCTION_H_ );
#pragma write h, ( );
#pragma write h, (/* eTPU decimate fucntion */ );
#pragma write h, (#define FS_ETPU_ENTRY_TABLE 0x0000);
#pragma write h, ( );
#pragma write h, (#define FS_ETPU_MISC ::ETPUmisc);
#pragma write h, ( );
#pragma write h, (const uint32_t etpu_globals[] = { ::ETPUglobalimage }; );
#pragma write h, ();
#pragma write h, (const uint32_t etpu_code[] = { ::ETPUcode32 }; );
#pragma write h, (/* List of functions: );
#pragma write h, (::ETPUnames);
#pragma write h, (*/);
#pragma write h, ( );
#pragma write h, (#endif /* _ETPU_DECIMATE_FUNCTION_H_ */ );
#pragma write h, ( );


/*********************************************************************
 *
 * Copyright:
 *	Freescale Semiconductor, INC. All Rights Reserved.
 *  You are hereby granted a copyright license to use, modify, and
 *  distribute the SOFTWARE so long as this entire notice is
 *  retained without alteration in any modified and/or redistributed
 *  versions, and that such modified versions are clearly identified
 *  as such. No licenses are granted by implication, estoppel or
 *  otherwise under any patents or trademarks of Freescale
 *  Semiconductor, Inc. This software is provided on an "AS IS"
 *  basis and without warranty.
 *
 *  To the maximum extent permitted by applicable law, Freescale
 *  Semiconductor DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED,
 *  INCLUDING IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A
 *  PARTICULAR PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH
 *  REGARD TO THE SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF)
 *  AND ANY ACCOMPANYING WRITTEN MATERIALS.
 *
 *  To the maximum extent permitted by applicable law, IN NO EVENT
 *  SHALL Freescale Semiconductor BE LIABLE FOR ANY DAMAGES WHATSOEVER
 *  (INCLUDING WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS,
 *  BUSINESS INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER
 *  PECUNIARY LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.
 *
 *  Freescale Semiconductor assumes no responsibility for the
 *  maintenance and support of this software
 *
 ********************************************************************/