/**************************************************************************
 * FILE NAME: $RCSfile: eqadc_init.c,v $      COPYRIGHT (c) FREESCALE 2006 *
 * DESCRIPTION:                                     All Rights Reserved   *
 * This file contains initialisation routines for the eQADC.              *
 *========================================================================*
 * ORIGINAL AUTHOR: Geoff Emerson (r47354)                                *
 * $Log: eqadc_init.c,v $
 * Revision 1.1  2006/06/14 10:45:32  r47354
 * Initial revision.
 *
 *........................................................................*
 **************************************************************************/


#include "mpc5534.h"
#include "decimator_project.h"

void create_ADC_config()
{
   /* Configuration Command words */
   Cqueue_Adc_Config[0] = 0x02000602;  /* ADC0 ADC_TSCR Time stamp control */
   Cqueue_Adc_Config[1] = 0x02000003;  /* ADC0 ADC_TBCR Time base counter 0x0000=reset */
   Cqueue_Adc_Config[2] = 0x02800401;  /* ADC0 ADC_CR Control register */
   Cqueue_Adc_Config[3] = 0x00000602;  /* ADC1 ADC_TSCR Time stamp control */
   Cqueue_Adc_Config[4] = 0x00000003;  /* ADC1 ADC_TBCR Time base counter 0x0000=reset */
   Cqueue_Adc_Config[5] = 0x80800401;  /* ADC1 ADC_CR Control register */
}

/* 0x28 VRH */
/* 0x2B 75% VRH */
/* 0x2A 50% VRH */
/* 0x2C 25% VRH */
/* 0x29 VRL */

/* Bit 0 - EOQ
   Bit 1 - Pause
   Bits 2-4 - Reserved
   Bit 5 - EB (0b0)
   Bit 6 - BN Buffer Number
   Bit 7 - CAL Calibration
   Bits 8-11 Message Tag (RFIFO number)
   Bits 12-13 LST Sample Time
   Bit 14 TSR Timestamp enable
   Bit 15 FMT Data Format
   Bits 16-23 Channel to convert
   Bits 24-31 Reserved (all zero)
*/ 


// ********************* Initilization Function *********************
void eqadc_init_fcn(void)
{

   create_ADC_config();

   /* EQADC Module Configuration Register (EQADC_MCR) */                               
   EQADC.MCR.R   = 0x00000000;   /* EQADC SSI is Disabled                     
                                    Debug Mode Disabled */                     

   /* EQADC NULL Message Send Format Register (EQADC_NMSFR) */                
   EQADC.NMSFR.R = 0x0000000;   /* Null Message Format */             

   /* EQADC External Trigger Digital Filter Register (EQADC_ETDFR)*/ 
  EQADC.ETDFR.R  = 0x00000000; /* Digital Filter Length = 2*(sys clock period) */   

/* Use Queue 0 to initialise ADC registers */

   /* EQADC CFIFO Control Register 0 (EQADC_CFCR0)  CFIFO-0 */                 
   EQADC.CFCR[0].B.MODE = SW_TRIG_SS;         // Trigger - Software Triggered 

   /* EQADC Interrupt and DMA Control Registers (EQADC_IDCR) IDCR0 */          
   EQADC.IDCR[0].R = 0x0300;      /* NonCoherency Interrupt is : Disabled (0)
                                     Trigger Overrun Interrupt is :Disabled (0)
                                     Pause Interrupt is : Disabled (0)
                                     End Of Queue Interrupt is : Disabled (0)
                                     CFIFO Underflow Interrupt is : Disabled (0)
                                     CFIFO Fill Enable is : Enabled (1)
                                     CFIFO Fill Select : Enabled (1)
                                     RFIFO Overflow Interrupt is : Disabled (0)
                                     RFIFO Drain is : Disabled (0)
                                     RFIFO Drain Select is : Disabled (0) */

   EQADC.CFCR[0].B.SSE = 0x1;    /* Single Scan Enable Bit - 1  */
    
   while(EQADC.CFSR.B.CFS0 != WAIT){};  /* Wait for queue to go to IDLE before setting mode to user setting. */

   /* EQADC CFIFO Control Register 0 (EQADC_CFCR0)  CFIFO-0 */               
   EQADC.CFCR[0].B.MODE = DISABLE_Q;         /* Disable Triggers */
   EQADC.IDCR[0].R = 0x0000;
   EQADC.FISR[0].B.EOQF = 0x1;
   EQADC.CFCR[0].B.CFINV = 1;
   
   SIU.ETISR.R = 0x00200000; /* emios10 drives the trigger */


}

/*********************************************************************
 *
 * Copyright:
 *	Freescale Semiconductor, INC. All Rights Reserved.
 *  You are hereby granted a copyright license to use, modify, and
 *  distribute the SOFTWARE so long as this entire notice is
 *  retained without alteration in any modified and/or redistributed
 *  versions, and that such modified versions are clearly identified
 *  as such. No licenses are granted by implication, estoppel or
 *  otherwise under any patents or trademarks of Freescale
 *  Semiconductor, Inc. This software is provided on an "AS IS"
 *  basis and without warranty.
 *
 *  To the maximum extent permitted by applicable law, Freescale
 *  Semiconductor DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED,
 *  INCLUDING IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A
 *  PARTICULAR PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH
 *  REGARD TO THE SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF)
 *  AND ANY ACCOMPANYING WRITTEN MATERIALS.
 *
 *  To the maximum extent permitted by applicable law, IN NO EVENT
 *  SHALL Freescale Semiconductor BE LIABLE FOR ANY DAMAGES WHATSOEVER
 *  (INCLUDING WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS,
 *  BUSINESS INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER
 *  PECUNIARY LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.
 *
 *  Freescale Semiconductor assumes no responsibility for the
 *  maintenance and support of this software
 ********************************************************************/


