/**************************************************************************
 * FILE NAME: $RCSfile: dma_init_for_eqadc_config.c,v $      COPYRIGHT (c) FREESCALE 2006 *
 * DESCRIPTION:                                     All Rights Reserved   *
 * This file contains the dma_int_for_eqadc_config function.              *
 *========================================================================*
 * ORIGINAL AUTHOR: Geoff Emerson (r47354)                                *
 * $Log: dma_init_for_eqadc_config.c,v $
 * Revision 1.1  2006/06/14 10:45:32  r47354
 * Initial revision.
 *
 *........................................................................*
 **************************************************************************/

#include "mpc5534.h"

/* ********************* Initilization Function *********************/
void dma_init_for_eqadc_config(void)
{
/* DMA Configuration Register (DMACR) */                    
     EDMA.CR.R   = 0x0000E401;  /* Group Arbitration scheme is : Fixed Priority 
                                   Channel Arbitration Scheem is : Fixed Priority 
                                   Group 3 Priority (GRP3PRI) is : 4
                                   Group 2 Priority (GRP2PRI) is : 3
                                   Group 1 Priority (GRP1PRI) is : 2
                                   Group 0 Priority (GRP0PRI) is : 1
                                   Debug is : Disabled (0)
                                   Buffered Writes are :  Enabled (1) */

/* DMA Enable Request Registers (DMAERQH,DMAERQL) */                     
     EDMA.ERQRL.R   = 0x00000001;  /* DMA Enable Request Register Low (Channels 31-0) */ 

/* DMA Enable Error Interrupt Request Registers (DMAEEIH,DMAEEIL) */                     
     EDMA.EEIRL.R   = 0x00000000;  /* DMA Error Interrupt Enable Register Low (Channels 0-31) */


/* DMA Channel Priority Register Settings (DCHPRIn) Channels 0 - 63 */                    
          EDMA.CPR[0].R = 0x00;    /* Channel 0 is Priority 1, Channel Preemption is Disabled   */ 
          EDMA.CPR[1].R = 0x01;    /* Channel 1 is Priority 2, Channel Preemption is Disabled   */ 
          EDMA.CPR[2].R = 0x02;    /* Channel 2 is Priority 3, Channel Preemption is Disabled   */ 
          EDMA.CPR[3].R = 0x03;    /* Channel 3 is Priority 4, Channel Preemption is Disabled   */ 
          EDMA.CPR[4].R = 0x04;    /* Channel 4 is Priority 5, Channel Preemption is Disabled   */ 
          EDMA.CPR[5].R = 0x05;    /* Channel 5 is Priority 6, Channel Preemption is Disabled   */ 
          EDMA.CPR[6].R = 0x06;    /* Channel 6 is Priority 7, Channel Preemption is Disabled   */ 
          EDMA.CPR[7].R = 0x07;    /* Channel 7 is Priority 8, Channel Preemption is Disabled   */ 
          EDMA.CPR[8].R = 0x08;    /* Channel 8 is Priority 9, Channel Preemption is Disabled   */ 
          EDMA.CPR[9].R = 0x09;    /* Channel 9 is Priority 10, Channel Preemption is Disabled  */
          EDMA.CPR[10].R = 0x0A;   /* Channel 10 is Priority 11, Channel Preemption is Disabled */
          EDMA.CPR[11].R = 0x0B;   /* Channel 11 is Priority 12, Channel Preemption is Disabled */
          EDMA.CPR[12].R = 0x0C;   /* Channel 12 is Priority 13, Channel Preemption is Disabled */
          EDMA.CPR[13].R = 0x0D;   /* Channel 13 is Priority 14, Channel Preemption is Disabled */
          EDMA.CPR[14].R = 0x0E;   /* Channel 14 is Priority 15, Channel Preemption is Disabled */
          EDMA.CPR[15].R = 0x0F;   /* Channel 15 is Priority 16, Channel Preemption is Disabled */
          EDMA.CPR[16].R = 0x00;   /* Channel 16 is Priority 1, Channel Preemption is Disabled  */
          EDMA.CPR[17].R = 0x01;   /* Channel 17 is Priority 2, Channel Preemption is Disabled  */
          EDMA.CPR[18].R = 0x02;   /* Channel 18 is Priority 3, Channel Preemption is Disabled  */
          EDMA.CPR[19].R = 0x03;   /* Channel 19 is Priority 4, Channel Preemption is Disabled  */
          EDMA.CPR[20].R = 0x04;   /* Channel 20 is Priority 5, Channel Preemption is Disabled  */
          EDMA.CPR[21].R = 0x05;   /* Channel 21 is Priority 6, Channel Preemption is Disabled  */
          EDMA.CPR[22].R = 0x06;   /* Channel 22 is Priority 7, Channel Preemption is Disabled  */
          EDMA.CPR[23].R = 0x07;   /* Channel 23 is Priority 8, Channel Preemption is Disabled  */
          EDMA.CPR[24].R = 0x08;   /* Channel 24 is Priority 9, Channel Preemption is Disabled  */
          EDMA.CPR[25].R = 0x09;   /* Channel 25 is Priority 10, Channel Preemption is Disabled */
          EDMA.CPR[26].R = 0x0A;   /* Channel 26 is Priority 11, Channel Preemption is Disabled */
          EDMA.CPR[27].R = 0x0B;   /* Channel 27 is Priority 12, Channel Preemption is Disabled */
          EDMA.CPR[28].R = 0x0C;   /* Channel 28 is Priority 13, Channel Preemption is Disabled */
          EDMA.CPR[29].R = 0x0C;   /* Channel 29 is Priority 13, Channel Preemption is Disabled */
          EDMA.CPR[30].R = 0x0E;   /* Channel 30 is Priority 15, Channel Preemption is Disabled */
          EDMA.CPR[31].R = 0x0F;   /* Channel 31 is Priority 16, Channel Preemption is Disabled */

}
/*********************************************************************
 *
 * Copyright:
 *  FREESCALE, INC. All Rights Reserved.
 *  You are hereby granted a copyright license to use, modify, and
 *  distribute the SOFTWARE so long as this entire notice is
 *  retained without alteration in any modified and/or redistributed
 *  versions, and that such modified versions are clearly identified
 *  as such. No licenses are granted by implication, estoppel or
 *  otherwise under any patents or trademarks of Motorola, Inc. This
 *  software is provided on an "AS IS" basis and without warranty.
 *
 *  To the maximum extent permitted by applicable law, FREESCALE
 *  DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED, INCLUDING
 *  IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR
 *  PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH REGARD TO THE
 *  SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF) AND ANY
 *  ACCOMPANYING WRITTEN MATERIALS.
 *
 *  To the maximum extent permitted by applicable law, IN NO EVENT
 *  SHALL FREESCALE BE LIABLE FOR ANY DAMAGES WHATSOEVER (INCLUDING
 *  WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS, BUSINESS
 *  INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER PECUNIARY
 *  LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.
 *
 *  Freescale assumes no responsibility for the maintenance and support
 *  of this software
 ********************************************************************/
