/**************************************************************************
 * FILE NAME: $RCSfile: decimator_project.h,v $      COPYRIGHT (c) FREESCALE 2006 *
 * DESCRIPTION:                                     All Rights Reserved   *
 * This file contains definitions for the example Decimator project.      *
 *========================================================================*
 * ORIGINAL AUTHOR: Geoff Emerson (r47354)                                *
 * $Log: decimator_project.h,v $
 * Revision 1.1  2006/06/14 10:45:32  r47354
 * Initial revision.
 *
 *........................................................................*
 **************************************************************************/
#include "mpc5534.h"
#include "etpu_util.h"
#include "etpu_decimate.h"           /* eTPU decimate API */

#define DECIMATION_AMOUNT 4
#define DECIMATOR_CHANNEL 1

#define CQUEUE_SIZE 64
#define PING_PONG_LENGTH 256
vuint32_t Cqueue0[CQUEUE_SIZE];    /* CFIFO 0 Queue Variable declaration */
vuint16_t Rqueue0[DECIMATION_AMOUNT*2];  /* RFIFO 0 Queue Variable declaration */
vuint16_t Decimator_Ping_Pong[PING_PONG_LENGTH];    
vuint32_t Cqueue_Adc_Config[6];    /* CFIFO 0 Queue Variable declaration  */

/* CFIFO Status Constants */
#define IDLE 0              
#define WAIT 2              
#define TRIGD 3              
              
/* CFIFO Trigger Mode Constants */
#define DISABLE_Q 0x0              
#define SW_TRIG_SS 0x1              
#define LOW_GATED_EXT_SS 0x2              
#define HIGH_GATED_EXT_SS 0x3              
#define FALLING_EXT_SS 0x4              
#define RISING_EXT_SS 0x5              
#define FALL_OR_RISE_EXT_SS 0x6              
#define SW_TRIG_CS 0x9              
#define LOW_GATED_EXT_CS 0xA              
#define HIGH_GATED_EXT_CS 0xB              
#define FALLING_EXT_CS 0xC              
#define RISING_EXT_CS 0xD              
#define FALL_OR_RISE_EXT_CS 0xE               
              





/************************************ TCD_P1 Initial Values *********************************/
#define SADDR_INIT_P1  RFIFO0_POP          /* Source Address */             
#define SMOD_INIT_P1   0x0                 /* Source Modulo: OFF */                             
#define SSIZE_INIT_P1  0x1                 /* Source Size = 0x1 -> 16-bit transfers */            
#define DMOD_INIT_P1  0x0                  /* Destination Modulo, feature disabled */             
#define DSIZE_INIT_P1  0x1                 /* Destination Size = 0x1 -> 16-bit transfers */       
#define SOFF_INIT_P1  0x0                  /* Source address offset = 0x0 */                      
#define NBYTES_INIT_P1  0x2                /* inner (minor) byte count */                       
#define SLAST_INIT_P1  0                   /* Restore Source address by 0 */                      
#define DADDR_INIT_P1  0                   /* Destination Address : Dummy value. 
                                              Populated at runtime */      
#define CITERE_LINK_INIT_P1  0             /* Minor loop Channel linking is disabled */           
#define CITER_INIT_P1 DECIMATION_AMOUNT*2  /* Current Iteration Count -> 4x "NBYTES" xfer */      
#define DOFF_INIT_P1  0x2                  /* Destination address offset = 0x4 */                 
#define DLAST_SGA_INIT_P1  0               /* dummy value to be populated at run 
                                              time - address of TCD isn't known
                                              at compile time; order of decl. */    
#define BITERE_LINK_INIT_P1  0             /* Major loop channel linking disabled */              
#define BITER_INIT_P1  DECIMATION_AMOUNT*2 /* Beginning Iteration Count = c = CITER */            
#define BWC_INIT_P1  0x0                   /* Bandwidth control = 0 -> No eDMA stalls */          
#define MAJORLINKCH_INIT_P1  0             /* No linked channel */                                
#define DONE_INIT_P1  0                    /* Major loop complete interrupt: OFF */               
#define ACTIVE_INIT_P1  0                  /* Major loop done flag */                             
#define MAJORE_LINK_INIT_P1  0             /* Major loop channel linking disabled */              
#define E_SG_INIT_P1  1                    /* Enable Scatter Gather */                           
#define D_REQ_INIT_P1  0                   /* Disable hardware request off */                     
#define INT_HALF_INIT_P1  0                /* Half loop complete interrupt: off */                
#define INT_MAJ_INIT_P1  0                 /* Major loop complete interrupt: ON */                
#define START_INIT_P1  0                   /* No software start this write */                     
                                                                                                  
/************************************ TCD_Q1 Initial Values *********************************/
#define SADDR_INIT_Q1  0                   /* Source Address - dummy value to be 
                                              populated at run time (as it is in
                                              an as yet unknown PRAM location */             
#define SMOD_INIT_Q1   0x0                 /* Source Modulo: OFF */                             
#define SSIZE_INIT_Q1  0x1                 /* Source Size = 0x1 -> 16-bit transfers */            
#define DMOD_INIT_Q1  0x0                  /* Destination Modulo, feature disabled */             
#define DSIZE_INIT_Q1  0x1                 /* Destination Size = 0x1 -> 16-bit transfers */       
#define SOFF_INIT_Q1  0x0                  /* Source address offset = 0x0 */                      
#define NBYTES_INIT_Q1  0x2                /* inner (minor) byte count */                       
#define SLAST_INIT_Q1  0                   /* Restore Source address by 0 */                      
#define DADDR_INIT_Q1  (vuint32_t) &Decimator_Ping_Pong /* Destination Address SRAM */      
#define CITERE_LINK_INIT_Q1  0             /* Minor loop Channel linking is disabled */           
#define CITER_INIT_Q1  0x1                 /* Current Iteration Count -> 4x "NBYTES" xfer */      
#define DOFF_INIT_Q1  0x2                  /* Destination address offset = 0x2 */                 
#define DLAST_SGA_INIT_Q1  0               /* dummy value to be populated at run time  */    
#define BITERE_LINK_INIT_Q1  0             /* Major loop channel linking disabled */              
#define BITER_INIT_Q1  0x1                 /* Beginning Iteration Count = c = CITER */            
#define BWC_INIT_Q1  0x0                   /* Bandwidth control = 0 -> No eDMA stalls */          
#define MAJORLINKCH_INIT_Q1  0             /* No linked channel */                                
#define DONE_INIT_Q1  0                    /* Major loop complete interrupt: OFF */               
#define ACTIVE_INIT_Q1  0                  /* Major loop done flag */                             
#define MAJORE_LINK_INIT_Q1  0             /* Major loop channel linking disabled */              
#define E_SG_INIT_Q1  1                    /* Enable Scatter Gather */                           
#define D_REQ_INIT_Q1  0                   /* Disable hardware request off */                     
#define INT_HALF_INIT_Q1  0                /* Half loop complete interrupt: off */                
#define INT_MAJ_INIT_Q1  0                 /* Major loop complete interrupt: 0ff */                
#define START_INIT_Q1  1                   /* software start this write */                     
                                                                                                  
/************************************ TCD_S1 Initial Values *********************************/
#define SADDR_INIT_S1  0                   /* Source Address - dummy value to be 
                                              populated at run time */             
#define SMOD_INIT_S1   0x0                 /* Source Modulo: OFF */                             
#define SSIZE_INIT_S1  0x2                 /* Source Size = 0x2 -> 32-bit transfers */            
#define DMOD_INIT_S1  0x0                  /* Destination Modulo, feature disabled */             
#define DSIZE_INIT_S1  0x2                 /* Destination Size = 0x2 -> 32-bit transfers */       
#define SOFF_INIT_S1  0x0                  /* Source address offset = 0x0 */                      
#define NBYTES_INIT_S1  0x4                /* inner (minor) byte count */                       
#define SLAST_INIT_S1  0                   /* Restore Source address by 0 */                      
#define DADDR_INIT_S1  (vuint32_t) &ETPU.CHAN[DECIMATOR_CHANNEL].HSRR.R /* Destination Address */      
#define CITERE_LINK_INIT_S1  0             /* Minor loop Channel linking is disabled */           
#define CITER_INIT_S1  0x1                 /* Current Iteration Count -> 4x "NBYTES" xfer */      
#define DOFF_INIT_S1  0x4                  /* Destination address offset = 0x4 */                 
#define DLAST_SGA_INIT_S1  (vuint32_t) &TCD_P1  /* Next TCD address  */    
#define BITERE_LINK_INIT_S1  0             /* Major loop channel linking disabled */              
#define BITER_INIT_S1  0x1                 /* Beginning Iteration Count = c = CITER */            
#define BWC_INIT_S1  0x0                   /* Bandwidth control = 0 -> No eDMA stalls */          
#define MAJORLINKCH_INIT_S1  0             /* No linked channel */                                
#define DONE_INIT_S1  0                    /* Major loop complete interrupt: OFF */               
#define ACTIVE_INIT_S1  0                  /* Major loop done flag */                             
#define MAJORE_LINK_INIT_S1  0             /* Major loop channel linking disabled */              
#define E_SG_INIT_S1  1                    /* Enable Scatter Gather */                           
#define D_REQ_INIT_S1  0                   /* Disable hardware request off */                     
#define INT_HALF_INIT_S1  0                /* Half loop complete interrupt: off */                
#define INT_MAJ_INIT_S1  0                 /* Major loop complete interrupt: 0ff */                
#define START_INIT_S1  1                   /* software start this write */                     

/************************************ TCD_R1 Initial Values *********************************/
#define SADDR_INIT_R1  0                   /* Source Address - dummy value to be]
                                              populated at run time (as it is in an
                                               as yet unknown PRAM location */             
#define SMOD_INIT_R1   0x0                 /* Source Modulo: OFF */                             
#define SSIZE_INIT_R1  0x2                 /* Source Size = 0x2 -> 32-bit transfers */            
#define DMOD_INIT_R1  0x0                  /* Destination Modulo, feature disabled */             
#define DSIZE_INIT_R1  0x2                 /* Destination Size = 0x2 -> 32-bit transfers */       
#define SOFF_INIT_R1  0x4                  /* Source address offset = 0x0 */                      
#define NBYTES_INIT_R1  4                  /* inner (minor) byte count */                       
#define SLAST_INIT_R1  0                   /* Restore Source address by 0 */                      
#define DADDR_INIT_R1 (vuint32_t) &TCD_Q1 + 16  /* Destination Address */      
#define CITERE_LINK_INIT_R1  0             /* Minor loop Channel linking is disabled */           
#define CITER_INIT_R1  0x1                 /* Current Iteration Count -> 4x "NBYTES" xfer */      
#define DOFF_INIT_R1  4                    /* Destination address offset = 0x4 */                 
#define DLAST_SGA_INIT_R1 (vuint32_t) &TCD_S1   /* Next TCD address  */    
#define BITERE_LINK_INIT_R1  0             /* Major loop channel linking disabled */              
#define BITER_INIT_R1  0x1                 /* Beginning Iteration Count = c = CITER */            
#define BWC_INIT_R1  0x0                   /* Bandwidth control = 0 -> No eDMA stalls */          
#define MAJORLINKCH_INIT_R1  0             /* No linked channel */                                
#define DONE_INIT_R1  0                    /* Major loop complete interrupt: OFF */               
#define ACTIVE_INIT_R1  0                  /* Major loop done flag */                             
#define MAJORE_LINK_INIT_R1  0             /* Major loop channel linking disabled */              
#define E_SG_INIT_R1  1                    /* Enable Scatter Gather */                           
#define D_REQ_INIT_R1  0                   /* Disable hardware request off */                     
#define INT_HALF_INIT_R1  0                /* Half loop complete interrupt: off */                
#define INT_MAJ_INIT_R1  0                 /* Major loop complete interrupt: 0ff */                
#define START_INIT_R1  1                   /* software start this write */                     
                                                                                                  
/************************************ TCD_ADC_CQ_CONFIG Initial Values *********************************/
#define SADDR_ADC_CQ_CONFIG (vuint32_t) &Cqueue_Adc_Config  /* Source Address */    
#define SMOD_ADC_CQ_CONFIG 0x0             /* Source Modulo: OFF */                                
#define SSIZE_ADC_CQ_CONFIG 0x2            /* Source Size = 0x2 -> 32-bit transfers */              
#define DMOD_ADC_CQ_CONFIG 0x0             /* Source Modulo, feature disabled */                    
#define DSIZE_ADC_CQ_CONFIG 0x2            /* Destination Size = 0x2 -> 32-bit transfers */         
#define SOFF_ADC_CQ_CONFIG 0x4             /* Source address offset = 0x4 */                        
#define NBYTES_ADC_CQ_CONFIG 0x4           /* inner (minor) byte count */                         
#define SLAST_ADC_CQ_CONFIG -4 * 6         /* Restore Source address by -18 */                    
#define DADDR_ADC_CQ_CONFIG CFIFO0_PUSH    /* Destination Address = 0x40002000, Int SRAM */        
#define CITERE_LINK_ADC_CQ_CONFIG 0        /* Minor loop Channel linking is disabled */             
#define CITER_ADC_CQ_CONFIG 6              /* Current Iteration Count -> 4x "NBYTES" xfer */        
#define DOFF_ADC_CQ_CONFIG 0x0             /* Destination address offset = 0x4 */                   
#define DLAST_SGA_ADC_CQ_CONFIG 0          /* Do not adjust DADDR upon channel completion */        
#define BITERE_LINK_ADC_CQ_CONFIG 0        /* Major loop channel linking disabled */                
#define BITER_ADC_CQ_CONFIG 6              /* Beginning Iteration Count = 4 = CITER */              
#define BWC_ADC_CQ_CONFIG 0x0              /* Bandwidth control = 0 -> No eDMA stalls */            
#define MAJORLINKCH_ADC_CQ_CONFIG 0        /* No linked channel */                                  
#define DONE_ADC_CQ_CONFIG 0               /* Major loop complete interrupt: OFF */                 
#define ACTIVE_ADC_CQ_CONFIG 0             /* Major loop done flag */                               
#define MAJORE_LINK_ADC_CQ_CONFIG 0        /* Major loop channel linking disabled */                
#define E_SG_ADC_CQ_CONFIG 0               /* Disable Scatter Gather */                             
#define D_REQ_ADC_CQ_CONFIG 0              /* Disable hardware request off */                       
#define INT_HALF_ADC_CQ_CONFIG 0           /* Half loop complete interrupt: off */                  
#define INT_MAJ_ADC_CQ_CONFIG 0            /* Major loop complete interrupt: OFF */                 
#define START_ADC_CQ_CONFIG 0              /* No software start this write */                       

/************************************ TCD_ADC_CQ Initial Values *********************************/
#define SADDR_ADC_CQ (vuint32_t) &Cqueue0          /* Source Address */    
#define SMOD_ADC_CQ 0x0                  /* Source Modulo: OFF */                                
#define SSIZE_ADC_CQ 0x2                 /* Source Size = 0x2 -> 32-bit transfers */              
#define DMOD_ADC_CQ 0x0                  /* Source Modulo, feature disabled */                    
#define DSIZE_ADC_CQ 0x2                 /* Destination Size = 0x2 -> 32-bit transfers */         
#define SOFF_ADC_CQ 0x4                  /* Source address offset = 0x4 */                        
#define NBYTES_ADC_CQ 0x4                /* inner (minor) byte count */                         
#define SLAST_ADC_CQ -4 * CQUEUE_SIZE    /* Restore Source address by -18 */                    
#define DADDR_ADC_CQ CFIFO0_PUSH         /* Destination Address = 0x40002000, Int SRAM */        
#define CITERE_LINK_ADC_CQ 0             /* Minor loop Channel linking is disabled */             
#define CITER_ADC_CQ CQUEUE_SIZE         /* Current Iteration Count -> 4x "NBYTES" xfer */        
#define DOFF_ADC_CQ 0x0                  /* Destination address offset = 0x4 */                   
#define DLAST_SGA_ADC_CQ 0               /* Do not adjust DADDR upon channel completion */        
#define BITERE_LINK_ADC_CQ 0             /* Major loop channel linking disabled */                
#define BITER_ADC_CQ CQUEUE_SIZE         /* Beginning Iteration Count = 4 = CITER */              
#define BWC_ADC_CQ 0x0                   /* Bandwidth control = 0 -> No eDMA stalls */            
#define MAJORLINKCH_ADC_CQ 0             /* No linked channel */                                  
#define DONE_ADC_CQ 0                    /* Major loop complete interrupt: OFF */                 
#define ACTIVE_ADC_CQ 0                  /* Major loop done flag */                               
#define MAJORE_LINK_ADC_CQ 0             /* Major loop channel linking disabled */                
#define E_SG_ADC_CQ 0                    /* Disable Scatter Gather */                             
#define D_REQ_ADC_CQ 0                   /* Disable hardware request off */                       
#define INT_HALF_ADC_CQ 0                /* Half loop complete interrupt: off */                  
#define INT_MAJ_ADC_CQ 0                 /* Major loop complete interrupt: OFF */                 
#define START_ADC_CQ 0                   /* No software start this write */                       
                                                                                                  
#define CFIFO0_PUSH  0xFFF80010
#define RFIFO0_POP   0xFFF80032

#ifdef _MAIN_
#include "mpc5534_vars.h"
#include "etpu_decimate_function.h"          /* eTPU decimate function */

struct etpu_config_t my_etpu_config = {
	FS_ETPU_MISC_DISABLE,	/*MCR register*/

	FS_ETPU_MISC,			/*MISC value from eTPU compiler link file*/

	/*Configure eTPU engine A*/
	FS_ETPU_FILTER_CLOCK_DIV2 +
	FS_ETPU_CHAN_FILTER_2SAMPLE +
	FS_ETPU_ENTRY_TABLE,

	/*Configure eTPU engine A timebases*/
	FS_ETPU_TCR2CTL_DIV8 +
	( 0 << 16) +     /*TCR2 prescaler of 1 (0+1)*/
	FS_ETPU_TCR1CTL_DIV2 +
	0,               /*TCR1 prescaler of 1 (0+1)*/
	0,

	/*Configure eTPU engine B*/
	FS_ETPU_FILTER_CLOCK_DIV2 +
  FS_ETPU_CHAN_FILTER_2SAMPLE +
	FS_ETPU_ENTRY_TABLE,

	/*Configure eTPU engine B timebases*/
	FS_ETPU_TCR2CTL_DIV8 +
	( 0 << 16) +     /*TCR2 prescaler of 1 (0+1)*/
	FS_ETPU_TCR1CTL_DIV2 +
	0,               /*TCR1 prescaler of 1 (0+1)*/
	0
	};
/************************************** TCD Structures ************************/ 
 struct TCD_Init_Struct TCD_P1 = {SADDR_INIT_P1 
                         ,SMOD_INIT_P1 
                         ,SSIZE_INIT_P1 
                         ,DMOD_INIT_P1
                         ,DSIZE_INIT_P1 
                         ,SOFF_INIT_P1 
                         ,NBYTES_INIT_P1
                         ,SLAST_INIT_P1
                         ,DADDR_INIT_P1
                         ,CITERE_LINK_INIT_P1
                         ,CITER_INIT_P1
                         ,DOFF_INIT_P1
                         ,DLAST_SGA_INIT_P1
                         ,BITERE_LINK_INIT_P1
                         ,BITER_INIT_P1
                         ,BWC_INIT_P1 
                         ,MAJORLINKCH_INIT_P1
                         ,DONE_INIT_P1
                         ,ACTIVE_INIT_P1
                         ,MAJORE_LINK_INIT_P1
                         ,E_SG_INIT_P1
                         ,D_REQ_INIT_P1
                         ,INT_HALF_INIT_P1
                         ,INT_MAJ_INIT_P1
                         ,START_INIT_P1
                         };
                         
 struct TCD_Init_Struct TCD_Q1 = {SADDR_INIT_Q1 
                         ,SMOD_INIT_Q1 
                         ,SSIZE_INIT_Q1 
                         ,DMOD_INIT_Q1
                         ,DSIZE_INIT_Q1 
                         ,SOFF_INIT_Q1 
                         ,NBYTES_INIT_Q1
                         ,SLAST_INIT_Q1
                         ,DADDR_INIT_Q1
                         ,CITERE_LINK_INIT_Q1
                         ,CITER_INIT_Q1
                         ,DOFF_INIT_Q1
                         ,DLAST_SGA_INIT_Q1
                         ,BITERE_LINK_INIT_Q1
                         ,BITER_INIT_Q1
                         ,BWC_INIT_Q1 
                         ,MAJORLINKCH_INIT_Q1
                         ,DONE_INIT_Q1
                         ,ACTIVE_INIT_Q1
                         ,MAJORE_LINK_INIT_Q1
                         ,E_SG_INIT_Q1
                         ,D_REQ_INIT_Q1
                         ,INT_HALF_INIT_Q1
                         ,INT_MAJ_INIT_Q1
                         ,START_INIT_Q1
                         };
                         
 struct TCD_Init_Struct TCD_S1 = {SADDR_INIT_S1 
                         ,SMOD_INIT_S1 
                         ,SSIZE_INIT_S1 
                         ,DMOD_INIT_S1
                         ,DSIZE_INIT_S1 
                         ,SOFF_INIT_S1 
                         ,NBYTES_INIT_S1
                         ,SLAST_INIT_S1
                         ,DADDR_INIT_S1
                         ,CITERE_LINK_INIT_S1
                         ,CITER_INIT_S1
                         ,DOFF_INIT_S1
                         ,DLAST_SGA_INIT_S1
                         ,BITERE_LINK_INIT_S1
                         ,BITER_INIT_S1
                         ,BWC_INIT_S1 
                         ,MAJORLINKCH_INIT_S1
                         ,DONE_INIT_S1
                         ,ACTIVE_INIT_S1
                         ,MAJORE_LINK_INIT_S1
                         ,E_SG_INIT_S1
                         ,D_REQ_INIT_S1
                         ,INT_HALF_INIT_S1
                         ,INT_MAJ_INIT_S1
                         ,START_INIT_S1
                         };

 struct TCD_Init_Struct TCD_R1 = {SADDR_INIT_R1 
                         ,SMOD_INIT_R1 
                         ,SSIZE_INIT_R1 
                         ,DMOD_INIT_R1
                         ,DSIZE_INIT_R1 
                         ,SOFF_INIT_R1 
                         ,NBYTES_INIT_R1
                         ,SLAST_INIT_R1
                         ,DADDR_INIT_R1
                         ,CITERE_LINK_INIT_R1
                         ,CITER_INIT_R1
                         ,DOFF_INIT_R1
                         ,DLAST_SGA_INIT_R1
                         ,BITERE_LINK_INIT_R1
                         ,BITER_INIT_R1
                         ,BWC_INIT_R1 
                         ,MAJORLINKCH_INIT_R1
                         ,DONE_INIT_R1
                         ,ACTIVE_INIT_R1
                         ,MAJORE_LINK_INIT_R1
                         ,E_SG_INIT_R1
                         ,D_REQ_INIT_R1
                         ,INT_HALF_INIT_R1
                         ,INT_MAJ_INIT_R1
                         ,START_INIT_R1
                         };                                                  

 struct TCD_Init_Struct TCD_ADC_CQ = {SADDR_ADC_CQ 
                         ,SMOD_ADC_CQ 
                         ,SSIZE_ADC_CQ 
                         ,DMOD_ADC_CQ
                         ,DSIZE_ADC_CQ 
                         ,SOFF_ADC_CQ 
                         ,NBYTES_ADC_CQ
                         ,SLAST_ADC_CQ
                         ,DADDR_ADC_CQ
                         ,CITERE_LINK_ADC_CQ
                         ,CITER_ADC_CQ
                         ,DOFF_ADC_CQ
                         ,DLAST_SGA_ADC_CQ
                         ,BITERE_LINK_ADC_CQ
                         ,BITER_ADC_CQ
                         ,BWC_ADC_CQ 
                         ,MAJORLINKCH_ADC_CQ
                         ,DONE_ADC_CQ
                         ,ACTIVE_ADC_CQ
                         ,MAJORE_LINK_ADC_CQ
                         ,E_SG_ADC_CQ
                         ,D_REQ_ADC_CQ
                         ,INT_HALF_ADC_CQ
                         ,INT_MAJ_ADC_CQ
                         ,START_ADC_CQ
                         };

 struct TCD_Init_Struct TCD_ADC_CQ_CONFIG = {SADDR_ADC_CQ_CONFIG 
                         ,SMOD_ADC_CQ_CONFIG 
                         ,SSIZE_ADC_CQ_CONFIG 
                         ,DMOD_ADC_CQ_CONFIG
                         ,DSIZE_ADC_CQ_CONFIG 
                         ,SOFF_ADC_CQ_CONFIG 
                         ,NBYTES_ADC_CQ_CONFIG
                         ,SLAST_ADC_CQ_CONFIG
                         ,DADDR_ADC_CQ_CONFIG
                         ,CITERE_LINK_ADC_CQ_CONFIG
                         ,CITER_ADC_CQ_CONFIG
                         ,DOFF_ADC_CQ_CONFIG
                         ,DLAST_SGA_ADC_CQ_CONFIG
                         ,BITERE_LINK_ADC_CQ_CONFIG
                         ,BITER_ADC_CQ_CONFIG
                         ,BWC_ADC_CQ_CONFIG 
                         ,MAJORLINKCH_ADC_CQ_CONFIG
                         ,DONE_ADC_CQ_CONFIG
                         ,ACTIVE_ADC_CQ_CONFIG
                         ,MAJORE_LINK_ADC_CQ_CONFIG
                         ,E_SG_ADC_CQ_CONFIG
                         ,D_REQ_ADC_CQ_CONFIG
                         ,INT_HALF_ADC_CQ_CONFIG
                         ,INT_MAJ_ADC_CQ_CONFIG
                         ,START_ADC_CQ_CONFIG
                         };


#endif /*end of ifdef _MAIN_ */

/*********************************************************************
 *
 * Copyright:
 *	Freescale Semiconductor, INC. All Rights Reserved.
 *  You are hereby granted a copyright license to use, modify, and
 *  distribute the SOFTWARE so long as this entire notice is
 *  retained without alteration in any modified and/or redistributed
 *  versions, and that such modified versions are clearly identified
 *  as such. No licenses are granted by implication, estoppel or
 *  otherwise under any patents or trademarks of Freescale
 *  Semiconductor, Inc. This software is provided on an "AS IS"
 *  basis and without warranty.
 *
 *  To the maximum extent permitted by applicable law, Freescale
 *  Semiconductor DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED,
 *  INCLUDING IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A
 *  PARTICULAR PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH
 *  REGARD TO THE SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF)
 *  AND ANY ACCOMPANYING WRITTEN MATERIALS.
 *
 *  To the maximum extent permitted by applicable law, IN NO EVENT
 *  SHALL Freescale Semiconductor BE LIABLE FOR ANY DAMAGES WHATSOEVER
 *  (INCLUDING WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS,
 *  BUSINESS INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER
 *  PECUNIARY LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.
 *
 *  Freescale Semiconductor assumes no responsibility for the
 *  maintenance and support of this software
 ********************************************************************/

