// ========================================================
//   Copyright (C) 2003 Motorola, Inc.
//   All Rights Reserved
//
//   The code is the property of Motorola GmbH Munich
//   Combined Technologies Operation
//   and is Motorola Confidential Proprietary Information.
//
//   The copyright notice above does not evidence any
//   actual or intended publication of such source code.
//
//
// Filename:     $Source:  $
// Author:       $Author:  $
// Locker:       $Locker:  $
// State:        $State: Exp $
// Revision:     $Revision: 1.6 $
//
// Functions:    
//
// History:      Use the CVS command log to display 
//               revision history information.
//
// Description:  
//
//
//
// Notes:        Timer A channel 1 used to generate FGEN signal
//               ~25kHz 50% duty cycle
//
//
// ========================================================
#define   TIMERA_C 

#include "TimerA.h"


// --------------------------------------------------------
// --------------------------------------------------------
static union uWord fTemp;

// --------------------------------------------------------
// Properties (public)
// --------------------------------------------------------

// --------------------------------------------------------
// Properties (private)
// --------------------------------------------------------

// --------------------------------------------------------
// Methodes (public)
// --------------------------------------------------------
void TimerAInit(void)  {

  rTASC |= (bTRST|bTSTOP);                                  // Configure TimB, PS=1

  // set pwm frequency  
  fTemp.Word = (UINT16)(BUSFREQUENCY/FGENFREQUENCY);
  rTAMODH = fTemp.Byte.HiByte;
  rTAMODL = fTemp.Byte.LoByte;


  fTemp.Word = fTemp.Word/2;                                // 50% duty
  rTACH0H = fTemp.Byte.HiByte;	                                          
  rTACH0L = fTemp.Byte.LoByte;	

  // config channel 1 for PWM (unbuffered)
  rTASC0 = TIM_MODE_OUTPUTCOMPARE_CLEAR|bTOV1;              // unbuffered Compare, clear on Output Compare
                                                            //        OVF(toggle)   OC(clear)          OVL 
                                                            //  _______/\__________________/
// ---------------------------------------



}
// --------------------------------------------------------
void TimerAEnable(void)  {

  rTASC &= ~bTSTOP;                                         // start Timer A      
}
// --------------------------------------------------------
void TimerADisable(void)  {

  rTASC |= bTSTOP;                                         // stop Timer A      
}

