// ========================================================
//  Copyright (c)2005 Freescale Semiconductor Inc
//  All Rights Reserved
//
//  The code is the property of Freescale GmbH Munich
//  TSPG-APD-IDC Intelligent Distributed Control Operation
//
//  The copyright notice above does not evidence any
//  actual or intended publication of such source code.
//
//  This software is provided by Freescale "AS IS" and any
//  expressed or implied warrenties, including, but not 
//  limited to, the implied warrenties of merchantability
//  and fitness for a particular purpose are disclaimed.
//  In no event shall Freescale or its contributors be 
//  liable for any direct, indirect, incidental, special,
//  examplary, or consequential damages (including, but not 
//  limited to, procurement of substitue goods or services;
//  loss of use, data, or profits; or business interruption)
//  However caused and on any theory of liability, whether 
//  in contract, strict liability, or tort (including 
//  negligence or otherwise) arising in any way out of the 
//  use of this software, even if advised of the possibility
//  of such damage.
// 
//
//
//  Filename:     $Source: D:/home/r51406/___CVS/CVS_Server2/908E624Demo/Slave/Sources/Timer.c,v $
//  Author:       $Author: r51406 $
//  Locker:       $Locker:  $
//  State:        $State: Exp $
//  Revision:     $Revision: 1.1.1.1 $
//
//  Functions:    
//
//  History:      Use the CVS command log to display 
//                revision history information.
//
//  Description:  
//								
//
//
//  Notes:        
//
//
//
// ========================================================

#define   TIMER_C 

#include "Timer.h"

// --------------------------------------------------------
// Properties (public)
// --------------------------------------------------------
unsigned int  TimerValue[TIMERMAX];

// --------------------------------------------------------
// Properties (private)
// --------------------------------------------------------
struct {
  unsigned char Running;                                    // each bit represents a channel (0=Off, 1=running)
  unsigned char Elapsed;                                    // each bit represents a channel (0=off, 1= ready)
} fTimerStatus;                                             // struct here is better optimized for speed/size


// --------------------------------------------------------
// Methodes (public)
// --------------------------------------------------------
void TimerInit(void)  {
  fTimerStatus.Running = 0;
  fTimerStatus.Elapsed = 0;
  // assuming bTMBCLKSEL in rCONFIG2 is set (/128)
  rTBCR = bTACK|bTBIE|bTBR1|bTBR0 ;                         // clear flag, enable IRQ, div 16384
  rTBCR |= bTBON;                                           //TBM on
}
// --------------------------------------------------------
void TimerEnable(void)  {
   rTBCR |= bTBON;                                          // TBM on
}
// --------------------------------------------------------
void TimerDisable(void)  {
   rTBCR &= ~bTBON;                                         // TBM off
}
// --------------------------------------------------------
void TimerStart(unsigned char channel)  {
  fTimerStatus.Running  &= ~channel;                        // Stop timer
  fTimerStatus.Running  |= channel;                         // Start timer  
  fTimerStatus.Elapsed &= ~channel;
}
// --------------------------------------------------------
void TimerStop(unsigned char channel)  {
  fTimerStatus.Running  &= ~channel;                        // Stop timer
  fTimerStatus.Elapsed  &= ~channel;
}
// --------------------------------------------------------
unsigned char TimerElapsed(unsigned char channel)  {
#if  defined(DEBUG)    
  l_u8_tx_TimerRunning(fTimerStatus.Running);               // DEBUG
#endif
  if(fTimerStatus.Elapsed&channel) {
    fTimerStatus.Elapsed &= ~channel;                       // clear ready
    return 1;                                               // return (TRUE)
  }else{
    return 0;                                               // not ready (FALSE)
  }
}
// --------------------------------------------------------
unsigned char TimerRunning(unsigned char channel)  {
  return (fTimerStatus.Running&channel);
}

// --------------------------------------------------------
// Methodes (private) - IRQ Servie
// --------------------------------------------------------
#pragma TRAP_PROC
void isrTimeBase(void)  {
  unsigned char channel, idx;

  if (rTBCR&bTBIF){                                        // test flag 
    rTBCR |= bTACK;                                        // clear flag 
    l_ifc_ioctl_sci0(l_op_idleclock, NULL);                // Increment No-Bus-Activity condition counter by 1

    channel = 0x01; 
    idx = 0;   
    do {
      if(fTimerStatus.Running&channel) {                   // if timer is running  
        if(TimerValue[idx]==0)  {                          // if finished
          fTimerStatus.Running &= ~channel;                // stop timer
          fTimerStatus.Elapsed |= channel;                 // signal timer has finished
        }else{
          TimerValue[idx]--;                               // decrement timer
        }
      }
      idx++;                                               // next channel
      channel <<= 1;
    }while(idx<TIMERMAX);                                  // next channel    
  }
}
  
