// ========================================================
//  Copyright (c)2005 Freescale Semiconductor Inc
//  All Rights Reserved
//
//  The code is the property of Freescale GmbH Munich
//  TSPG-APD-IDC Intelligent Distributed Control Operation
//
//  The copyright notice above does not evidence any
//  actual or intended publication of such source code.
//
//  This software is provided by Freescale "AS IS" and any
//  expressed or implied warrenties, including, but not 
//  limited to, the implied warrenties of merchantability
//  and fitness for a particular purpose are disclaimed.
//  In no event shall Freescale or its contributors be 
//  liable for any direct, indirect, incidental, special,
//  examplary, or consequential damages (including, but not 
//  limited to, procurement of substitue goods or services;
//  loss of use, data, or profits; or business interruption)
//  However caused and on any theory of liability, whether 
//  in contract, strict liability, or tort (including 
//  negligence or otherwise) arising in any way out of the 
//  use of this software, even if advised of the possibility
//  of such damage.
// 
//
//
//  Filename:     $Source: D:/home/r51406/___CVS/CVS_Server2/MM908Exxx/ChipSets.h,v $
//  Author:       $Author: r51406 $
//  Locker:       $Locker:  $
//  State:        $State: Exp $
//  Revision:     $Revision: 1.3 $
//
//  Functions:    
//
//  History:      Use the CVS command log to display 
//                revision history information.
//
//  Description:  
//
//
//
//  Notes:        
//
//
//
// ========================================================
#ifndef   CHIPSETS_H
#define   CHIPSETS_H

// --------------------------------------------------------
// Chip Sets ...
// --------------------------------------------------------

// --------------------------------------------------------
#if  defined(MM908E621)
#define HC908EY16                                           // MCU
#define QUAILMAX                                            // SMOS
#endif
// --------------------------------------------------------
#if  defined(MM908E622)
#define HC908EY16                                           // MCU
#define SHADOW                                              // SMOS
#endif
// --------------------------------------------------------
#if  defined(MM908E624)
#define HC908EY16                                           // MCU
#define KOBI                                                // SMOS
#endif
// --------------------------------------------------------
#if  defined(MM908E625)
#define HC908EY16                                           // MCU
#define CAIRON                                              // SMOS
#endif
// --------------------------------------------------------
#if  defined(MM908E630)
#define HC908EY16                                           // MCU
#define LEVANTAR                                            // SMOS
#endif


// --------------------------------------------------------
// Chip specific defines
// --------------------------------------------------------
#if   defined(HC908EY16)        // ------------------------
  #include "908EY16_IO.h"       // Register definitions
  
  
  // --------------------------------------------------------
  // different chip sets use different SPI Slave Select port on MCU side
  // ----------------------------
  #if defined(MM908E621)

    // SPI defines
    #define __16_BIT_SPI
    #define __SS_DDR      rDDRA
    #define __SS_PORT     rPORTA
    #define __SS_PIN      bPTA6
    #define __SPSCK_DDR   rDDRA
    #define __SPSCK_PORT  rPORTA
    #define __SPSCK_PIN   bPTA5
    #define __MISO_DDR    rDDRC
    #define __MISO_PORT   rPORTC
    #define __MISO_PIN    bPTC0
    #define __MOSI_DDR    rDDRC
    #define __MOSI_PORT   rPORTC
    #define __MOSI_PIN    bPTC1

    // ADOUT
    #define __ADC_DDR     rDDRB
    #define __ADC_PIN     bPTB0
    
    // SCI
    #define __TXD_DDR     rDDRE
    #define __TXD_PORT    rPORTE
    #define __TXD_PIN     bPTE0
    #define __RXD_DDR     rDDRE
    #define __RXD_PORT    rPORTE
    #define __RXD_PIN     bPTE1

  #endif
  // ----------------------------
  #if defined(MM908E622)

    // SPI defines
    #define __16_BIT_SPI
    #define __SS_DDR      rDDRA
    #define __SS_PORT     rPORTA
    #define __SS_PIN      bPTA6
    #define __SPSCK_DDR   rDDRA
    #define __SPSCK_PORT  rPORTA
    #define __SPSCK_PIN   bPTA5
    #define __MISO_DDR    rDDRC
    #define __MISO_PORT   rPORTC
    #define __MISO_PIN    bPTC0
    #define __MOSI_DDR    rDDRC
    #define __MOSI_PORT   rPORTC
    #define __MOSI_PIN    bPTC1

    // ADOUT
    #define __ADC_DDR     rDDRB
    #define __ADC_PIN     bPTB0
    
    // SCI
    #define __TXD_DDR     rDDRE
    #define __TXD_PORT    rPORTE
    #define __TXD_PIN     bPTE0
    #define __RXD_DDR     rDDRE
    #define __RXD_PORT    rPORTE
    #define __RXD_PIN     bPTE1

  #endif

  // ----------------------------
  #if defined(MM908E624)

    // SPI defines
    #define __8_BIT_SPI
    #define __SS_DDR      rDDRA
    #define __SS_PORT     rPORTA
    #define __SS_PIN      bPTA6
    #define __SPSCK_DDR   rDDRA
    #define __SPSCK_PORT  rPORTA
    #define __SPSCK_PIN   bPTA5
    #define __MISO_DDR    rDDRC
    #define __MISO_PORT   rPORTC
    #define __MISO_PIN    bPTC0
    #define __MOSI_DDR    rDDRC
    #define __MOSI_PORT   rPORTC
    #define __MOSI_PIN    bPTC1

    // ADOUT
//    #define __ADC_DDR     rDDRB
//    #define __ADC_PIN     bPTB0
    
    // SCI
    #define __TXD_DDR     rDDRE
    #define __TXD_PORT    rPORTE
    #define __TXD_PIN     bPTE0
    #define __RXD_DDR     rDDRE
    #define __RXD_PORT    rPORTE
    #define __RXD_PIN     bPTE1

  #endif
  #if defined(MM908E625)
    #define __16_BIT_SPI

    #warning "Slave Select Pin is PTD1 on Final EVB"    
    #define __SS_DDR      rDDRD           // On HBLED G-Sense Brake Lamp
    #define __SS_PORT     rPORTD          // This is on PTD1
    #define __SS_PIN      bPTD1           

    #define __SPSCK_DDR   rDDRA
    #define __SPSCK_PORT  rPORTA
    #define __SPSCK_PIN   bPTA5                             // die-to-die
    #define __MISO_DDR    rDDRC
    #define __MISO_PORT   rPORTC
    #define __MISO_PIN    bPTC0                             // die-to-die
    #define __MOSI_DDR    rDDRC
    #define __MOSI_PORT   rPORTC
    #define __MOSI_PIN    bPTC1                             // die-to-die

    // ADOUT
    #define __ADC_DDR     rDDRB
    #define __ADC_PIN     bPTB0                             // die-to-die

    // SCI
    #define __TXD_DDR     rDDRE
    #define __TXD_PORT    rPORTE
    #define __TXD_PIN     bPTE0                             // die-to-die
    #define __RXD_DDR     rDDRE
    #define __RXD_PORT    rPORTE
    #define __RXD_PIN     bPTE1                             // on pcb board
  #endif

  // ----------------------------
  #if defined(MM908E630)

    // SPI defines
    #define __2_4_BIT_SPI
    #define __SS_DDR      rDDRA
    #define __SS_PORT     rPORTA
    #define __SS_PIN      bPTA6
    #define __SPSCK_DDR   rDDRA
    #define __SPSCK_PORT  rPORTA
    #define __SPSCK_PIN   bPTA5
    #define __MISO_DDR    rDDRC
    #define __MISO_PORT   rPORTC
    #define __MISO_PIN    bPTC0
    #define __MOSI_DDR    rDDRC
    #define __MOSI_PORT   rPORTC
    #define __MOSI_PIN    bPTC1

    // ADOUT
    #define __ADC_DDR     rDDRB
    #define __ADC_PIN     bPTB0
    
    // SCI
    #define __TXD_DDR     rDDRE
    #define __TXD_PORT    rPORTE
    #define __TXD_PIN     bPTE0
    #define __RXD_DDR     rDDRE
    #define __RXD_PORT    rPORTE
    #define __RXD_PIN     bPTE1

  #endif




  #include "908EY16_SPI.h"                                  // SPI routines
  #include "908EY16_ESCI.h"                                 // ESCI routines
  #include "908EY16_ADC.h"                                  // A/D converter routines
  #include "908EY16_FLASH.h"                                // FLASH program/erase routines
#endif                                                    


#if   defined(CAIRON)                                       // ------------------------
  #include "CAIRON_IO.h"                                    // Register definitions
  #include "CAIRON_ADC.h"                                   // ADC-Channel definitions
#endif                                                     

#if   defined(SHADOW)                                       // ------------------------
  #include "SHADOW_IO.h"                                    // Register definitions
  #include "SHADOW_ADC.h"                                   // ADC-Channel definitions
#endif

#if   defined(QUAILMAX)                                     // ------------------------
  #include "QUAILMAX_IO.h"                                  // Register definitions
  #include "QUAILMAX_ADC.h"                                 // ADC-Channel definitions
#endif

#if defined(KOBI)                                           // ------------------------
  #include "KOBI_IO.h"                                      // Register definitions
#endif                                                      
                                                            
#if   defined(LEVANTAR)                                     // ------------------------
  #include "LEVANTAR_IO.h"                                  // Register definitions
  #include "LEVANTAR_ADC.h"                                 // ADC-Channel definitions
#endif


#endif  // CHIPSETS_H
