// ========================================================
//  Copyright (c)2005 Freescale Semiconductor Inc
//  All Rights Reserved
//
//  The code is the property of Freescale GmbH Munich
//  TSPG-APD-IDC Intelligent Distributed Control Operation
//
//  The copyright notice above does not evidence any
//  actual or intended publication of such source code.
//
//  This software is provided by Freescale "AS IS" and any
//  expressed or implied warrenties, including, but not 
//  limited to, the implied warrenties of merchantability
//  and fitness for a particular purpose are disclaimed.
//  In no event shall Freescale or its contributors be 
//  liable for any direct, indirect, incidental, special,
//  examplary, or consequential damages (including, but not 
//  limited to, procurement of substitue goods or services;
//  loss of use, data, or profits; or business interruption)
//  However caused and on any theory of liability, whether 
//  in contract, strict liability, or tort (including 
//  negligence or otherwise) arising in any way out of the 
//  use of this software, even if advised of the possibility
//  of such damage.
// 
//
//
//  Filename:     $Source: D:/home/r51406/___CVS/CVS_Server2/MM908Exxx/CAIRON_IO.h,v $
//  Author:       $Author: r51406 $
//  Locker:       $Locker:  $
//  State:        $State: Exp $
//  Revision:     $Revision: 1.1.1.1 $
//
//  Functions:    
//
//  History:      Use the CVS command log to display 
//                revision history information.
//
//  Description:  Hardware Description File (Register File)
//                for Cairon SMOS Chip
//
//
//  Notes:        use SPI routines to read / write register
//
//
//
// ========================================================
#ifndef  CAIRON_IO_H
#define  CAIRON_IO_H

#include "Types.h"


// -----  Register  ----------------------------------------
#define erHBOUT     0x01                                    // H-Bridge output
#define   bHB4_H    BIT7
#define   bHB4_L    BIT6
#define   bHB3_H    BIT5
#define   bHB3_L    BIT4
#define   bHB2_H    BIT3
#define   bHB2_L    BIT2
#define   bHB1_H    BIT1
#define   bHB1_L    BIT0

#define erHBCTL     0x02                                    // H-Bridge control
#define   bOFC_EN   BIT7
#define   bCSA      BIT6
#define   bCLS2     BIT2
#define   bCLS1     BIT1
#define   bCLS0     BIT0

#define erSYSCTL    0x03                                    // System control
#define   bPSON     BIT7
#define   bSRS1     BIT6
#define   bSRS0     BIT5
#define   bGS       BIT0

#define erIMR       0x04                                    // Interrupt mask
#define   bWUIE     BIT7
#define   bPHIE     BIT6
#define   bISOIE    BIT5
#define   bHTIE     BIT4
#define   bLVIE     BIT3
#define   bHVIE     BIT2
#define   bOCIE     BIT1

#define erIFR       0x05                                    // Interrupt flag
#define   bWUIF     BIT7
#define   bPHIF     BIT6
#define   bISOIF    BIT5
#define   bHTIF     BIT4
#define   bLVIF     BIT3
#define   bHVIF     BIT2
#define   bOCIF     BIT1

#define erRMR       0x06                                    // Reset mask
#define   bTTEST    BIT7
#define   bHVRE     BIT1
#define   bHTRE     BIT0

#define erADOUT     0x07                                    // A/D Output
#define   bSS3      BIT3
#define   bSS2      BIT2
#define   bSS1      BIT1
#define   bSS0      BIT0

#define erHACTL     0x08                                    // Hallport Control
#define   bH3EN     BIT2
#define   bH2EN     BIT1
#define   bH1EN     BIT0

#define erHASTAT    0x09                                    // Hallport Status
#define   bWUPIN    BIT7
#define   bH3F      BIT2
#define   bH2F      BIT1
#define   bH1F      BIT0

#define erAWDCTL    0x0A                                    // AWD Control
#define   bAWDRST   BIT5
#define   bAWDRE    BIT4
#define   bAWDIE    BIT3
#define   bAWDCC    BIT2
#define   bAWDF     BIT1
#define   bAWDR     BIT0

#define erPOUT      0x0B                                    // Power Output
#define   bCSSEL1   BIT5
#define   bCSSEL0   BIT4
#define   bCSEN1    BIT3
#define   bCSEN0    BIT2
#define   bHVDDON   BIT1
#define   bHS_ON    BIT0
  

#define erSYSSTAT   0x0C                                    // System Status register
#define   bHP_OCF   BIT7
#define   bSICL     BIT6
#define   bHVDD_OCF BIT5
#define   bHS_OCF   BIT4
#define   bHB_LVF   BIT3
#define   bHB_HVF   BIT2
#define   bHB_OCF   BIT1
#define   bHB_OTF   BIT0


#endif //CAIRON_IO_H
