// ========================================================
//  Copyright (c)2005 Freescale Semiconductor Inc
//  All Rights Reserved
//
//  The code is the property of Freescale GmbH Munich
//  TSPG-APD-IDC Intelligent Distributed Control Operation
//
//  The copyright notice above does not evidence any
//  actual or intended publication of such source code.
//
//  This software is provided by Freescale "AS IS" and any
//  expressed or implied warrenties, including, but not 
//  limited to, the implied warrenties of merchantability
//  and fitness for a particular purpose are disclaimed.
//  In no event shall Freescale or its contributors be 
//  liable for any direct, indirect, incidental, special,
//  examplary, or consequential damages (including, but not 
//  limited to, procurement of substitue goods or services;
//  loss of use, data, or profits; or business interruption)
//  However caused and on any theory of liability, whether 
//  in contract, strict liability, or tort (including 
//  negligence or otherwise) arising in any way out of the 
//  use of this software, even if advised of the possibility
//  of such damage.
// 
//
//
//  Filename:     $Source: D:/home/r51406/___CVS/CVS_Server2/MM908Exxx/908EY16_SPI.h,v $
//  Author:       $Author: r51406 $
//  Locker:       $Locker:  $
//  State:        $State: Exp $
//  Revision:     $Revision: 1.3 $
//
//  Functions:    
//
//  History:      Use the CVS command log to display 
//                revision history information.
//
//  Description:  SPI support routines
//								for AdrenaLIN 68HC908EY16 MCU
//
//
//  Notes:        
//
//
//
// ========================================================
#ifndef  _908EY16_SPI_H
#define  _908EY16_SPI_H

// --------------------------------------------------------
// includes
// --------------------------------------------------------
#include "types.h"
#include "Hicross.h"
#include "ChipSets.h"

// --------------------------------------------------------
// defines
// --------------------------------------------------------

// --------------------------------------------------------
// properties (public)
// --------------------------------------------------------

// --------------------------------------------------------
// methodes published
// --------------------------------------------------------
#if      defined(__2_4_BIT_SPI)

void SPI_Init(void);
void SPI_Write(UINT8 add, UINT8 data);
void SPI_Read(UINT8 add);
UINT8 SPI_RegValue(UINT8 add);

#endif //defined(__16_BIT_SPI)



// --------------------------------------------------------
#if      defined(__8_BIT_SPI)

void SPI_Init(void);
UINT8 SPI_ReadWrite(UINT8 data);

#endif //defined(__8_BIT_SPI)
// --------------------------------------------------------

// --------------------------------------------------------
#if      defined(__16_BIT_SPI)

void SPI_Init(void);
void SPI_Write(UINT8 add, UINT8 data);
void SPI_Read(UINT8 add);
UINT8 SPI_RegValue(UINT8 add);
 
//#define SPI_Modify(r,v)        (SPI_Write(r, SPI_RegValue(r)v))
//#define SPI_ReadModify(r,v)    (SPI_Read(r); SPI_Write(r, SPI_RegValue(r)(v)))


#endif //defined(__16_BIT_SPI)
// --------------------------------------------------------


#endif //_908EY16_SPI_H