// ========================================================
//  Copyright (c)2005 Freescale Semiconductor Inc
//  All Rights Reserved
//
//  The code is the property of Freescale GmbH Munich
//  TSPG-APD-IDC Intelligent Distributed Control Operation
//
//  The copyright notice above does not evidence any
//  actual or intended publication of such source code.
//
//  This software is provided by Freescale "AS IS" and any
//  expressed or implied warrenties, including, but not 
//  limited to, the implied warrenties of merchantability
//  and fitness for a particular purpose are disclaimed.
//  In no event shall Freescale or its contributors be 
//  liable for any direct, indirect, incidental, special,
//  examplary, or consequential damages (including, but not 
//  limited to, procurement of substitue goods or services;
//  loss of use, data, or profits; or business interruption)
//  However caused and on any theory of liability, whether 
//  in contract, strict liability, or tort (including 
//  negligence or otherwise) arising in any way out of the 
//  use of this software, even if advised of the possibility
//  of such damage.
// 
//
//
//  Filename:     $Source: D:/home/r51406/___CVS/CVS_Server2/MM908Exxx/908EY16_IO.h,v $
//  Author:       $Author: r51406 $
//  Locker:       $Locker:  $
//  State:        $State: Exp $
//  Revision:     $Revision: 1.5 $
//
//  Functions:    
//
//  History:      Use the CVS command log to display 
//                revision history information.
//
//  Description:  Hardware Description File (Register File)
//								for AdrenaLIN 68HC908EY16 MCU
//
//
//  Notes:        
//
//
//
// ========================================================
#ifndef _908EY16_IO_H
#define _908EY16_IO_H

// --------------------------------------------------------
#include "Types.h"

// --------------------------------------------------------
#define  IOBYTE(address)     (*((volatile unsigned char*) (address)))
#define  IOWORD(address)     (*((volatile unsigned int*) (address)))


// --------------------------------------------------------
// -----  PORTS I  ----------------------------------------
// --------------------------------------------------------
#define rPORTA            IOBYTE(0x00)                      // port A 

#define   bPTA6           BIT6                               
#define   bPTA5           BIT5                               
#define   bPTA4           BIT4                               
#define   bPTA3           BIT3                               
#define   bPTA2           BIT2                               
#define   bPTA1           BIT1                               
#define   bPTA0           BIT0                                 
#define   bSSB            BIT6                              // 
#define   bSPSCK          BIT5                              // 
#define   bKBD4B          BIT4                              // 
#define   bKBD3B          BIT3                              // 
#define   bKBD2B          BIT2                              // 
#define   bKBD1B          BIT1                              // 
#define   bKBD0B          BIT0                              //   

// --------------------------------------------------------
#define rPORTB            IOBYTE(0x01)                      // port B 

#define   bPTB7           BIT7                               
#define   bPTB6           BIT6                               
#define   bPTB5           BIT5                               
#define   bPTB4           BIT4                               
#define   bPTB3           BIT3                               
#define   bPTB2           BIT2                               
#define   bPTB1           BIT1                               
#define   bPTB0           BIT0                                 

// --------------------------------------------------------
#define rPORTC            IOBYTE(0x02)                      // port C 

#define   bPTC4           BIT4                               
#define   bPTC3           BIT3                               
#define   bPTC2           BIT2                               
#define   bPTC1           BIT1                               
#define   bPTC0           BIT0                                 

// --------------------------------------------------------
#define rPORTD            IOBYTE(0x03)                      // port D

#define   bPTD1           BIT1                               
#define   bPTD0           BIT0                                 

// --------------------------------------------------------
#define rDDRA             IOBYTE(0x04)                      // data direction port A 

#define   bDDRA6          BIT6                              
#define   bDDRA5          BIT5                              
#define   bDDRA4          BIT4                              
#define   bDDRA3          BIT3                              
#define   bDDRA2          BIT2                              
#define   bDDRA1          BIT1                              
#define   bDDRA0          BIT0                               

// --------------------------------------------------------
#define rDDRB             IOBYTE(0x05)                      // data direction port B 

#define   bDDRB7          BIT7                              
#define   bDDRB6          BIT6                              
#define   bDDRB5          BIT5                              
#define   bDDRB4          BIT4                              
#define   bDDRB3          BIT3                              
#define   bDDRB2          BIT2                              
#define   bDDRB1          BIT1                              
#define   bDDRB0          BIT0                               

// --------------------------------------------------------
#define rDDRC             IOBYTE(0x06)                      // data direction port C 

#define   bMCLKEN         BIT7                              
#define   bDDRC4          BIT4                              
#define   bDDRC3          BIT3                              
#define   bDDRC2          BIT2                              
#define   bDDRC1          BIT1                              
#define   bDDRC0          BIT0                               

// --------------------------------------------------------
#define rDDRD             IOBYTE(0x07)                      // data direction port D

#define   bDDRD1          BIT1                              
#define   bDDRD0          BIT0                               

// --------------------------------------------------------
#define rPORTE            IOBYTE(0x08)                      // port E

#define   bPTE1           BIT1                               
#define   bPTE0           BIT0                                 
#define   bRXD            BIT1                               
#define   bTXD            BIT0                                 

// --------------------------------------------------------
// -----  TESTPORT (TDAT/TCLK) ----------------------------
// --------------------------------------------------------
#define rTESTPORT   IOBYTE(0x09)                            // Testport register   

#define   bTDI      BIT7
#define   bTDO      BIT6
#define   bTR       BIT5

// --------------------------------------------------------
// -----  PORTS II  ---------------------------------------
// --------------------------------------------------------
#define rDDRE             IOBYTE(0x0A)                      // data direction port E

#define   bDDRE1          BIT1                              
#define   bDDRE0          BIT0                               

// --------------------------------------------------------
// -----  BEMF  -------------------------------------------
// --------------------------------------------------------
#define rBEMF             IOBYTE(0x0B)                      // BEMF register

// --------------------------------------------------------
// -----  SPI  --------------------------------------------
// --------------------------------------------------------
#define rSPCR             IOBYTE(0x0D)                      // SPI control register 

#define   bSPRIE          BIT7                              // SPI Receiver Interrupt Enable Bit
#define   bSPMSTR         BIT5                              // SPI Master Bit
#define   bCPOL           BIT4                              // Clock Polarity Bit
#define   bCPHA           BIT3                              // Clock Phase Bit
#define   bSPWOM          BIT2                              // SPI Wired-OR Mode Bit
#define   bSPE            BIT1                              // SPI Enable Bit
#define   bSPTIE          BIT0                              // SPI Transmit Interrupt Enable Bit
                                                            
// --------------------------------------------------------
#define rSPSCR            IOBYTE(0x0E)                      // SPI control/status register 

#define   bSPRF           BIT7                              // SPI Receiver Full Bit
#define   bERRIE          BIT6                              // Error Interrupt Enable Bit
#define   bOVRF           BIT5                              // Overflow Bit
#define   bMODF           BIT4                              // Mode Fault Bit
#define   bSPTE           BIT3                              // SPI Transmitter Empty Bit
#define   bMODFEN         BIT2                              // Mode Fault Enable Bit
#define   bSPR1           BIT1                              // SPI Baud Rate Select Bits
#define   bSPR0           BIT0                              // SPI Baud Rate Select Bits   

// --------------------------------------------------------
#define rSPDR             IOBYTE(0x0F)                      // SPI data register 

// --------------------------------------------------------
// -----  ESCI  -------------------------------------------
// --------------------------------------------------------
#define rSCC1             IOBYTE(0x10)                      // ESCI control register 1 

#define   bLOOPS          BIT7                              // Loop Mode Select Bit
#define   bENSCI          BIT6                              // Enable ESCI Bit
#define   bTXINV          BIT5                              // Transmit Inversion Bit
#define   bM              BIT4                              // Mode (Character Length) Bit
#define   bWAKE           BIT3                              // Mode (Character Length) Bit
#define   bILTY           BIT2                              // Idle Line Type Bit
#define   bPEN            BIT1                              // Parity Enable Bit
#define   bPTY            BIT0                              // Parity Bit    

// --------------------------------------------------------
#define rSCC2             IOBYTE(0x11)                      // ESCI control register 2 

#define   bSCTIE          BIT7                              // ESCI Transmit Interrupt Enable Bit
#define   bTCIE           BIT6                              // Transmission Complete Interrupt Enable Bit 
#define   bSCRIE          BIT5                              // ESCI Receive Interrupt Enable Bit
#define   bILIE           BIT4                              // Idle Line Interrupt Enable Bit
#define   bTE             BIT3                              // Transmitter Enable Bit
#define   bRE             BIT2                              // Receiver Enable Bit
#define   bRWU            BIT1                              // Receiver Wakeup Bit
#define   bSBK            BIT0                              // Send Break Bit    

// --------------------------------------------------------
#define rSCC3             IOBYTE(0x12)                      // ESCI control register 3 

#define   bR8             BIT7                              // Received Bit 8
#define   bT8             BIT6                              // Transmitted Bit 8
#define   bORIE           BIT3                              // Receiver Overrun Interrupt Enable Bit
#define   bNEIE           BIT2                              // Receiver Noise Error Interrupt Enable Bit
#define   bFEIE           BIT1                              // Receiver Framing Error Interrupt Enable Bit
#define   bPEIE           BIT0                              // Receiver Parity Error Interrupt Enable Bit    
                          
// --------------------------------------------------------
#define rSCS1             IOBYTE(0x13)                      // ESCI status register 1 

#define   bSCTE           BIT7                              // ESCI Transmitter Empty Bit
#define   bTC             BIT6                              // Transmission Complete Bit
#define   bSCRF           BIT5                              // ESCI Receiver Full Bit
#define   bIDLE           BIT4                              // Receiver Idle Bit
#define   bOR             BIT3                              // Receiver Overrun Bit
#define   bNF             BIT2                              // Receiver Noise Flag Bit
#define   bFE             BIT1                              // Receiver Framing Error Bit
#define   bPE             BIT0                              // Receiver Parity Error Bit    

// --------------------------------------------------------
#define rSCS2             IOBYTE(0x14)                      // ESCI status register 2 

#define   bBKF            BIT1                              // Break Flag Bit
#define   bRPF            BIT0                              // Reception in Progress Flag Bit    

// --------------------------------------------------------
#define rSCDR             IOBYTE(0x15)                      // ESCI data register 

// --------------------------------------------------------
#define rSCBR             IOBYTE(0x16)                      // ESCI baud rate 

#define   bLINR           BIT6                              // LIN Receiver Bits                               
#define   bSCP1           BIT5                              // ESCI Baud Rate Register Prescaler Bits
#define   bSCP0           BIT4                              // ESCI Baud Rate Register Prescaler Bits
#define   bSCR2           BIT2                              // ESCI Baud Rate Select Bits
#define   bSCR1           BIT1                              // ESCI Baud Rate Select Bits
#define   bSCR0           BIT0                              // ESCI Baud Rate Select Bits

// --------------------------------------------------------
#define rSCPSC            IOBYTE(0x17)                      // ESCI Prescaler Register 

#define   bPDS2           BIT7                              // Prescaler Divisor Select Bits
#define   bPDS1           BIT6                              // Prescaler Divisor Select Bits
#define   bPDS0           BIT5                              // Prescaler Divisor Select Bits
#define   bPSSB4          BIT4                              // Clock Insertion Select Bits
#define   bPSSB3          BIT3                              // Clock Insertion Select Bits
#define   bPSSB2          BIT2                              // Clock Insertion Select Bits
#define   bPSSB1          BIT1                              // Clock Insertion Select Bits
#define   bPSSB0          BIT0                              // Clock Insertion Select Bits
  
// --------------------------------------------------------
// -----  ESCI  Arbiter  ----------------------------------
// --------------------------------------------------------
#define rSCIACTL          IOBYTE(0x18)                      // ESCI arbiter control register 

#define   bAM1            BIT7                              // Arbiter Mode Select Bits
#define   bALOST          BIT6                              // Arbitration Lost Flag
#define   bAM0            BIT5                              // Arbiter Mode Select Bits
#define   bACLK           BIT4                              // Arbiter Counter Clock Select Bit
#define   bAFIN           BIT3                              // Arbiter Bit Time Measurement Finish Flag
#define   bARUN           BIT2                              // Arbiter Counter Running Flag
#define   bAROVFL         BIT1                              // Arbiter Counter Overflow Bit
#define   bARD8           BIT0                              // Arbiter Counter MSB

// --------------------------------------------------------
#define rSCIADAT          IOBYTE(0x19)                      // ESCI arbiter data register 

#define   bARD7           BIT7                              // Arbiter Least Significant Counter Bits
#define   bARD6           BIT6                              // Arbiter Least Significant Counter Bits
#define   bARD5           BIT5                              // Arbiter Least Significant Counter Bits
#define   bARD4           BIT4                              // Arbiter Least Significant Counter Bits
#define   bARD3           BIT3                              // Arbiter Least Significant Counter Bits
#define   bARD2           BIT2                              // Arbiter Least Significant Counter Bits
#define   bARD1           BIT1                              // Arbiter Least Significant Counter Bits
#define   bARD0           BIT0                              // Arbiter Least Significant Counter Bits

// --------------------------------------------------------
// -----  Keyboard  ---------------------------------------
// --------------------------------------------------------
#define rKBSCR         IOBYTE(0x1A)                         // Keyboard Status and Control Register

#define   bKEYF           BIT3                              // Keyboard Flag Bit
#define   bACKK           BIT2                              // Keyboard Acknowledge Bit
#define   bIMASKK         BIT1                              // Keyboard Interrupt Mask Bit
#define   bMODEK          BIT0                              // Keyboard Triggering Sensitivity Bit

// --------------------------------------------------------
#define rKBIER         IOBYTE(0x1B)                         // Keyboard Interrupt Enable Register 

#define   bKBIE4          BIT4                              // Keyboard Interrupt Enable Bits
#define   bKBIE3          BIT3                              // Keyboard Interrupt Enable Bits
#define   bKBIE2          BIT2                              // Keyboard Interrupt Enable Bits
#define   bKBIE1          BIT1                              // Keyboard Interrupt Enable Bits
#define   bKBIE0          BIT0                              // Keyboard Interrupt Enable Bits

// --------------------------------------------------------
// -----  TIMEBASE  ---------------------------------------                                         
// --------------------------------------------------------
#define rTBCR             IOBYTE(0x1C)                      // Timebase Control Register

#define   bTBIF           BIT7                              // Timebase Interrupt Flag 
#define   bTBR2           BIT6                              // Timebase Divider Selection Bits 
#define   bTBR1           BIT5                              // Timebase Divider Selection Bits 
#define   bTBR0           BIT4                              // Timebase Divider Selection Bits 
#define   bTACK           BIT3                              // Timebase ACKnowledge Bit 
#define   bTBIE           BIT2                              // Timebase Interrupt Enabled Bit 
#define   bTBON           BIT1                              // Timebase Enabled Bit 

// --------------------------------------------------------
// -----  INTERRUPT  --------------------------------------                                         
// --------------------------------------------------------
#define rINTSCR           IOBYTE(0x1D)                      // IRQ Status and Control Register

#define   bIRQF           BIT3                              // IRQ Flag Bit
#define   bACK            BIT2                              // IRQ Interrupt Request Acknowledge Bit
#define   bIMASK          BIT1                              // IRQ Interrupt Mask Bit
#define   bMODE           BIT0                              // IRQ Edge/Level Select Bit

// --------------------------------------------------------
// -----  CONFIGURATION REGs  -----------------------------
// --------------------------------------------------------
#define rCONFIG2          IOBYTE(0x1E)                      // Configuration Write-Once Register 

#define   bESCIBDSRC      BIT6                              // ESCI Baud Rate Clock Source Bit   
#define   bEXTXTALEN      BIT5                              // External Crystal Enable Bit   
#define   bEXTSLOW        BIT4                              // Slow External Crystal Enable Bit   
#define   bEXTCLKEN       BIT3                              // External Clock Enable Bit    
#define   bTMBCLKSEL      BIT2                              // Timebase Clock Select Bit   
#define   bOSCENINSTOP    BIT1                              // Oscillator Enable In Stop Mode Bit   
#define   bSSBPUENB       BIT0                              // SSB Pull-up Enable Bit  

// --------------------------------------------------------
#define rCONFIG1          IOBYTE(0x1F)                      // Configuration Write-Once Register 

#define   bCOPRS          BIT7                              // COP Rate Select Bit
#define   bLVISTOP        BIT6                              // LVI Enable in Stop Mode Bit    
#define   bLVIRSTD        BIT5                              // LVI Reset Disable Bit   
#define   bLVIPWRD        BIT4                              // LVI Power Disable Bit   
#define   bLVI5OR3        BIT3                              // LVI 5-V or 3-V Operating Mode Bit   
#define   bSSREC          BIT2                              // Short Stop Recovery Bit  
#define   bSTOP           BIT1                              // STOP Instruction Enable Bit   
#define   bCOPD           BIT0                              // COP Disable Bit   
                                                            
// --------------------------------------------------------
// -----  TIMER A  ----------------------------------------                                         
// --------------------------------------------------------
#define rTASC             IOBYTE(0x20)                      // Timer A Status and Control Register

#define   bTOF            BIT7                              // Timer A Overflow Flag Bit
#define   bTOIE           BIT6                              // Timer A Overflow Interrupt Enable Bit
#define   bTSTOP          BIT5                              // Timer A Stop Bit
#define   bTRST           BIT4                              // Timer A Reset Bit
#define   bPS2            BIT2                              // Prescaler Select Bits
#define   bPS1            BIT1                              // Prescaler Select Bits
#define   bPS0            BIT0                              // Prescaler Select Bits

// --------------------------------------------------------
#define rTACNTH           IOBYTE(0x21)                      // Timer A Counter Register High
#define rTACNTL           IOBYTE(0x22)                      // Timer A Counter Register Low

// --------------------------------------------------------
#define rTAMODH           IOBYTE(0x23)                      // Timer A Counter Modulo Register High
#define rTAMODL           IOBYTE(0x24)                      // Timer A Counter Modulo Register Low
#define rTAMOD            IOWORD(0x23)                      // Timer A Counter Modulo Register 

// --------------------------------------------------------
#define rTASC0            IOBYTE(0x25)                      // Timer A Channel 0 Status and Control Register

#define   bCH0F           BIT7                              // Channel 0 Flag Bit
#define   bCH0IE          BIT6                              // Channel 0 Interrupt Enable Bit
#define   bMS0B           BIT5                              // Mode Select Bit B
#define   bMS0A           BIT4                              // Mode Select Bit A
#define   bELS0B          BIT3                              // Edge/Level Select Bits
#define   bELS0A          BIT2                              // Edge/Level Select Bits
#define   bTOV0           BIT1                              // Toggle-On-Overflow Bit
#define   bCH0MAX         BIT0                              // Channel 0 Maximum Duty Cycle Bit

// --------------------------------------------------------
#define rTACH0H           IOBYTE(0x26)                      // Timer A Channel 0 Register High
#define rTACH0L           IOBYTE(0x27)                      // Timer A Channel 0 Register Low
#define rTACH0            IOWORD(0x26)                      // Timer A Channel 0 Register

// --------------------------------------------------------
#define rTASC1            IOBYTE(0x28)                      // Timer A Channel 1 Status and Control Register 

#define   bCH1F           BIT7                              // Channel 1 Flag Bit
#define   bCH1IE          BIT6                              // Channel 1 Interrupt Enable Bit
#define   bMS1A           BIT4                              // Mode Select Bit A
#define   bELS1B          BIT3                              // Edge/Level Select Bits
#define   bELS1A          BIT2                              // Edge/Level Select Bits
#define   bTOV1           BIT1                              // Toggle-On-Overflow Bit
#define   bCH1MAX         BIT0                              // Channel 1 Maximum Duty Cycle Bit

// --------------------------------------------------------
#define rTACH1H           IOBYTE(0x29)                      // Timer A Channel 1 Register High
#define rTACH1L           IOBYTE(0x2A)                      // Timer A Channel 1 Register Low
#define rTACH1            IOWORD(0x29)                      // Timer A Channel 1 Register

// --------------------------------------------------------
// -----  TIMER B  ----------------------------------------                                         
// --------------------------------------------------------
#define rTBSC             IOBYTE(0x2B)                      // Timer B Status and Control Register

// bits like Timer A

// --------------------------------------------------------
#define rTBCNTH           IOBYTE(0x2C)                      // Timer B Counter Register High
#define rTBCNTL           IOBYTE(0x2D)                      // Timer B Counter Register Low

// --------------------------------------------------------
#define rTBMODH           IOBYTE(0x2E)                      // Timer B Counter Modulo Register High
#define rTBMODL           IOBYTE(0x2F)                      // Timer B Counter Modulo Register Low
#define rTBMOD            IOWORD(0x2E)                      // Timer B Counter Modulo Register 

// --------------------------------------------------------
#define rTBSC0            IOBYTE(0x30)                      // Timer B Channel 0 Status and Control Register

// bits like Timer A

// --------------------------------------------------------
#define rTBCH0H           IOBYTE(0x31)                      // Timer B Channel 0 Register High
#define rTBCH0L           IOBYTE(0x32)                      // Timer B Channel 0 Register Low
#define rTBCH0            IOWORD(0x31)                      // Timer B Channel 0 Register

// --------------------------------------------------------
#define rTBSC1            IOBYTE(0x33)                      // Timer B Channel 1 Status and Control Register 

// bits like Timer A

// --------------------------------------------------------
#define rTBCH1H           IOBYTE(0x34)                      // Timer B Channel 1 Register High
#define rTBCH1L           IOBYTE(0x35)                      // Timer B Channel 1 Register Low

// --------------------------------------------------------
// -----  ICG Internal Clock Generator   ------------------
// --------------------------------------------------------
#define rICGCR            IOBYTE(0x36)                      // ICG Control Register

#define   bCMIE           BIT7                              // Clock Monitor Interrupt Enable Bit
#define   bCMF            BIT6                              // Clock Monitor Interrupt Flag
#define   bCMON           BIT5                              // Clock Monitor On Bit
#define   bCS             BIT4                              // Clock Select Bit
#define   bICGON          BIT3                              // Internal Clock Generator On Bit
#define   bICGS           BIT2                              // Internal Clock Generator Stable Bit
#define   bECGON          BIT1                              // External Clock Generator On Bit
#define   bECGS           BIT0                              // External Clock Generator Stable Bit

// --------------------------------------------------------
#define rICGMR            IOBYTE(0x37)                      // ICG Multiplier Register

#define   bN6             BIT6                              // ICG Multiplier Factor Bits
#define   bN5             BIT5                              // ICG Multiplier Factor Bits
#define   bN4             BIT4                              // ICG Multiplier Factor Bits
#define   bN3             BIT3                              // ICG Multiplier Factor Bits
#define   bN2             BIT2                              // ICG Multiplier Factor Bits
#define   bN1             BIT1                              // ICG Multiplier Factor Bits
#define   bN0             BIT0                              // ICG Multiplier Factor Bits


// --------------------------------------------------------
#define rICGTR            IOBYTE(0x38)                      // ICG Trim Register

#define   bTRIM7          BIT7                              // ICG Trim Factor Bits
#define   bTRIM6          BIT6                              // ICG Trim Factor Bits
#define   bTRIM5          BIT5                              // ICG Trim Factor Bits
#define   bTRIM4          BIT4                              // ICG Trim Factor Bits
#define   bTRIM3          BIT3                              // ICG Trim Factor Bits
#define   bTRIM2          BIT2                              // ICG Trim Factor Bits
#define   bTRIM1          BIT1                              // ICG Trim Factor Bits
#define   bTRIM0          BIT0                              // ICG Trim Factor Bits

// --------------------------------------------------------
#define rICGDVR           IOBYTE(0x39)                      // ICG DCO Divider Register

#define   bDDIV3          BIT3                              // ICG DCO Divider Control Bits
#define   bDDIV2          BIT2                              // ICG DCO Divider Control Bits
#define   bDDIV1          BIT1                              // ICG DCO Divider Control Bits
#define   bDDIV0          BIT0                              // ICG DCO Divider Control Bits

// --------------------------------------------------------
#define rICGDSR           IOBYTE(0x3A)                      // ICG DCO Stage Register

#define   bDSTG7          BIT7                              // ICG DCO Stage Control Bits
#define   bDSTG6          BIT6                              // ICG DCO Stage Control Bits
#define   bDSTG5          BIT5                              // ICG DCO Stage Control Bits
#define   bDSTG4          BIT4                              // ICG DCO Stage Control Bits
#define   bDSTG3          BIT3                              // ICG DCO Stage Control Bits
#define   bDSTG2          BIT2                              // ICG DCO Stage Control Bits
#define   bDSTG1          BIT1                              // ICG DCO Stage Control Bits
#define   bDSTG0          BIT0                              // ICG DCO Stage Control Bits

// --------------------------------------------------------
// -----  A/D  --------------------------------------------
// --------------------------------------------------------
#define rADSCR            IOBYTE(0x3C)                      // ADC Status and Control Register

#define   bCOCO           BIT7                              // Conversions Complete Bit
#define   bAIEN           BIT6                              // ADC Interrupt Enable Bit
#define   bADCO           BIT5                              // ADC Continuous Conversion Bit
#define   bADCH4          BIT4                              // ADC Channel Select Bits
#define   bADCH3          BIT3                              // ADC Channel Select Bits
#define   bADCH2          BIT2                              // ADC Channel Select Bits
#define   bADCH1          BIT1                              // ADC Channel Select Bits
#define   bADCH0          BIT0                              // ADC Channel Select Bits


// --------------------------------------------------------
#define rADRH             IOBYTE(0x3D)                      // ADC Data Register High
#define rADRL             IOBYTE(0x3E)                      // ADC Data Register Low
#define rADR              IOWORD(0x3D)                      // ADC Data Register High:Low

// --------------------------------------------------------
#define rADICLK           IOBYTE(0x3F)                      // ADC Clock Register

#define   bADIV2          BIT7                              // ADC Clock Prescaler Bits
#define   bADIV1          BIT6                              // ADC Clock Prescaler Bits
#define   bADIV0          BIT5                              // ADC Clock Prescaler Bits
#define   bADICLK         BIT4                              // ADC Clock Prescaler Bits
#define   bMODE1          BIT3                              // Modes of Result Justification Bits
#define   bMODE0          BIT2                              // MODE1:MODE0 00 = 8-bit truncation mode, 01 = Right justified mode, 10 = Left justified mode, 11 = Left justified sign data mode




// --------------------------------------------------------
// registers located between 0x0040 - 0xFFFF
// --------------------------------------------------------


// -----  SIM  --------------------------------------------
#define rSBSR       IOBYTE(0xFE00)                          // SIM break status register 
#define rSRSR       IOBYTE(0xFE01)                          // SIM reset status register 
#define rSBFCR      IOBYTE(0xFE03)                          // SIM break control register 
  
// -----  FLASH  ------------------------------------------
#define rFLTCR      IOBYTE(0xFE07)                          // Flash test control register 

#define rFLCR       IOBYTE(0xFE08)                          // Flash control register 
#define   bFDIV1    BIT7
#define   bFDIV0    BIT6
#define   bBLK1     BIT5
#define   bBLK0     BIT4
#define   bHVEN     BIT3
#define   bMARGIN   BIT2
#define   bERASE    BIT1
#define   bPGM      BIT0
                                                            
// -----  BREAK ADRESS  -----------------------------------
#define rBRKH       IOBYTE(0xFE0C)                          // Break adress register high 
#define rBRKL       IOBYTE(0xFE0D)                          // Break adress register low 
#define rBRK        IOWORD(0xFE0C)                          // Break adress register 

// -----  FLASH PROTECT  ----------------------------------
#define rFLBPR      IOBYTE(0xFFE0)                          // Flash block protect register
#define   bBPR3     BIT3
#define   bBPR2     BIT2
#define   bBPR1     BIT1
#define   bBPR0     BIT0
                         

// -----  COP  --------------------------------------------
#define rCOPCTL     IOBYTE(0xFFFF))                         // COP control register 




// --------------------------------------------------------
// Trim & calibration values located between 0xFD80 - 0xFDFF
// this only applies to MM908E621, 622, 624, 625, 626
// --------------------------------------------------------

// --------------------------------------------------------
#define	trimICGTR    IOBYTE(0xFDC2)	                        // Trim Value for ICG (@5V room)

#if defined(MM908E622)

#define	trimSYSTRIM1 IOBYTE(0xFDC4)	                        // Trim Value for SYSTRIM1 register (SPI)
#define	trimSYSTRIM2 IOBYTE(0xFDC5)	                        // Trim Value for SYSTRIM1 register (SPI)
#define	trimSYSTRIM3 IOBYTE(0xFDC6)	                        // Trim Value for SYSTRIM1 register (SPI)
#define trimAWD      IOBYTE(0xFDCF)	                        // Trim Value for Watchdog Period range

#endif

#endif // defined 908EY16_IO_H









