// ========================================================
//  Copyright (c)2005 Freescale Semiconductor Inc
//  All Rights Reserved
//
//  The code is the property of Freescale GmbH Munich
//  TSPG-APD-IDC Intelligent Distributed Control Operation
//
//  The copyright notice above does not evidence any
//  actual or intended publication of such source code.
//
//  This software is provided by Freescale "AS IS" and any
//  expressed or implied warrenties, including, but not 
//  limited to, the implied warrenties of merchantability
//  and fitness for a particular purpose are disclaimed.
//  In no event shall Freescale or its contributors be 
//  liable for any direct, indirect, incidental, special,
//  examplary, or consequential damages (including, but not 
//  limited to, procurement of substitue goods or services;
//  loss of use, data, or profits; or business interruption)
//  However caused and on any theory of liability, whether 
//  in contract, strict liability, or tort (including 
//  negligence or otherwise) arising in any way out of the 
//  use of this software, even if advised of the possibility
//  of such damage.
// 
//
//
//  Filename:     $Source: D:/home/r51406/___CVS/CVS_Server2/MM908Exxx/908EY16_FLASH.h,v $
//  Author:       $Author: r51406 $
//  Locker:       $Locker:  $
//  State:        $State: Exp $
//  Revision:     $Revision: 1.3 $
//
//  Functions:    
//
//  History:      Use the CVS command log to display 
//                revision history information.
//
//  Description:  FLASH program erase Routines
//								for AdrenaLIN 68HC908EY16 MCU
//
//
//  Notes:        
//
//
//
// ========================================================
#ifndef _908EY16_FLASH_H
#define _908EY16_FLASH_H


//---------------------------------------------------------
struct tFlashInterface {
  UINT8  CtrlByte;              // 0x48
  UINT8  CPUSpeed;              // 0x49
  UINT16 LastAddr;              // 0x4A..0x4B
  UINT8  Data[32];              // 0x4C..0x6B
}; 
//---------------------------------------------------------
#define Flash_DataPointer       0x4C

BOOLEAN Flash_ProgByte(UINT16 dstadr, UINT8 len); 
BOOLEAN Flash_ProgRow(UINT16 adress, UINT8 *values);
void    Flash_ErasePage(UINT16 adress);


#define FLASH_PAGESIZE        64                            // erase   access for Flash is "page wise"
#define FLASH_ROWSIZE         32                            // program access for Flash is "row wise"
#define CPU_SPEED             5                             // MHz bus frequency
#define FLASH_ERASE_DELAY     (100000u/24u)                 // erase delay time in us/24 (100ms)

// -----  Embedded Program/Erase Routines (Flash)  --------
// Location of Routines
#define ROMSTART              0x1000
#define RDVRRNG               (ROMSTART + 3)                // Read/verify a range
#define PRGRNGE               (ROMSTART + 9)                // Program a range of FLASH
#define ERARNGE               (ROMSTART + 6)                // Erase a range of FLASH

// Global Variable
/*
#define RAMSTART              0x0040
#define frCTRLBYT             IOBYTE(RAMSTART+8)
#define frCPUSPD              IOBYTE(RAMSTART+9)
#define frLADDR               IOWORD(RAMSTART+10)
#define frDATA(x)             (IOBYTE(RAMSTART+12+x))
*/




#endif  //  _908EY16_FLASH_H