// ========================================================
//  Copyright (c)2005 Freescale Semiconductor Inc
//  All Rights Reserved
//
//  The code is the property of Freescale GmbH Munich
//  TSPG-APD-IDC Intelligent Distributed Control Operation
//
//  The copyright notice above does not evidence any
//  actual or intended publication of such source code.
//
//  This software is provided by Freescale "AS IS" and any
//  expressed or implied warrenties, including, but not 
//  limited to, the implied warrenties of merchantability
//  and fitness for a particular purpose are disclaimed.
//  In no event shall Freescale or its contributors be 
//  liable for any direct, indirect, incidental, special,
//  examplary, or consequential damages (including, but not 
//  limited to, procurement of substitue goods or services;
//  loss of use, data, or profits; or business interruption)
//  However caused and on any theory of liability, whether 
//  in contract, strict liability, or tort (including 
//  negligence or otherwise) arising in any way out of the 
//  use of this software, even if advised of the possibility
//  of such damage.
// 
//
//
//  Filename:     $Source: D:/home/r51406/___CVS/CVS_Server2/MM908Exxx/908EY16_ADC.h,v $
//  Author:       $Author: r51406 $
//  Locker:       $Locker:  $
//  State:        $State: Exp $
//  Revision:     $Revision: 1.3 $
//
//  Functions:    
//
//  History:      Use the CVS command log to display 
//                revision history information.
//
//  Description:  ADC support routines
//
//
//
//  Notes:        
//
//
//
// ========================================================

#ifndef  _908EY16_ADC_H
#define  _908EY16_ADC_H

// --------------------------------------------------------
// includes
// --------------------------------------------------------
#include "Types.h"
#include "Hicross.h"

// --------------------------------------------------------
// defines
// --------------------------------------------------------
// --------------------------------------------------------
// adc channel list microcontroller
#define  ADC_CHANNEL_PTB0       (0)
#define  ADC_CHANNEL_PTB1       (                            bADCH0)
#define  ADC_CHANNEL_PTB2       (                     bADCH1       )
#define  ADC_CHANNEL_PTB3       (                     bADCH1|bADCH0)
#define  ADC_CHANNEL_PTB4       (              bADCH2              )
#define  ADC_CHANNEL_PTB5       (              bADCH2|       bADCH0)
#define  ADC_CHANNEL_PTB6       (              bADCH2|bADCH1       )
#define  ADC_CHANNEL_PTB7       (              bADCH2|bADCH1|bADCH0)
#define  ADC_CHANNEL_VREFH      (bADCH4|bADCH3|bADCH2|       bADCH0)
#define  ADC_CHANNEL_VREFL      (bADCH4|bADCH3|bADCH2|bADCH1       )
#define  ADC_CHANNEL_OFF        (bADCH4|bADCH3|bADCH2|bADCH1|bADCH0)

// --------------------------------------------------------
// adc clock divider list
#define ADC_DIV_1               (0)
#define ADC_DIV_2               (              bADIV0)
#define ADC_DIV_4               (       bADIV1       )
#define ADC_DIV_8               (       bADIV1|bADIV0)
#define ADC_DIV_16              (bADIV2              )

// --------------------------------------------------------
// properties (public)
// --------------------------------------------------------

// --------------------------------------------------------
// methodes published
// --------------------------------------------------------
void ADC_Init(void);                                        // ADC initialisation  8bit trunc
void ADC_Init10(void);                                      // ADC initialisation 10bit right
UINT8 ADC_Value(UINT8 channel);                             // Convert given Channel  8bit
volatile UINT16 *ADC_Value10(UINT8 channel);                // Convert given Channel 10bit
void ADC_PowerOff(void);                                    // ADC low power mode





#endif // _908EY16_ADC_H