// ========================================================
//  Copyright (c)2005 Freescale Semiconductor Inc
//  All Rights Reserved
//
//  The code is the property of Freescale GmbH Munich
//  TSPG-APD-IDC Intelligent Distributed Control Operation
//
//  The copyright notice above does not evidence any
//  actual or intended publication of such source code.
//
//  This software is provided by Freescale "AS IS" and any
//  expressed or implied warrenties, including, but not 
//  limited to, the implied warrenties of merchantability
//  and fitness for a particular purpose are disclaimed.
//  In no event shall Freescale or its contributors be 
//  liable for any direct, indirect, incidental, special,
//  examplary, or consequential damages (including, but not 
//  limited to, procurement of substitue goods or services;
//  loss of use, data, or profits; or business interruption)
//  However caused and on any theory of liability, whether 
//  in contract, strict liability, or tort (including 
//  negligence or otherwise) arising in any way out of the 
//  use of this software, even if advised of the possibility
//  of such damage.
// 
//
//
//  Filename:     $Source: D:/home/r51406/___CVS/CVS_Server2/MM908Exxx/908EY16_ADC.c,v $
//  Author:       $Author: r51406 $
//  Locker:       $Locker:  $
//  State:        $State: Exp $
//  Revision:     $Revision: 1.2 $
//
//  Functions:    
//
//  History:      Use the CVS command log to display 
//                revision history information.
//
//  Description:  ADC support routines
//								for 908EY16
//
//
//  Notes:        uses SPI routines and SPI registers on SMOS chip
//
//
//
// ========================================================
#define _908EY16_ADC_C

#include "ChipSets.h"



// --------------------------------------------------------
// Properties (public)
// --------------------------------------------------------

// --------------------------------------------------------
// Properties (private)
// --------------------------------------------------------


// -------------------------------------------------------
void ADC_Init(void)  {                                      // Initialize ADC

  rADICLK= ADC_DIV_8 | bADICLK;                             // Set ADICLK to Busfreq/8 (ca. 0.6MHz), 
                                                            // Mode = 8-bit truncation mode
}
// -------------------------------------------------------
void ADC_Init10(void)  {                                    // Initialize ADC 

  rADICLK= ADC_DIV_8 | bADICLK| bMODE0;                     // Set ADICLK to Busfreq/8 (ca. 0.6MHz),
                                                            // Mode = 10-bit right justified mode
}
// -------------------------------------------------------
void ADC_PowerOff(void)  {

  rADSCR = bADCH4|bADCH3|bADCH2|bADCH1|bADCH0;              // ADC power off
  
  // ----------------------------
  // ADOUT
  // ----------------------------
  // PTB0/AD0
//  rDDRB  &= ~bDDRB0;                                        // input

//  __ADC_DDR &= ~__ADC_PIN;                                  // input
}

// --------------------------------------------------------
UINT8 ADC_Value(UINT8 channel)  {
  
  rADSCR = channel;                                         // select channel and start conversion  
  while(!(rADSCR&bCOCO));                                   // wait till Conversion Complete                                
  return rADRL;                                             // Mode = 8-bit truncation mode
}

// --------------------------------------------------------
volatile UINT16 *ADC_Value10(UINT8 channel)  {
  
  rADSCR = channel;                                         // select channel and start conversion  
  while(!(rADSCR&bCOCO));                                   // wait till Conversion Complete                                
  return (&rADR);                                  // Mode = 10-bit right mode
}

