// ========================================================
//  Copyright (c)2005 Freescale Semiconductor Inc
//  All Rights Reserved
//
//  The code is the property of Freescale GmbH Munich
//  TSPG-APD-IDC Intelligent Distributed Control Operation
//
//  The copyright notice above does not evidence any
//  actual or intended publication of such source code.
//
//  This software is provided by Freescale "AS IS" and any
//  expressed or implied warrenties, including, but not 
//  limited to, the implied warrenties of merchantability
//  and fitness for a particular purpose are disclaimed.
//  In no event shall Freescale or its contributors be 
//  liable for any direct, indirect, incidental, special,
//  examplary, or consequential damages (including, but not 
//  limited to, procurement of substitue goods or services;
//  loss of use, data, or profits; or business interruption)
//  However caused and on any theory of liability, whether 
//  in contract, strict liability, or tort (including 
//  negligence or otherwise) arising in any way out of the 
//  use of this software, even if advised of the possibility
//  of such damage.
// 
//
//
//  Filename:     $Source$
//  Author:       $Author$
//  Locker:       $Locker$
//  State:        $State$
//  Revision:     $Revision$
//
//  Functions:    
//
//  History:      Use the CVS command log to display 
//                revision history information.
//
//  Description:  LIN driver configuration file
//								
//
//
//  Notes:        
//
//
//
// ========================================================
#if !defined (LGEN_H)
#define  LGEN_H

// -----  Configuration Constants  ------------------------
#define LIN_IDLETIMEOUT             2604ul                  // 25000 T_Bit = 2604ms (Timer intervall 1ms)
#define LIN_BAUDRATE                0x00u                   // 19200 Baud with baurate synchronisation
#define LIN_SCIPRESCALERDIVISOR			4.0											// divide by 4  (4,9152MHz)
#define LIN_SYNC_SLAVE

#define LIN_ESCICLOCK               1                      // 1 times bus clock (in CONFIG2 - bit ESCIBDSRC=1)   
//#define LIN_ESCICLOCK               4                       // 4 times bus clock (in CONFIG2 - bit ESCIBDSRC=0)   

#define USEDELIMITERWORKAROUND                              // see errata (only EY16, fixed on EY16A)



// -----  Macros  -----------------------------------------
#define cmdSleep      0x00

#define SysMasterRequest_Sleep()   (l_u8_rd_SysCmd()==cmdSleep)   // first data byte 0 -> sleep


// -----  Frame Buffers  ----------------------------------
#define frmSysMasterRequest         LINBuffer3C
#define frmSysSlaveResponse         LINBuffer3D

// -----  Received Signals  -------------------------------
// frmSysMasterRequest
#define l_u8_rd_SysCmd()            ((l_u8) (frmSysMasterRequest[7]))
#define l_u8_rd_SysNodeID()         ((l_u8) (frmSysMasterRequest[6]))
#define l_u8_rd_SysAdr()            ((l_u8) (frmSysMasterRequest[5]))
#define l_u8_rd_SysData0()          ((l_u8) (frmSysMasterRequest[4]))

#define l_u16_rd_SysAdr()           ((l_u16)((*(l_u16*)&frmSysMasterRequest[4])))


#define l_u8_rd_SysNAD()            ((l_u8) (frmSysMasterRequest[7]))
#define l_u8_rd_SysCMD()            ((l_u8) (frmSysMasterRequest[6]))
#define l_u8_rd_SysM0()             ((l_u8) (frmSysMasterRequest[5]))
#define l_u8_rd_SysM1()             ((l_u8) (frmSysMasterRequest[4]))
#define l_u8_rd_SysM2()             ((l_u8) (frmSysMasterRequest[3]))
#define l_u8_rd_SysM3()             ((l_u8) (frmSysMasterRequest[2]))
#define l_u8_rd_SysM4()             ((l_u8) (frmSysMasterRequest[1]))
#define l_u8_rd_SysM5()             ((l_u8) (frmSysMasterRequest[0]))

#define l_u16_rd_SysM01()           ((l_u16)((*(l_u16*)&frmSysMasterRequest[4])))
#define l_u16_rd_SysM23()           ((l_u16)((*(l_u16*)&frmSysMasterRequest[2])))
#define l_u16_rd_SysM45()           ((l_u16)((*(l_u16*)&frmSysMasterRequest[0])))





// -----  Transmitted Signals  ----------------------------
// frmSysSlaveResponse
#define SysResponseMsgIdx           1

#define l_u8_wr_SysCmd(v)           frmSysSlaveResponse[7] = ((l_u8)(v))
#define l_u8_wr_SysNodeID(v)        frmSysSlaveResponse[6] = ((l_u8)(v))
#define l_u8_wr_SysAdr(v)           frmSysSlaveResponse[5] = ((l_u8)(v))

#define l_u16_wr_SysAdr(v)          *((l_u16 *)&frmSysSlaveResponse[4]) = ((l_u16)(v))

#define l_u8_wr_SysData0(v)         frmSysSlaveResponse[4] = ((l_u8)(v)) 

#define l_u8_wr_SysData1(v)         frmSysSlaveResponse[3] = ((l_u8)(v)) 
#define l_u8_wr_SysData2(v)         frmSysSlaveResponse[2] = ((l_u8)(v)) 
#define l_u8_wr_SysData3(v)         frmSysSlaveResponse[1] = ((l_u8)(v)) 
#define l_u8_wr_SysData4(v)         frmSysSlaveResponse[0] = ((l_u8)(v)) 
//#define l_tx_SysSR_Ready            LinMsgStatus[2] = LIN_MSG_UPDATED

#define l_u8_wr_SysNAD(v)           frmSysSlaveResponse[7] = ((l_u8)(v))
#define l_u8_wr_SysCMD(v)           frmSysSlaveResponse[6] = ((l_u8)(v))
#define l_u8_wr_SysS0(v)            frmSysSlaveResponse[5] = ((l_u8)(v))
#define l_u8_wr_SysS1(v)            frmSysSlaveResponse[4] = ((l_u8)(v))
#define l_u8_wr_SysS2(v)            frmSysSlaveResponse[3] = ((l_u8)(v))
#define l_u8_wr_SysS3(v)            frmSysSlaveResponse[2] = ((l_u8)(v))
#define l_u8_wr_SysS4(v)            frmSysSlaveResponse[1] = ((l_u8)(v))
#define l_u8_wr_SysS5(v)            frmSysSlaveResponse[0] = ((l_u8)(v))

#define l_u16_wr_SysS01(v)          *((l_u16 *)&frmSysSlaveResponse[4]) = ((l_u16)(v))
#define l_u16_wr_SysS23(v)          *((l_u16 *)&frmSysSlaveResponse[2]) = ((l_u16)(v))
#define l_u16_wr_SysS45(v)          *((l_u16 *)&frmSysSlaveResponse[0]) = ((l_u16)(v))




// -----  Test Flags  -------------------------------------
#define l_u8_tst_SysCmd()           ((l_bool) (LinSigFlags[0]&0x01))

// -----  Clear Flags  ------------------------------------
#define l_u8_clr_SysCmd()           LinSigFlags[0] &= ~0x01

// -----  Common API  -------------------------------------
#define l_ifc_init_sci08()          l_ifc_init_sci0()
#define l_ifc_connect_sci08()       l_ifc_connect_sci0()
#define l_ifc_disconnect_sci08()    l_ifc_disconnect_sci0()
#define l_ifc_rx_sci08()            l_ifc_rx_sci0()
#define l_ifc_ioctl_sci08( op, pv ) l_ifc_ioctl_sci0( op, pv )

// -----  Extern Buffer Reference  ------------------------
extern l_u8 LINBuffer3C[];    // frmSysCommandRx    
extern l_u8 LINBuffer3D[];    // frmSysCommandTx

// -----  Extern Message Status List Reference  -----------
extern l_u8 LinMsgStatus[];

// -----  Extern LIN_SigFlags Reference  ------------------
extern l_u8 LinSigFlags[];

#endif // !defined (LGEN_H) 
