#define LININIT_C

/******************************************************************************
*                                                       
*       Copyright (C) 2005 Freescale Semiconductor, Inc.
*       All Rights Reserved								              
*														                            
* Filename:     lininit.c                
*														                            
* Revision:      										                    
*														                            
* Functions:    LIN Driver initialization 
*												                            
* Description:  
*												                            
******************************************************************************/

#include <linbase.h>

#if defined(LIN_DBG_CHECK_INTERNAL_ERROR)

LIN_BYTE    LIN_InternalError;           /* Internal error code */

#endif /* defined(LIN_DBG_CHECK_INTERNAL_ERROR) */

/* Cosmic compiler startup routine is declared via _asm xref,
   because C symbols are undefined in Cosmic inline assembler expressions */


#if defined(LINAPI_1_0)

/***************************************************************************
 * Function :   l_sys_init
 *
 * Description: Initialise driver 
 * 
 * Returns:     Always returns 0
 *
 * Notes:       LIN API service call
 *
 **************************************************************************/
l_bool l_sys_init ( void )
{    
    LIN_BYTE    i;
    LIN_BYTE    intMask;

    LIN_DBG_SET_PORT_7;

    intMask = LIN_DisableInt();     /* disable interrupts */

    /* Set initial state -- this is abort any activity, interface is disconnected */
    LIN_StateFlags  = LIN_FLAG_NOINIT | LIN_FLAG_DISCONNECT | LIN_FLAG_IGNORE;

    /* Initialize Error Counters */
    LIN_ErrTxCounter = 0;
    LIN_ErrRxCounter = 0;

    /* Initialize all signal flags with 0 */
    for( i = 0; i <= LinSigMaxIdx; i++ )
    {
        LinSigFlags[i] = 0;
    }

    /*init the global variable with the user configured prescaler divisor*/
    LIN_SynchPrescalerDivisor = LIN_CfgConst.LIN_SciPreScaler;
    
    /* Initialize transmitted messages with NO_DATA */
    /* NB: now -- for all transmitted and received messages -- OPTIM */
    for( i = 0; i < LinListSize; i++ )
    {
        LinMsgStatus[i] = LIN_MSG_NODATA;   /* Set NODATA */
    }

    /* Set idle timeout if it has not set yet */
    LIN_SetIdleTimeout();               

    /* Debug initializing */
#if defined(LIN_DBG_CHECK_INTERNAL_ERROR)
    LIN_InternalError = LIN_ERROR_0;
#endif /* defined(LIN_DBG_CHECK_INTERNAL_ERROR) */
    LIN_DBG_INIT_PORT(0x00);

    LIN_EnableInt(intMask);     /* enable interrupts */

    LIN_DBG_CLR_PORT_7;

    return 0;
} 

#else /* !defined(LINAPI_1_0) */

/***************************************************************************
 * Function :   LIN_Init
 *
 * Description: Initialise driver - software & hardware
 * 
 * Returns:     none
 *
 * Notes:       Freescale API service call
 *
 **************************************************************************/
void  LIN_Init ( void )
{    
    LIN_BYTE    i;
    LIN_BYTE    intMask;

    LIN_DBG_SET_PORT_7;

    intMask = LIN_DisableInt();     /* disable interrupts */

    /* Set initial state -- this is abort any activity */
    LIN_StateFlags  = LIN_FLAG_IGNORE;

    /* Initialize Error Counters */
    LIN_ErrTxCounter = 0;
    LIN_ErrRxCounter = 0;

    /* Initialize messages with NO_DATA */
    for( i = 0; i < LinListSize; i++ )
    {
        LinMsgStatus[i] = LIN_MSG_NODATA;   /* Set NO_DATA */
    }

    /*init the global variable with the user configured prescaler divisor*/
    LIN_SynchPrescalerDivisor = LIN_CfgConst.LIN_SciPreScaler;

    /* Initialize SCI for LIN */
    LIN_SCIInit();

    /* Set idle timeout if it has not set yet */
    LIN_SetIdleTimeout();               

    /* Debug initializing */
#if defined(LIN_DBG_CHECK_INTERNAL_ERROR)
    LIN_InternalError = LIN_ERROR_0;
#endif /* defined(LIN_DBG_CHECK_INTERNAL_ERROR) */
    LIN_DBG_INIT_PORT(0x00);

    LIN_EnableInt(intMask);     /* enable interrupts */

    LIN_DBG_CLR_PORT_7;
} 


/***************************************************************************
 * Function :   LIN_DisableInt
 *
 * Description: disable interrupts 
 * 
 * Returns:     Interrupt state 
 *
 * Notes:       only for Freescale API
 *              
 **************************************************************************/
#if defined(CW08)
#pragma OPTION ADD handle_register "-Or"
#endif /* defined(CW08) */

LIN_BYTE LIN_DisableInt( void )
{
#if defined(CW08)
    { 
        asm tpa; 
        asm sei; 
    }    
#endif /* defined(CW08)*/
#if defined(COSMIC08)
#asm
    tpa
    sei     
#endasm 
#endif /* defined(COSMIC08)*/

}

#if defined(CW08)
#pragma OPTION DEL handle_register 
#endif /* defined(CW08) */


/***************************************************************************
 * Function :   LIN_EnableInt
 *
 * Description: enable interrupts
 * 
 * Returns:     
 *
 * Notes:       only for Freescale API
 *              
 **************************************************************************/
#if defined(CW08)
#pragma OPTION ADD handle_register "-Or"
#endif /* defined(CW08) */

void LIN_EnableInt( LIN_BYTE mask)
{

#if defined(CW08)
    { 
        asm tap;
    }
#endif /* defined(CW08)*/
#if defined(COSMIC08)
    _asm("tap\n", mask );
#endif /* defined(COSMIC08) */

}

#if defined(CW08)
#pragma OPTION DEL handle_register
#endif /* defined(CW08) */



#endif /* !defined(LINAPI_1_0) */
