#define LINCFG_C
/******************************************************************************
*                                                       
*       Copyright (C) 2005 Freescale Semiconductor, Inc.
*       All Rights Reserved								              
*														                            
* Filename:     lincfg.c                
*														                            
* Revision:      										                    
*														                            
* Functions:    LIN Driver internal configuration
*												                            
* Description:  
*												                            
******************************************************************************/

#include <linapi.h>

/********************************************************************************************/
/********************************************************************************************/
/**     Driver hardware configuration                                                      **/
/********************************************************************************************/
/********************************************************************************************/



#if defined(HC08EY16)
/********************************************************************************************/
/* HC908EY16                                                                                 */
/********************************************************************************************/
#if defined (LIN_SYNC_SLAVE)
/* check whether the prescaler is in range. The LIN spec v1.3 specify an oscillator tolerance of
   +/- 15%. In order to handle this tolerance the prescaler has to be in following range:*/
#if (!((LIN_SCIPRESCALERDIVISOR >= 2.375) & (LIN_SCIPRESCALERDIVISOR <= 7.78125)))
#warning "The ESCI prescaler divisor is out of range. Therefore the prescaler divisor will be set to 3"
#undef  LIN_SCIPRESCALERDIVISOR
#define LIN_SCIPRESCALERDIVISOR        3
#endif /* (!((LIN_SCIPRESCALERDIVISOR >= 2.375) & (LIN_SCIPRESCALERDIVISOR <= 7.78125))) */

/* Compute the prescaler value which is used during receiving the synch byte
   This prescaler value is 6% higher than the LIN_SCIPRESCALERDIVISOR
   This is the workaround for the missing break delimiter*/
#define LIN_INCREASEDBAUDRATESYNC      6.0		   /* define the percent how much the prescaler shall be increased*/
#define LIN_SCIPRESCALERSYNC   (unsigned char)((LIN_SCIPRESCALERDIVISOR*((100.0-LIN_INCREASEDBAUDRATESYNC)/100.0)-1.0)*32.0)
#else
#define LIN_SCIPRESCALERSYNC  LIN_SCIPRESCALERDIVISOR
#endif /* defined (LIN_SYNC_SLAVE) */    


/* compute ESCI Prescaler sync*/
/* LIN baud rate masks */
#define LIN_BAUDRATE_MASK   0x37u

const struct
{
    unsigned int    LIN_IdleTimeoutClocks;  /* number of LIN_IdleClock() calls per LIN idle timeout */
    unsigned char   LIN_BaudRate;           /* LIN baud rate setting */
    unsigned char   LIN_SciPreScaler;       /* default SCI Prescaler value */
    unsigned char   LIN_SciSyncPreScaler;   /* SCI Prescaler value during sync - workaround for the delemiter problem*/
    unsigned char   LIN_SyncEnable;         /* Synchronization static flag */
    unsigned char   LIN_BaudRateDivisor;    /* BaudRate divisor for sync formula */
    
} LIN_CfgConst =
{
    LIN_IDLETIMEOUT,
    (LIN_BAUDRATE & LIN_BAUDRATE_MASK),
    ((LIN_SCIPRESCALERDIVISOR - 1) * 32),
    LIN_SCIPRESCALERSYNC,
#if defined (LIN_SYNC_SLAVE)
    1,
#else
    0,
#endif /* defined (LIN_SYNC_SLAVE) */ 
#if (LIN_BAUDRATE & LIN_BAUDRATE_MASK) == 0x00
    1,
#elif (LIN_BAUDRATE & LIN_BAUDRATE_MASK) == 0x01
    2,
#elif (LIN_BAUDRATE & LIN_BAUDRATE_MASK) == 0x02
    4,
#elif (LIN_BAUDRATE & LIN_BAUDRATE_MASK) == 0x03
    8,
#elif (LIN_BAUDRATE & LIN_BAUDRATE_MASK) == 0x04
    16,
#elif (LIN_BAUDRATE & LIN_BAUDRATE_MASK) == 0x05
    32,
#elif (LIN_BAUDRATE & LIN_BAUDRATE_MASK) == 0x06
    64,
#elif (LIN_BAUDRATE & LIN_BAUDRATE_MASK) == 0x07
    128,

#elif (LIN_BAUDRATE & LIN_BAUDRATE_MASK) == 0x10
    3,
#elif (LIN_BAUDRATE & LIN_BAUDRATE_MASK) == 0x11
    6,
#elif (LIN_BAUDRATE & LIN_BAUDRATE_MASK) == 0x12
    12,
#elif (LIN_BAUDRATE & LIN_BAUDRATE_MASK) == 0x13
    24,
#elif (LIN_BAUDRATE & LIN_BAUDRATE_MASK) == 0x14
    48,
#elif (LIN_BAUDRATE & LIN_BAUDRATE_MASK) == 0x15
    96,
#elif (LIN_BAUDRATE & LIN_BAUDRATE_MASK) == 0x16
    192,
#elif (LIN_BAUDRATE & LIN_BAUDRATE_MASK) == 0x17
    384,

#elif (LIN_BAUDRATE & LIN_BAUDRATE_MASK) == 0x20
    4,
#elif (LIN_BAUDRATE & LIN_BAUDRATE_MASK) == 0x21
    8,
#elif (LIN_BAUDRATE & LIN_BAUDRATE_MASK) == 0x22
    16,
#elif (LIN_BAUDRATE & LIN_BAUDRATE_MASK) == 0x23
    32,
#elif (LIN_BAUDRATE & LIN_BAUDRATE_MASK) == 0x24
    64,
#elif (LIN_BAUDRATE & LIN_BAUDRATE_MASK) == 0x25
    128,
#elif (LIN_BAUDRATE & LIN_BAUDRATE_MASK) == 0x26
    256,
#elif (LIN_BAUDRATE & LIN_BAUDRATE_MASK) == 0x27
    512,

#elif (LIN_BAUDRATE & LIN_BAUDRATE_MASK) == 0x30
    13,
#elif (LIN_BAUDRATE & LIN_BAUDRATE_MASK) == 0x31
    26,
#elif (LIN_BAUDRATE & LIN_BAUDRATE_MASK) == 0x32
    52,
#elif (LIN_BAUDRATE & LIN_BAUDRATE_MASK) == 0x33
    104,
#elif (LIN_BAUDRATE & LIN_BAUDRATE_MASK) == 0x34
    208,
#elif (LIN_BAUDRATE & LIN_BAUDRATE_MASK) == 0x35
    416,
#elif (LIN_BAUDRATE & LIN_BAUDRATE_MASK) == 0x36
    832,
#elif (LIN_BAUDRATE & LIN_BAUDRATE_MASK) == 0x37
    1664,
#endif /*(LIN_BAUDRATE & LIN_BAUDRATE_MASK) == 0x00*/
};
#endif /* defined(HC08EY16) */



