#ifndef LINDBG_H
#define LINDBG_H
/******************************************************************************
*                                                       
*       Copyright (C) 2005 Freescale Semiconductor, Inc.
*       All Rights Reserved								              
*														                            
* Filename:     lindbg.h                
*														                            
* Revision:      										                    
*														                            
* Functions:    Debug routins header file
*														                            
* Description:
*														                            
* Notes:        
*														                            
******************************************************************************/


#define LIN_DBG_BIT_0           0x01
#define LIN_DBG_BIT_1           0x02
#define LIN_DBG_BIT_2           0x04
#define LIN_DBG_BIT_3           0x08
#define LIN_DBG_BIT_4           0x10
#define LIN_DBG_BIT_5           0x20
#define LIN_DBG_BIT_6           0x40
#define LIN_DBG_BIT_7           0x80

#if defined(LINDEBUG)

#define LIN_DBG_INIT_PORT(val) LIN_PTB = (val); LIN_DDRB =  0xff 
#define LIN_DBG_SET_PORT_0 ( LIN_PTB |= LIN_DBG_BIT_0  )
#define LIN_DBG_SET_PORT_1 ( LIN_PTB |= LIN_DBG_BIT_1  )
#define LIN_DBG_SET_PORT_2 ( LIN_PTB |= LIN_DBG_BIT_2  )
#define LIN_DBG_SET_PORT_3 ( LIN_PTB |= LIN_DBG_BIT_3  )
#define LIN_DBG_SET_PORT_4 ( LIN_PTB |= LIN_DBG_BIT_4  )
#define LIN_DBG_SET_PORT_5 ( LIN_PTB |= LIN_DBG_BIT_5  )
#define LIN_DBG_SET_PORT_6 ( LIN_PTB |= LIN_DBG_BIT_6  )
#define LIN_DBG_SET_PORT_7 ( LIN_PTB |= LIN_DBG_BIT_7  )
#define LIN_DBG_CLR_PORT_0 ( LIN_PTB &= ~LIN_DBG_BIT_0 )
#define LIN_DBG_CLR_PORT_1 ( LIN_PTB &= ~LIN_DBG_BIT_1 )
#define LIN_DBG_CLR_PORT_2 ( LIN_PTB &= ~LIN_DBG_BIT_2 )
#define LIN_DBG_CLR_PORT_3 ( LIN_PTB &= ~LIN_DBG_BIT_3 )
#define LIN_DBG_CLR_PORT_4 ( LIN_PTB &= ~LIN_DBG_BIT_4 )
#define LIN_DBG_CLR_PORT_5 ( LIN_PTB &= ~LIN_DBG_BIT_5 )
#define LIN_DBG_CLR_PORT_6 ( LIN_PTB &= ~LIN_DBG_BIT_6 )
#define LIN_DBG_CLR_PORT_7 ( LIN_PTB &= ~LIN_DBG_BIT_7 )

#else

#define LIN_DBG_INIT_PORT(val)
#define LIN_DBG_SET_PORT_0 
#define LIN_DBG_SET_PORT_1 
#define LIN_DBG_SET_PORT_2 
#define LIN_DBG_SET_PORT_3 
#define LIN_DBG_SET_PORT_4 
#define LIN_DBG_SET_PORT_5 
#define LIN_DBG_SET_PORT_6 
#define LIN_DBG_SET_PORT_7 
#define LIN_DBG_CLR_PORT_0 
#define LIN_DBG_CLR_PORT_1 
#define LIN_DBG_CLR_PORT_2 
#define LIN_DBG_CLR_PORT_3 
#define LIN_DBG_CLR_PORT_4 
#define LIN_DBG_CLR_PORT_5 
#define LIN_DBG_CLR_PORT_6 
#define LIN_DBG_CLR_PORT_7 

#endif /* defined(LINDEBUG) */

/****************************************************************************/
/* Additional defines applied due properly equipment lack and test purpose  */
/****************************************************************************/

#if  defined(LINDEBUG)

                                /* additional internal error check  */
#define LIN_DBG_CHECK_INTERNAL_ERROR  

                                /* honest stete machine (run throw all states in LIN_State) */
                                /* if undefinedexlude transit states  */
#define LIN_DBG_FULL_STATES  
                                /* Receive 11bit time break symbol if undefined- receive 10 bit */

#else

#undef  LIN_DBG_CHECK_INTERNAL_ERROR  
#undef  LIN_DBG_FULL_STATES  

#endif /* defined(LINDEBUG) */

#if defined(LIN_DBG_CHECK_INTERNAL_ERROR)

#define     LIN_ERROR_0     0x00

#define     LIN_ERROR_1     0x01
#define     LIN_ERROR_2     0x02
#define     LIN_ERROR_3     0x03
#define     LIN_ERROR_4     0x04
#define     LIN_ERROR_5     0x05
#define     LIN_ERROR_6     0x06
#define     LIN_ERROR_7     0x07
#define     LIN_ERROR_8     0x08

/* Insert new error identifier above this line */
/* and don`t use error identifier more then one times */

extern  LIN_BYTE    LIN_InternalError;

#endif /* defined(LIN_DBG_CHECK_INTERNAL_ERROR) */

#endif /* !define (LINDBG_H) */
