#define VECTOR_C
/******************************************************************************
*                                                                     
*       Copyright (C) 2005 Freescale Semiconductor, Inc.              
*       All Rights Reserved								              
*														              
* Filename:     vector.c                
*														              
* Revision:      										              
*														              
* Functions:    Vectors table for LIN08EY16 Drivers
*												                            
* Description:  Vector table and node's startup for HC08.
*               The users can add their own vectors into the table,
*               but they should not replace LIN Drivers vectors.
*
* Notes:        1.  The only one of the following variables may be defined, while
*                   all others are undefined. This is controlled by the compiler
*                   option, which in turn is to be adjusted in 'makefile' or batch
*                   file:
*                       HC08EY16    
*
******************************************************************************/

#if defined(HC08EY16)
extern void LIN_ISR_SCI_Receive();      /* ESCI receive ISR              */
extern void LIN_ISR_SCI_Error();        /* ESCI error ISR                */
#endif /* defined(HC08EY16) */

/******************************************************************************
    NODE STARTUP 
    By default compiler startup routine is called.
    User is able to replace this by any other routine.
******************************************************************************/

#if defined(CW08)
#define Node_Startup    _Startup            
extern void _Startup();                 /* CW08 compiler startup routine declaration */
#endif  /* defined(CW08) */

#if defined(COSMIC08)
#define Node_Startup    _stext
extern void _stext();                   /* Cosmic compiler startup routine declaration  */
#endif  /* defined(COSMIC08) */


/******************************************************************************
    INTERRUPT VECTORS TABLE
    User is able to add another ISR into this table instead NULL pointer.
******************************************************************************/

/******************************************************************************		
 *                                                                                     
 * Function:     DummyISR()                										
 *														              			        
 * Description:  dummy interrupt handler                                        	    
 *                                                                                     
 * Returns: no return value                                                            
 *																				        
 * Notes:        														     		    
 *																		    		    
 ******************************************************************************/       
static interrupt void DummyISR(void)											    
{	    																			    
	while(1);																		    
} 



#if !defined(NULL)
#define NULL    (0)
#endif /* !defined(NULL) */

#undef  LIN_VECTF

#if defined(CW08)
#define LIN_VECTF ( void ( *const ) ( ) )
#pragma CONST_SEG VECTORS_DATA              /* vectors segment declaration */
void (* const _vectab[])( ) = 
#endif  /* defined(CW08) */

#if defined(COSMIC08)
#define LIN_VECTF (void *const)
void *const _vectab[] = 
#endif  /* defined(COSMIC08)  */

#if defined(HC08EY16)

/***************************************************************************/
/*                                                                         */
/*                              HC08EY16                                   */
/*                                                                         */
/*      These vectors are appropriate for the 2L31N mask set of the        */
/*      MC68HC908EY16 and all subsequent versions.                         */
/*                                                                         */
/*      Older mask sets, e.g. 0L38H, 1L38H, 0L31N and 1L31N had a fault    */
/*      in their interrupt vector table and hence in the priorities.       */
/*      For these older mask sets the order of the SCI vectors was:        */
/*                                                                         */
/*      SCI_Error_ISR,                       // 0xFFE6   ESCI error        */
/*      SCI_Transmit_ISR,                    // 0xFFE8   ESCI transmit     */
/*      SCI_Receive_ISR,                     // 0xFFEA   ESCI receive      */
/*                                                                         */
/*      All other vectors are unchanged.                                   */
/*                                                                         */
/***************************************************************************/

{
    LIN_VECTF DummyISR,                          /* 0xFFDC   Timebase          */
    LIN_VECTF DummyISR,                          /* 0xFFDE   SPI transmit      */
    LIN_VECTF DummyISR,                          /* 0xFFE0   SPI receive       */
    LIN_VECTF DummyISR,                          /* 0xFFE2   ADC               */
    LIN_VECTF DummyISR,                          /* 0xFFE4   Keyboard          */
    LIN_VECTF DummyISR,                          /* 0xFFE6   ESCI transmit     */
    LIN_VECTF LIN_ISR_SCI_Receive,               /* 0xFFE8   ESCI receive      */
    LIN_VECTF LIN_ISR_SCI_Error,                 /* 0xFFEA   ESCI error        */
    LIN_VECTF DummyISR,                          /* 0xFFEC   TIMER B overflow  */
    LIN_VECTF DummyISR,                          /* 0xFFEE   TIMER B channel 1 */
    LIN_VECTF DummyISR,                          /* 0xFFF0   TIMER B channel 0 */
    LIN_VECTF DummyISR,                          /* 0xFFF2   TIMER A overflow  */
    LIN_VECTF DummyISR,                          /* 0xFFF4   TIMER A channel 1 */
    LIN_VECTF DummyISR,                          /* 0xFFF6   TIMER A channel 0 */
    LIN_VECTF DummyISR,                          /* 0xFFF8   CMIREQ            */
    LIN_VECTF DummyISR,                          /* 0xFFFA   IRQ               */
    LIN_VECTF DummyISR,                          /* 0xFFFC   SWI               */
    LIN_VECTF Node_Startup                       /* 0xFFFE   RESET             */
};

#endif  /* defined(HC08EY16) */


#if defined(CW08)
#pragma CONST_SEG DEFAULT
#endif  /* defined(CW08) */
