// ============================================================================
//  Copyright (c)2006 Freescale Semiconductor Inc.  -- All Rights Reserved --
//
//  The code is the property of Freescale GmbH Munich
//  TSPG-APD-IDC Intelligent Distributed Control Operation
//
//  The copyright notice above does not evidence any actual or intended 
//  publication of such source code.
//
//  This software is provided by Freescale "AS IS" and any expressed or implied
//  warrenties, including, but not limited to, the implied warrenties of 
//  merchantability and fitness for a particular purpose are disclaimed.
//  In no event shall Freescale or its contributors be liable for any direct, 
//  indirect, incidental, special, examplary, or consequential damages 
//  (including, but not limited to, procurement of substitue goods or services;
//  loss of use, data, or profits; or business interruption). However caused 
//  and on any theory of liability, whether in contract, strict liability, or
//  tort (including negligence or otherwise) arising in any way out of the use 
//  of this software, even if advised of the possibility of such damage.
// 
//  ---------------------------------------------------------------------------
//
//  Filename:     $Source: D:/home/r51406/___CVS/CVS_Server2/LINDiag/l_diag.h,v $
//  Author:       $Author: r51406 $
//  Locker:       $Locker:  $
//  State:        $State: Exp $
//  Revision:     $Revision: 1.2 $
//
//  Functions:    
//
//  History:      Use the CVS command log to display revision history information.
//
//  Description:  header file for one specific LIN diagnostic implementation
//
//  Notes:        This file is NOT allowed to modify by user
//                
//
//
// ============================================================================
#ifndef   L_DIAG_H
#define   L_DIAG_H 


#include "Hicross.h"
#include "Types.h"
#include "l_api.h"

#include "ChipSets.h"


// --------------------------------------------------------
// Macros
// --------------------------------------------------------

// -----  Extern Buffer Reference  ------------------------
extern l_u8 LINBuffer3C[];                                 
extern l_u8 LINBuffer3D[];                                 

// -----  Frame Buffers  ----------------------------------
#define ldd_frmSysMasterRequest          LINBuffer3C
#define ldd_frmSysSlaveResponse          LINBuffer3D


// -----  Received Signals  -------------------------------
// frmSysMasterRequest
#define ldd_u8_rd_SysNAD()          ((l_u8) (ldd_frmSysMasterRequest[7]))
#define ldd_u8_rd_SysCMD()          ((l_u8) (ldd_frmSysMasterRequest[6]))
#define ldd_u8_rd_SysM0()           ((l_u8) (ldd_frmSysMasterRequest[5]))
#define ldd_u8_rd_SysM1()           ((l_u8) (ldd_frmSysMasterRequest[4]))
#define ldd_u8_rd_SysM2()           ((l_u8) (ldd_frmSysMasterRequest[3]))
#define ldd_u8_rd_SysM3()           ((l_u8) (ldd_frmSysMasterRequest[2]))
#define ldd_u8_rd_SysM4()           ((l_u8) (ldd_frmSysMasterRequest[1]))
#define ldd_u8_rd_SysM5()           ((l_u8) (ldd_frmSysMasterRequest[0]))

#define ldd_u16_rd_SysM01()         ((l_u16)((*(l_u16*)&ldd_frmSysMasterRequest[4])))
#define ldd_u16_rd_SysM23()         ((l_u16)((*(l_u16*)&ldd_frmSysMasterRequest[2])))
#define ldd_u16_rd_SysM45()         ((l_u16)((*(l_u16*)&ldd_frmSysMasterRequest[0])))


// -----  Transmitted Signals  ----------------------------
// frmSysSlaveResponse
#define SysResponseMsgIdx           1

#define ldd_u8_wr_SysNAD(v)         ldd_frmSysSlaveResponse[7] = ((l_u8)(v))
#define ldd_u8_wr_SysCMD(v)         ldd_frmSysSlaveResponse[6] = ((l_u8)(v))
#define ldd_u8_wr_SysS0(v)          ldd_frmSysSlaveResponse[5] = ((l_u8)(v))
#define ldd_u8_wr_SysS1(v)          ldd_frmSysSlaveResponse[4] = ((l_u8)(v))
#define ldd_u8_wr_SysS2(v)          ldd_frmSysSlaveResponse[3] = ((l_u8)(v))
#define ldd_u8_wr_SysS3(v)          ldd_frmSysSlaveResponse[2] = ((l_u8)(v))
#define ldd_u8_wr_SysS4(v)          ldd_frmSysSlaveResponse[1] = ((l_u8)(v))
#define ldd_u8_wr_SysS5(v)          ldd_frmSysSlaveResponse[0] = ((l_u8)(v))

#define ldd_u16_wr_SysS01(v)        *((l_u16 *)&ldd_frmSysSlaveResponse[4]) = ((l_u16)(v))
#define ldd_u16_wr_SysS23(v)        *((l_u16 *)&ldd_frmSysSlaveResponse[2]) = ((l_u16)(v))
#define ldd_u16_wr_SysS45(v)        *((l_u16 *)&ldd_frmSysSlaveResponse[0]) = ((l_u16)(v))


// --------------------------------------------------------
// Published Methods
// --------------------------------------------------------
void ldd_Handler(void);



#endif // L_DIAG_H
