// ========================================================
//   Copyright (C) 2003 Motorola, Inc.
//   All Rights Reserved
//
//   The code is the property of Motorola GmbH Munich
//   Combined Technologies Operation
//   and is Motorola Confidential Proprietary Information.
//
//   The copyright notice above does not evidence any
//   actual or intended publication of such source code.
//
//
// Filename:     $Source: $
// Author:       $Author: $
// Locker:       $Locker: $
// State:        $State: $
// Revision:     $Revision: $
//
// Functions:    
//
// History:      Use the CVS command log to display 
//               revision history information.
//
// Description:  
//
//
//
// Notes:        Timer A channel 1 used to generate FGEN signal
//               ~25kHz 50% duty cycle
//
//
// ========================================================

#ifndef TIMERA_H
#define TIMERA_H

#include "Types.h"
#include "ChipSets.h"

#define BUSFREQUENCY            4915200                     // [Hz]   
#define FGENFREQUENCY           (UINT16)(BUSFREQUENCY/268)  // [Hz]   



// Output Preset
#define TIM_MODE_OUTPUT_PRESET_HIGH       (                         )   // Pin under port control; initial output level high
#define TIM_MODE_OUTPUT_PRESET_LOW        (      bMS0A              )   // Pin under port control; initial output level low

// Input capture  
#define TIM_MODE_INPUTCAPTURE_RISINGEDGE  (                   bELS0A)   // Capture on rising edge only
#define TIM_MODE_INPUTCAPTURE_FALLINGEDGE (            bELS0B       )   // Capture on falling edge only
#define TIM_MODE_INPUTCAPTURE_ONEDGE      (            bELS0B|bELS0A)   // Capture on rising or falling edge

// Output compare or PWM    
#define TIM_MODE_OUTPUTCOMPARE_SWONLY     (      bMS0A              )   // Software compare only
#define TIM_MODE_OUTPUTCOMPARE_TOGGLE     (      bMS0A       |bELS0A)   // Toggle output on compare
#define TIM_MODE_OUTPUTCOMPARE_CLEAR      (      bMS0A|bELS0B       )   // Clear output on compare
#define TIM_MODE_OUTPUTCOMPARE_SET        (      bMS0A|bELS0B|bELS0A)   // Set output on compare


// Buffered output compare or buffered PWM
#define TIM_MODE_BUF_OUTPUTCOMPARE_TOGGLE (bMS0B      |bELS0B|bELS0A)   // Toggle output on compare
#define TIM_MODE_BUF_OUTPUTCOMPARE_CLEAR  (bMS0B      |bELS0B|bELS0A)   // Clear output on compare
#define TIM_MODE_BUF_OUTPUTCOMPARE_SET    (bMS0B      |bELS0B|bELS0A)   // Set output on compare



// --------------------------------------------------------
// Properties (public)
// --------------------------------------------------------

// --------------------------------------------------------
// Methodes published
// --------------------------------------------------------
void TimerAInit(void);                                       // Initialize Timer for PWM and Channels
void TimerAEnable(void);
void TimerADisable(void);

#endif // TIMER_H

