#include <MC9S08LC60.h> /* include peripheral declarations */
#include "cpu.h" /* include peripheral declarations */

//************************
//Configure SCI baud rate based on ICG clock settings

#if FBE_32KHZ
  #define SCIDIVIDER 		9 //16.4 kHz bus; 110 baud  
#elif FEE_32K8BUS
  #define SCIDIVIDER 		54 //8.389 MHz bus; 9600 baud
#elif FEE_32K16BUS
  #define SCIDIVIDER 		109 //8.389 MHz bus; 9600 baud
#elif FEI_8MBUS
  #define SCIDIVIDER 		57 //8.8 MHz bus; 9600 baud
#endif

			 
//************************
#define OVERRUN_ERR      1             /* Overrun error flag bit   */
#define FRAMING_ERR      2             /* Framing error flag bit   */
#define PARITY_ERR       4             /* Parity error flag bit    */
#define CHAR_IN_RX       8             /* Char is in RX buffer     */
#define FULL_TX          16            /* Full transmit buffer     */
#define RUNINT_FROM_TX   32            /* Interrupt is in progress */
#define FULL_RX          64            /* Full receive buffer      */
#define NOISE_ERR        128           /* Noise erorr flag bit     */
#define IDLE_ERR         256           /* Idle character flag bit  */
#define BREAK_ERR        512           /* Break detect             */


#define ERR_OK           0             /* OK */
#define ERR_SPEED        1             /* This device does not work in the active speed mode. */
#define ERR_RANGE        2             /* Parameter out of range. */
#define ERR_VALUE        3             /* Parameter of incorrect value. */
#define ERR_OVERFLOW     4             /* Timer overflow. */
#define ERR_MATH         5             /* Overflow during evaluation. */
#define ERR_ENABLED      6             /* Device is enabled. */
#define ERR_DISABLED     7             /* Device is disabled. */
#define ERR_BUSY         8             /* Device is busy. */
#define ERR_NOTAVAIL     9             /* Requested value or method not available. */
#define ERR_RXEMPTY      10            /* No data in receiver. */
#define ERR_TXFULL       11            /* Transmitter is full. */
#define ERR_BUSOFF       12            /* Bus not available. */
#define ERR_OVERRUN      13            /* Overrun error is detected. */
#define ERR_FRAMING      14            /* Framing error is detected. */
#define ERR_PARITY       15            /* Parity error is detected. */
#define ERR_NOISE        16            /* Noise error is detected. */
#define ERR_IDLE         17            /* Idle error is detectes. */
#define ERR_FAULT        18            /* Fault error is detected. */
#define ERR_BREAK        19            /* Break char is received during communication. */
#define ERR_CRC          20            /* CRC error is detected. */
#define ERR_ARBITR       21            /* A node losts arbitration. This error occurs if two nodes start transmission at the same time. */
#define ERR_PROTECT      22            /* Protection error is detected. */
#define ERR_UNDERFLOW    23            /* Underflow error is detected. */
#define ERR_UNDERRUN     24            /* Underrun error is detected. */
#define ERR_COMMON       25            /* Common error of a device. */


//****** Variables *****************
static word SerFlag;                   /* Flags for serial communication */
                                       /* Bits: 0 - OverRun error */
                                       /*       1 - Framing error */
                                       /*       2 - Parity error */
                                       /*       3 - Char in RX buffer */
                                       /*       4 - Full TX buffer */
                                       /*       5 - Unused */
                                       /*       6 - Full RX buffer */
                                       /*       7 - Noise error */
                                       /*       8 - Idle character  */
                                       /*       9 - Break detected  */
                                       /*      10 - Unused */

									
//****** Functions  *****************
void AS1_Init(void);
byte AS1_SendChar(byte Chr);
byte AS1_RecvChar(byte *Chr);			 
