/************************************************************

Filename : lcddrv.h

Description: LCD driver header file defining external
             function and structure prototypes.
Purpose: This file is to be used in conjuction with 
         the LCD low level driver.  File should be 
         included in and compiled with the LCD application
         program
*************************************************************/
 #include "cpu.h"

//=====================
//Constant Variables
//======================
//Glass paramters
#define  NUMALPASEGS_ONGLASS 9
#define  NUMREGSPERSEG_ONGLASS 2  //register per segment
#define  NUMRAMREGS_FORGLASS 20  //register per segment
#define  LCD_ALPNUM_SETMASK   0x37

//=====================
//Other Variables
//======================//Not delay is based in bus clock//adjust as necessary
#if FBE_32KHZ
  #define  SCROLL_DELAY   4
  #define  CLEAR_DELAY    2
#elif FEE_32K8BUS
  #define  SCROLL_DELAY   60
  #define  CLEAR_DELAY    20
#elif FEE_32K16BUS
  #define  SCROLL_DELAY   60
  #define  CLEAR_DELAY    20
#elif FEI_8MBUS
  #define  SCROLL_DELAY   60
  #define  CLEAR_DELAY    20
#endif

//Labels
#define SEGONOFF          OFF
#define SEGBLINKEN			  ON

//===========================
//LCD power configuration
//===========================
#define LCDPWR_VDD    1
#define LCDPWR_VLCD   0
#define LCDPWR_VLLLN  0


#if  LCDPWR_VLCD
    //configure mode 
    #define DOUBLERMODE    0		//typical for 3V glass
    #define TRIPLERMODE    1		//typical for 3V glass
    
    //Buffer mode setting if using TRIPLERMODE and LCDPWR_VLCD
    #if		TRIPLERMODE
      #define LCDBUFFERSTATE      ON//OFF//     
		#endif 
#endif

#if  LCDPWR_VDD 
    #define VDDTOVLL2_2V     0	 //need nominal VDD=2V; 3V LCD glass; doubler mode = LCDCPMS=0
    #define VDDTOVLL2_3D3V   0 	 //need nominal VDD=3.3V; 5V LCD glass; tripler mode = LCDCPMS=1
    #define VDDTOVLL3_3V     1	 //need nominal VDD=3V; 3V LCD glass; doubler mode = LCDCPMS=0
#endif


//===========================
//LCD clock source selection   //if OFF the LCD is clocked via the bus clock
//============================
#if FBE_32KHZ
  #define EXTERNALCLK			YES  
#elif FEE_32K8BUS
  #define EXTERNALCLK			YES  
#elif FEE_32K16BUS
  #define EXTERNALCLK			YES  
#elif FEI_8MBUS
  #define EXTERNALCLK			NO  
#endif


#if   EXTERNALCLK			 //LCD clock off EXTERNALCLK//must be 32.768 source
    #define LCDCLK_ADJ			0 //SYS_CLOCK/32768 - 1
#else  
    #if  SYS_CLOCK < 100000 
        #define LCDCLK_16			0
        #define LCDCLK_ADJ			SYS_CLOCK/32768 - 1
    #else
        #define LCDCLK_16			1
        #define LCDCLK_ADJ			SYS_CLOCK/32768/16 - 1
    #endif    
#endif 

//===========================
//Define LCD duty cycle 
//===========================
#define DUTY1BY2        0
#define DUTY1BY3        0
#define DUTY1BY4        1
#if DUTY1BY2			 //format = FF = Frame Frequency
      /* 1/2 Duty Cycle */
      #define D2FF128D08         0
      #define D2FF64D04          0
      #define D2FF32D02          0
      #define D2FF16D01          0
#elif	 DUTY1BY3
      /* 1/3 Duty Cycle */
      #define D3FF170D77         0
      #define D3FF85D38          0
      #define D3FF42D69          0
      #define D3FF29D34          0
#elif	 DUTY1BY4
      /* 1/4 Duty Cycle */
      #define D4FF128D08         0
      #define D4FF64D04          1			 //64Hz
      #define D4FF32D02          0			 //32Hz
      #define D4FF16D01          0
#endif


//===========================
//Define Blink Rate 
//===========================
#define BLINKFACTOR  2
#define BLINKALLSEGQ  NO

//===========================
//LCD interrupt
//===========================
#define LCDINTEN ON
 
//===========================
//LCD low power modes
//===========================
#define LCDINSTP3   ON
#define LCDINWAIT   OFF

//===========================
//Functions
//===========================
void  LCD_init(void);
void  ENABLE_BLINK(char);
void  ENABLE_LCD(char);
void  LCD_BLANK(byte local_mode);
void  LCD_RAM_SET_ALL(char lcdramm)  ;
void  LCD_RAM_CLEAR_ALL(char lcdramm); 
void  LCD_RAM_CLEARALL_CMD(char lcdramm);  

void  SET_LOGO(char lcdramm, char k); 
void  SET_VOL(char lcdramm, char v, byte numbars); 
void  SET_BATT(char lcdramm, char t, byte numbars);
void  SET_POWERSAVE(char lcdramm, char p); 
void  SET_TIMESEGS(byte lcdramm, byte am, byte pm, byte k3);
void  SET_TEMPSEGS(byte lcdramm, byte k1, byte k2,char col4);
void  SET_DMMLABLES(char lcdramm, char kwatt, char volt,char amp,char om) ;
void  SET_COLONS(char lcdramm, char col1, char col2, char col3, char dt) ;
void  SET_DECIMALS(char lcdramm, char dt1,char dt2,char dt3,char dt4,char dt5,char dt6,char dt7,char dt8, char dt9); 
void  SET_MENU(char lcdramm,  char lab1, char lab2, char lab3, char lab4, char lab5, char lab6, char lab7); 

void SET_ALL_ALPNUM(char lcdramm);  
void CLEAR_ALL_ALPNUM(char lcdramm);  
void output_strg_lcd(tU08 *string, tU08 length); 
void Scroll_String(tU08 *string, byte local_len); 
