#include <MC9S08LC60.h> /* include peripheral declarations */

#include "cpu.h"


void CPU_init() {
  
    //IRQ set up ;  NO IRQ just port pin
    /*      7   6       5       4     3     2       1      0
            0  IRQPDD IRQEDG IRQPE  IRQF  IRQACK  IRQIE IRQMOD     */
    IRQSC = 0;

  //SETUP SIM, System Power
  //------------------
  /* SOPT: COPE=0,COPT=0,STOPE=1,??=0,??=0,??=0,BKGDPE=1,RSTPE (reset pin)=0 */
  SOPT1 = SOPT1_BKGDPE_MASK | SOPT1_STOPE_MASK | SOPT1_RSTPE_MASK;

	//COPCLKS1 0 0 0 0 0 0 ACIC
	SOPT2 = 0;
	 
  /* SPMSC1: LVDF=0,LVDACK=0,LVDIE=0,LVDRE=0 (no reset),LVDSE=1,LVDE=1,??=0,BGBE=0 */
  SPMSC1 = 0;  //<<Kane SPMSC1_LVDSE_MASK | SPMSC1_LVDE_MASK;
  /* SPMSC2: ??=0,??=0,??=0,PDF=0,PPDF=0,PPDACK=0,PDC=0,PPDC=0 */
  SPMSC2 = 0;

  //SPMSC3: LVWF, 0, LVDV, LVWV,0,0,0,0
  SPMSC3 = 0;

  //SETUP RTI : RTIF, 0 (RTIACK),RTICLKS, RTIE,0,RTIS2 ,RTIS1, RTIS0
  SRTISC = 0;
  
  //SETUP ICG
  //------------------
  // Initialization of the ICG control register 1 
  /* ICGC1: ??=0,RANGE=0,REFS=1,CLKS1=1,CLKS0=1,OSCSTEN=1,LOCD=1,??=0 */
#if OSCENINOFFMODE
  ICGC1 = C1HGO <<7 | C1RANGE <<6 | C1REFS <<5 | C1CLKS <<3 | ICGC1_OSCSTEN_MASK | ICGC1_LOCD_MASK;                          
#else  
  ICGC1 = C1HGO <<7 | C1RANGE <<6 | C1REFS <<5 | C1CLKS <<3 ;                          
#endif  
  // Initialization of the ICG control register 2 
  /* ICGC2: LOLRE=0,MFD2=1,MFD1=1,MFD0=1,LOCRE=0,RFD2=0,RFD1=0,RFD0=0 */
  ICGC2 = C2MFD <<4  | C2RFD;

  //Trim internal clock if used
  //ICGTRM = 128;
  if (NVICGTRM != 0xff)
        ICGTRM = NVICGTRM;								     /* load trim value if location not blank */

  
#if (FBE_32KHZ)
    //Do nothing on Bypass mode              
#else
    //Mode uses FLL so wait for a lock
    // Wait 
    while(!ICGS1_LOCK);
#endif
		while(ICGC1_CLKS != ICGS1_CLKST);

}