/******************************************************************************
 *
 *                      (c) Freescale  Inc. 2004 All rights reserved
 *
 * File Name     :Vectors.c
 * Description   :
 *
 * Version : 1.0
 * Date    : Jun/22/2004
 *
 ******************************************************************************/

extern void near _Startup(void);              /* Startup routine */

#include <MC9S08LC60.h> /* include peripheral declarations */

//************************************************************************
// SOFTWARE TRAP FUNCTION
// DESCRIPTION:
// Function that traps  all unexpected interrupts.  Used for debugging 
// software to find runaway code.
//************************************************************************

//************************
#pragma CODE_SEG __NEAR_SEG NON_BANKED /* Interrupt section for this module. Placement will be in NON_BANKED area. */        
__interrupt void Cpu_Interrupt(void){ for(;;); }
#pragma CODE_SEG DEFAULT               /* Change code section to DEFAULT. */

//************************
#pragma CODE_SEG __NEAR_SEG NON_BANKED /* Interrupt section for this module. Placement will be in NON_BANKED area. */        
__interrupt void LCD_Interrupt(void){ 

  	LCDCMD_LCDIF = 1;
}
#pragma CODE_SEG DEFAULT               /* Change code section to DEFAULT. */

//************************
#pragma CODE_SEG __NEAR_SEG NON_BANKED /* Interrupt section for this module. Placement will be in NON_BANKED area. */        
__interrupt void KBI2_Interrupt(void){ 

     	PTAD_PTAD7 = ~PTAD_PTAD7;//output; LED 
     	PTAD_PTAD6 = ~PTAD_PTAD6;//output; LED 
     	PTAD_PTAD5 = ~PTAD_PTAD5;//output; LED 
     	PTBD_PTBD7 = ~PTBD_PTBD7;//output; LED 
     	PTBD_PTBD6 = ~PTBD_PTBD6;//output; LED 
     	PTBD_PTBD5 = ~PTBD_PTBD5;//output; LED 
     	PTBD_PTBD4 = ~PTBD_PTBD4;//output; LED 
     	PTBD_PTBD3 = ~PTBD_PTBD3;//output; LED
      KBI2SC_KBACK = 1;
  	
}
#pragma CODE_SEG DEFAULT               /* Change code section to DEFAULT. */

//************************
#pragma CODE_SEG __NEAR_SEG NON_BANKED /* Interrupt section for this module. Placement will be in NON_BANKED area. */        
__interrupt void KBI1_Interrupt(void){ 
  	
}
#pragma CODE_SEG DEFAULT               /* Change code section to DEFAULT. */


//************************
#pragma CODE_SEG __NEAR_SEG NON_BANKED /* Interrupt section for this module. Placement will be in NON_BANKED area. */        
__interrupt void IRQ_Interrupt(void){ 

      //IRQSC_IRQACK = 1;
      }
#pragma CODE_SEG DEFAULT               /* Change code section to DEFAULT. */


//************************
#pragma CODE_SEG __NEAR_SEG NON_BANKED /* Interrupt section for this module. Placement will be in NON_BANKED area. */        
__interrupt void LVD_Interrupt(void){ 

      for(;;);
      }
#pragma CODE_SEG DEFAULT               /* Change code section to DEFAULT. */

//************************
#pragma CODE_SEG __NEAR_SEG NON_BANKED /* Interrupt section for this module. Placement will be in NON_BANKED area. */        
__interrupt void RTI_Interrupt(void){ 

}
#pragma CODE_SEG DEFAULT               /* Change code section to DEFAULT. */

//************************************************************************

void (* const _vect[])() @0xFFD2 = {   // Interrupt table
           LCD_Interrupt,
           RTI_Interrupt,
           Cpu_Interrupt,
           Cpu_Interrupt,
           Cpu_Interrupt,
           KBI2_Interrupt,
           KBI1_Interrupt,
           Cpu_Interrupt,
           Cpu_Interrupt,		          
           Cpu_Interrupt,
           Cpu_Interrupt,
           Cpu_Interrupt,
           Cpu_Interrupt,
           Cpu_Interrupt,
           Cpu_Interrupt,
           Cpu_Interrupt,
           Cpu_Interrupt,
           Cpu_Interrupt,
           Cpu_Interrupt,		 
           LVD_Interrupt,
           IRQ_Interrupt,
           Cpu_Interrupt,		    
           _Startup
   };
