/****************************************************************
FILE
	$RCSfile: pq27e_init.c,v $
	$Date: 2004/10/05 08:25:13 $
	$Revision: 1.5 $
DESCRIPTION
	MPC8272 ADS initialization file
COPYRIGHT	
	(c) 2003 Metrowerks Corporation
	All rights reserved.
HISTORY
   $Log: pq27e_init.c,v $
   Revision 1.5  2004/10/05 08:25:13  c-dnegrea
   modified to support Cache ISR Debug target

   Revision 1.4  2003/11/03 13:39:20  milies
   added internal memory configuration for Security Co-Processor (SEC)
   
******************************************************************/

//----------------------------------------------------------------------------
// Register Offset Definitions. All these values are offsets from the 
// Internal Memory Map Register (IMMR) base pointer + 0x10000. The base value 
// is determined by the ISB bits in the Hard Reset Configuration Word. See the 
// reset section of the user's manual. This list does not comprise all possible
// Internal Memory Mapped Registers.
//----------------------------------------------------------------------------

#define SIUMCR         0x00000000   // SIU Module Configuration Register
#define SYPCR          0x00000004   // System Protection Control Register
#define RMR			   0x00000C94	// Reset Mode Register
#define BCR            0x00000024   // Bus Configuration Register
#define PPC_ACR        0x00000028   // 60x Bus Arbiter Configuration Register
#define PPC_ALRH       0x0000002C   // 60x Bus Arbitration-Level[High] Register
#define TESCR1         0x00000040   // 60x Bus Transfer Error Status and
                                    // Control Register 1
#define TESCR2         0x00000044   // 60x Bus Transfer Error Status and
                                    // Control Register 2

#define LTESCR1        0x00000048   // Local Bus Transfer Error Status and
                                    // Control Register 1
#define LTESCR2        0x0000004C   // Local Bus Transfer Error Status and
                                    // Control Register 2

#define SCCR           0x00000C80   // System Clock Control Register
#define BR0            0x00000100   // Base Register Bank 0
#define OR0            0x00000104   // Option Register Bank 0
#define BR1            0x00000108   // Base Register Bank 1
#define OR1            0x0000010C   // Option Register Bank 1
#define BR2            0x00000110   // Base Register Bank 2
#define OR2            0x00000114   // Option Regiser Bank 2
#define BR3            0x00000118   // Base Register Bank 3
#define OR3            0x0000011C   // Option Register Bank 3
#define BR4            0x00000120   // Base Register Bank 4
#define OR4            0x00000124   // Option Register Bank 4
#define BR5            0x00000128   // Base Register Bank 5
#define OR5            0x0000012C   // Option Register Bank 5
#define BR8            0x00000140   // Base Register Bank 8
#define OR8            0x00000144   // Option Register Bank 8
#define MPTPR          0x00000184   // Memory Periodic Timer Prescaler Register
#define PSDMR          0x00000190   // PowerPC Bus SDRAM Machine Mode Register
#define LSDMR          0x00000194   // Local Bus SDRAM Machine Mode Register
#define PURT           0x00000198   // 60x Bus Assigned UPM Refresh Timer
#define PSRT           0x0000019C   // 60x Bus Assigned SDRAM Refresh Timer
#define LURT           0x000001A0   // Local Bus Assigned UPM Refresh Timer
#define LSRT           0x000001A4   // Local Bus Assigned SDRAM Refresh Timer
#define IMMR           0x000001A8   // Internal I/O base register offset


#define PCI_GCR		   0x00000880   // PCI General Control Register
#define PCIBR0		   0x000001AC   // PCI Base Register 0
#define PCIBR1		   0x000001B0   // PCI Base Register 1
#define PCIMSK0		   0x000001C4   // PCI Mask Register 0
#define PCIMSK1		   0x000001C8   // PCI Mask Register 1

#define SECMR		   0x000001BC	// SEC Mask Register
#define SECBR		   0x000001B4	// SEC Base Register


#pragma section code_type ".init"

#ifdef __cplusplus
extern "C" {
#endif

asm void __reset(void);
asm void usr_init();
extern void __start();
extern unsigned long gInterruptVectorTable;
extern unsigned long gInterruptVectorTableEnd;
extern void mmu_cache_init();

#ifdef __cplusplus
}
#endif


asm void __reset(void)
{
	//
	//   Enable machine check exceptions
	//
	lis		r3, 0
	ori		r3, r3, 0x1002
	mtmsr	r3
		
	b		__start
}

asm void usr_init()
{
	nofralloc


   //----------------------------------------------
   // Load the IMMR register with the base address
   //----------------------------------------------

#ifdef ROM_VERSION
   addis    r4,0,0x0471   // IMMR base addr = 0x04700000+10000. We add 
                          // 0x10000 because using relative addressing
                          // in load and store instructions only allow a
                          // offset from the base of +/-32767.
   addis    r5,0,0x0470

   addis    r3,0,0x0F01            
   stw      r5,IMMR(r3)   // The default IMMR base address was 0x0F0000000 as 
                          // originally programmed into the Hard Reset 
                          // Configuration Word.

	mtspr 311,r5


   //*******************************************
   // Main System Clock Configuration Registers 
   //*******************************************

   //-------------------------------------------------------------------------
   // We only need to program the System Clock Control Register (SCCR). The 
   // System Clock Mode Register (SCMR) doesn't need to be programmed here
   // because the MODCLK_HI bits in the Hard Reset Configuration Word and the
   // MODCK pins dictate the values in the SCCR during power-on reset.
   //-------------------------------------------------------------------------

   //-------------------------------------------------------------------------
   // Program the System Clock Control Register (SCCR).
   //
   // - Bits 0 - 22 Reserved. Clear to 0.
   //
   // - PCI_Mode = 0 (Disabled)
   //
   // - CLPD (CPM Low Power Disable) = 0 = 
   //
   //     CPM does not enter low power mode when the core enters low power 
   //     mode.
   //
   // - DFBRG (Division Factor of BRGCLK) = 01 - Divide by 8.
   //
   //-------------------------------------------------------------------------

   addis    r3,0,0x0000
   ori      r3,r3,0x0001   // SCCR = 0x00000001
   stw      r3,SCCR(r4)

  
   //~~~~~~~~~~~~~~~~~~~~
   // Initialize the SIU
   //~~~~~~~~~~~~~~~~~~~~

   //-----------------------------------------------------------------------
   // Program the System Protection Control Register with the following 
   // values:
   //
   // - SWTC (Software Watchdog Timer Count) = 0xFFFF = programmed to max
   //   count value.
   // - BMT (Bus Monitor Timing) = 0xFF = Set to max timeout period.
   // - PBME (60x Bus Monitor Enable) = 1 = enabled.
   // - LBME (Local Bus Monitor Enable) = 1 = enabled.
   // - Bits 26-28 Reserved. Set to 0.
   // - SWE (Software Watchdog Enabled) = 0 = disabled for now. User will 
   //   have to enable this in a non-debug application.
   // - SWRI (Software Watchdog Reset/Interrupt Select) = 1 = Software 
   //   watchdog timeout or bus monitor time-out causes a soft reset.
   // - SWP (Software Watchdog Prescale) = 1 = clock is prescaled.
   //-----------------------------------------------------------------------

   addis    r3,0,0xFFFF
   ori      r3,r3,0xFFC3   // SYPCR = 0xFFFFFFC3
   stw      r3,SYPCR(r4)    



   addis    r3,0,0x0001
   stw      r3,RMR(r4)
   
  
   //-------------------------------------------------------------------------
   // Program the Bus Configuration Register. The details are as follows:
   //
   // - EBM (External Bus Mode) = 0 = Single bus mode is assumed.
   // - APD (Address Phase delay) = 001 = 
   //     One address tenure wait states for address operations initiated by 
   //     a 60x bus master.
   // - L2C (Secondary Cache Controller) = 0 = No secondary cache controller
   //                                          is assumed.
   // - L2D (L2 cache hit Delay) = 000 = This is a don't care because we're 
   //                                    not using the L2 cache.
   // - PLDP (PipeLine maximum Depth) = 0 = The pipeline max depth is one.
   // - EAV (Enable address visibility) = 0 = Bank select signals are driven on 60x bus address lines. 
   //                                         There is no full address visibility.
   // - Bits 10-11 = Reserved. Set to 0.
   // - ETM (Compatibility Mode enable) = 1 = Extended transfer mode is
   //                                         enabled.
   // - LETM (Local Bus Compatibility Mode Enable) = 1 = 
   //     Extended transfer mode is enabled on the local bus.
   // - EPAR (Even Parity) = 0 = This is a don't care.
   // - LEPAR (Local Bus Even Parity) = 0 = This is a don't care.
   // - Bits 16-20 = Reserved. Set to 0.
   // - EXDD (External Master Delay Disable) = 0 = 
   //     The memroy controller inserts one wait state between the assertion 
   //     of TS and the assertion of CS when an external master accesses an 
   //     address space controlled by the memory controller.
   // - Bits 22-26 = Reserved. Set to 0.
   // - ISPS (Internal Space Port Size) = 0 = 
   //     MPC8260 acts as a 64-bit slave to external master accesses to it's 
   //     internal space.
   // - Bits 28-31 = Reserved. Set to 0.
   //-------------------------------------------------------------------------

   addis    r3,0,0x100c
   stw      r3,BCR(r4)

   //-------------------------------------------------------------------------
   // Program the 60x Bus Arbiter Configuration Register. The details are as
   // follows:
   //
   // - Bits 0-1 = Reserved. Set to 0. 
   // - DBGD (Data Bus Grant Delay) = Minimum of zero wait states for PowerPC
   //                                 master-initiated data operations. This 
   //                                 is the minimum delay between TS/ and 
   //                                 DBG/.
   // - EARB (External arbitration) = 0 = Internal arbitration is performed
   // - PRKM (Parking Master) = 0010 = CPM is at a low request level for the 
   //                                  parked master.
   //-------------------------------------------------------------------------

   addi     r3,0,0x0002
   stb      r3,PPC_ACR(r4)

   
   //-------------------------------------------------------------------------
   // Program the 60x Bus Arbitration-Level[High] Register. The priority for 
   // potential bus masters are defined by locating the value associated with
   // a particular master from the PRKM field in the PPC_ACR register and 
   // inserting it's value in the priority field. Priority field 0 is the
   // highest priority and the lowest is Priority field 15 in the PPC_ALRH
   // register.
   //
   // - Priority Field 0 = 0000 = CPM high request level
   // - Priority Field 1 = 0001 = CPM middle request level
   // - Priority Field 2 = 0010 = CPM low request level
   // - Priority Field 3 = 0110 = Internal Core
   // - Priority Field 4 = 0111 = External Master 1
   // - Priority Field 5 = 1000 = External Master 2
   // - Priority Field 6 = 1001 = External Master 3
   // - Priority Field 7 = 0011 = Reserved
   //-------------------------------------------------------------------------

   addis    r3,0,0x0126
   ori      r3,r3,0x7893
   stw      r3,PPC_ALRH(r4)

   

   //--------------------------------------------------------------------------
   // Program the 60x Bus Transfer Error Status and Control Register 1. The
   // details are as follows:
   //
   // - DMD (Data Errors Disable) = 1 = 
   //     Disable all data errors on the 60x bus. Also parity single and double
   //     ECC error.
   // - All other bits are either status or reserved bits. All reserved bits 
   //   should be set to 0.
   //--------------------------------------------------------------------------

   addis    r3,0,0x0000
   ori      r3,r3,0x4000
   stw      r3,TESCR1(r4)


   //--------------------------------------------------------------------------
   // Program the 60x Bus Transfer Error Status and Control Register 2.
   //--------------------------------------------------------------------------

   addis    r3,0,0x0000
   ori      r3,r3,0x0000
   stw      r3,TESCR2(r4)



   //-------------------------------------------------------------------------
   // First, program the Memory Periodic Timer Prescaler Register (MPTPR).
   // Finding the value to this ties in with the desired SDRAM Refresh
   // Timer (PSRT) value and the required Refresh Command interval for 
   // refreshing each row. The Refresh Command interval is found by 
   // determining the number of rows on the SDRAM device. 
   //
   // Divide bus clock by 41 (decimal) which is MPTPR+1
   //-------------------------------------------------------------------------

   addi     r5,0,0x2800      // 
   sth      r5,MPTPR(r4)     // store half word - bits[16-31]

   //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
   // Initialize flash
   //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 
   //-------------------------------------------------------------------------
   // Base Register 0 (BR0): Bank 0 is assigned to the 8Mbyte (2M X 32) 
   //                        flash that resides on the 8266ADS-PCI board. 
   //                        The particulars are defined here. 
   // BA (Base Address) = 0xFF80+0b for a total of 17 address bits. This value
   //                     represents the upper 17 bits of the base address.
   // Bits 17-18 reserved. = 00
   // PS (Port Size) = 11b = 32 bit port size
   // DECC (Data Error Correction and Checking) = 00 = Data errors checking
   //                                                  Disabled.
   // WP (Write Protect) = 0 = both read and write accesses are allowed
   // MS (Machine Select) = 000 = General Purpose Chip Select Machine (GPCM)
   //                             for 60x bus Selected
   // EMEMC (External Memory Controller Enable) = 0 = Accesses are handled by
   //                                                 the memory controller
   //                                                 according to MSEL.
   // ATOM (Atomic Operation) = 00 = The address space controlled by the 
   //                                memory controller bank is not used for
   //                                atomic operations.
   // DR (Delayed Read) = 0 = Normal operation.
   // V (Valid Bit) =  1 = Valid bit set
   //-------------------------------------------------------------------------

   addis    r3,0,0xFF80   // R3 holds the value temporarily
   ori      r3,r3,0x1801

   //-------------------------------------------------------------------------
   // Option Register 0 (OR0) for GPCM use: further flash definitions
   //
   // 8MBbyte block size
   // CS early negate,
   // 11 wait states
   // timinig relax
   //-------------------------------------------------------------------------

   addis    r5,0,0xFF80     // R5 holds the value temporarily
   ori      r5,r5,0x0876   

   //------------------------------------------------------------------------
   // It's important to note the order in which OR0 and BR0 are programmed.
   // When coming out of reset and CS0 is the global chip select, OR0 MUST be 
   // programmed AFTER BR0. In all other cases BRx would be programmed after
   // ORx.
   //------------------------------------------------------------------------

   //------------------
   // Write the values
   //------------------
   stw        r3,BR0(r4)
   stw        r5,OR0(r4)



// init BCSR

   //-------------------------------------------------------------------------
   // Base Register 1 (BR1): Bank 1 is assigned to the Board Control and
   //                        Status Registers (BCSRs). 
   // BA (Base Address) = 0x0450+0b for a total of 17 address bits. This value
   //                     represents the upper 17 bits of the base address.
   // Bits 17-18 reserved. = 00
   // PS (Port Size) = 11b = 32 bit port size
   // DECC (Data Error Correction and Checking) = 00 = Data errors checking
   //                                                  Disabled.
   // WP (Write Protect) = 0 = both read and write accesses are allowed
   // MS (Machine Select) = 000 = General Purpose Chip Select Machine (GPCM)
   //                             for 60x bus Selected
   // EMEMC (External Memory Controller Enable) = 0 = Accesses are handled by
   //                                                 the memory controller
   //                                                 according to MSEL.
   // ATOM (Atomic Operation) = 00 = The address space controlled by the 
   //                                memory controller bank is not used for
   //                                atomic operations.
   // DR (Delayed Read) = 0 = Normal operation.
   // V (Valid Bit) =  1 = Valid bit set
   //-------------------------------------------------------------------------

   addis    r3,0,0x0450     // R3 holds the value temporarily
   ori      r3,r3,0x1801

   //-------------------------------------------------------------------------
   // Option Register 1 (OR1) for GPCM use: further BCSR definitions
   // AM (Address Mask) = 0xFFFF +1b = We've masked the upper 17 bits which 
   //                                  which defines a 32 Kbyte memory block.
   // Bits 17-19 Reserved - set to 000.
   // CSNT (Chip Select Negation Time) = 0 = CS/|WE/ are negated normally.
   // ACS (Address To Chip-Select Setup) = 00 = CS/ is output at the same 
   //                                           time as the addr lines.
   // Bit 23 Reserved - set to 0.
   // SCY (Cycle Length In Clocks) = 0001 = Add a 1 clock cycle wait state
   // SETA (External Transfer Acknowledge) = 0 = PSDVAL/ is generated 
   //                                            internally by the memory 
   //                                            controller unless GTA/ is 
   //                                            asserted earlier externally.
   // TRLX (Timing Relaxed) = 0 = Normal timing is generated by the GPCM.
   // EHTR (Extended Hold Time On Read Accesses) = 0 = Normal timing is 
   //                                                  generated by the memory
   //                                                  controller
   // Bit 31 Reserved - set to 0.
   //-------------------------------------------------------------------------

   addis    r5,0,0xFFFF     // R5 holds the value temporarily
   ori      r5,r5,0x8010

   //------------------
   // Write the values
   //------------------

   stw        r5,OR1(r4)
   stw        r3,BR1(r4)


   // PCI init
   addis    r3,0,0x0473     // R3 holds the value temporarily
   ori      r3,r3,0x1801

   addis    r5,0,0xFFFF     // R5 holds the value temporarily
   ori      r5,r5,0x8010

   stw        r5,OR3(r4)
   stw        r3,BR3(r4)


   //-------------------------------------------------------------------------
   // Program the 60x Bus Assigned SDRAM Refresh Timer (PSRT).
   //-------------------------------------------------------------------------

   addi     r5,0,0x0013      // load 0x13 or 19 
   stb      r5,PSRT(r4)      // store byte - bits[24-31]


   //########################
   // Program Bank Registers
   //########################


   //-------------------------------------------------------------------------
   // Base Register 2 (BR2): Bank 2 is assigned to the 32 Mbyte SDRAM (2 banks) memory
   //                        that resides on the 60x Bus. The 
   //                        particulars are defined here. 
   //
   // - BA (Base Address) = 0x0000+0b for a total of 17 address bits. This 
   //                       value represents the upper 17 bits of the base 
   //                       address.
   // - Bits 17-18 reserved. = 00 = cleared to 0.
   // - PS (Port Size) = 00b = 64 bit port size
   // - DECC (Data Error Correction and Checking) = 00 = Data errors checking
   //                                                    Disabled.
   // - WP (Write Protect) = 0 = both read and write accesses are allowed
   // - MS (Machine Select) = 010 = SDRAM Machine for 60x bus Selected
   // - EMEMC (External Memory Controller Enable) = 0 = 
   //    Accesses are handled by the memory controller according to MSEL.
   // - ATOM (Atomic Operation) = 00 = The address space controlled by the 
   //                                  memory controller bank is not used for
   //                                  atomic operations.
   // - DR (Delayed Read) = 0 = Normal operation.
   // - V (Valid Bit) =  1 = Valid bit set
   //-------------------------------------------------------------------------

   addis    r3,0,0x0000     // R3 holds the value temporarily
   ori      r3,r3,0x0041

   //-------------------------------------------------------------------------
   // Option Register 2 (OR2) for SDRAM Machine use: further SDRAM definitions
   //
   // 32MByte block size
   // 4 banks per device
   // row starts at A7
   // 12 row lines
   // internal bank interleaving allowed
   // normal AACK operation
   //-------------------------------------------------------------------------

   addis    r5,0,0xFC00     // R5 holds the value temporarily
   ori      r5,r5,0x2CC0

   //------------------
   // Write the values
   //------------------

   stw        r5,OR2(r4)
   stw        r3,BR2(r4)


   //#############################################
   // Perform Initialization sequence to 60x SDRAM
   //#############################################

   //-------------------------------------------------------------------------
   // Program the PowerPC SDRAM Mode Registr (PSDMR). This register is used
   // to configure operations pertaining to SDRAM. Program the PSDMR, turning 
   // off refresh services and changing the SDRAM operation to "Precharge all
   // banks". Then do a single write to an arbitrary location. Writing 0xFF 
   // to address 0 will do the trick.
   //
   // page based interleaving
   // refresh enabled
   // normal operation mode
   // address muxing mode 2, A14-16 on BNKSEL, A8 on PSDA 10,
   // 8 clocks refresh recovery
   // 3 clocks precharge to activate delay
   // 3 clocks to activate r/w delay
   // 4 beat burst length
   // 2 clock write recovery time
   // no extra cycle on address phase
   // normal timing for control lines
   // 3 clocks CAS latency
   //-------------------------------------------------------------------------

   addis    r0,0,0           // Load 0 into r0
   
   addi     r6,0,0x0000      // Load 0x00000000 into r6

   addis    r3,0,0x834F
   ori      r3,r3,0x36A3
   stw      r3,PSDMR(r4)	// Precharge all banks

   addis    r3,0,0xAB4F
   ori      r3,r3,0x36A3
   stw      r3,PSDMR(r4)	// Precharge all banks

   sync
   stb      r6,0(r0)         // Write 0x00 to address 0 - bits [24-31]


   //-------------------------------------------------------------------------
   // Program the PSDMR keeping refresh services off and changing the
   // SDRAM operation to "CBR Refresh". This step is responsible for issuing
   // a minimum of 8 auto-refresh commands. This is done by the SDRAM machine
   // by issuing the CBR Refresh command by programming the OP field of the 
   // PSDMR register and writing 0xFF 8 times to an arbitrary address.
   //-------------------------------------------------------------------------
   
   addis    r3,0,0x8B4F
   ori      r3,r3,0x36A3
   stw      r3,PSDMR(r4)	// CBR Refresh

   //------------------------------------------
   // Loop 8 times, writing 0xFF to address 0
   //------------------------------------------

   addi  r6,0,0x0008
   mtspr CTR,r6             // Load CTR with 8. The CTR special purpose
                            // is spr 9

   addi  r3,0,0x00FF      // Load 0x000000FF into r3
   sync

write_loop1:

   stb   r3,0(r0)         // Write 0xFF to address 0 - bits [24-31]
    
   bc    16,0,write_loop1  // Decrement CTR, then branch if the decremented CTR
                          // is not equal to 0      

   //-------------------------------------------------------------------------
   // Program the PSDMR again turning off refresh services and changing the
   // SDRAM operation to "Mode Register Write". Then do a single write to an
   // arbitrary location. The various fields that will be programmed in the 
   // mode register on the SDRAM were specified in fields of the PSDMR, like
   // the BR (burst length) and the CL (CAS Latency) field.
   //-------------------------------------------------------------------------
   
   addis    r3,0,0x9B4F
   ori      r3,r3,0x36A3
   stw      r3,PSDMR(r4)

   addi     r3,0,0x0000      // Load 0x00000000 into r3
   ori		r0, r0, 0x0190	 // Change address from 0x00000000 -> 0x00000190
   sync
   stb      r3,0(r0)         // Write 0xFF to address 0x00000190 - bits [24-31]
 
   //-------------------------------------------------------------------------
   // Program the PSDMR one last time turning on refresh services and changing 
   // the SDRAM operation to "Normal Operation". 
   //-------------------------------------------------------------------------
   
   addis    r3,0,0xC34F
   ori      r3,r3,0x36A3
   stw      r3,PSDMR(r4)



   //######################################################
   // There is no SDRAM when the Local Bus work in PCI mode
   //######################################################

   addi     r5,0,0x0000      // load 0x0 
   stb      r5,LSRT(r4)      // store byte - bits[24-31]







// init PCI registers

// PCI General Control Register
   addis    r3,0,0x0100
   ori      r3,r3,0x0000
   stw      r3,PCI_GCR(r4)

// Two pairs of new registers have been added to the SIU to detect accesses from side to the
// PCI bridge (other than PCI internal registers accesses). Each pair consists of a PCI base
// register (PCIBRx) for comparing addresses and a corresponding PCI mask register
// (PCIMSKx). 
   addis    r3,0,0xFF80 
   ori      r3,r3,0x0000
   stw      r3,PCIMSK0(r4)

   addis    r3,0,0x0480
   ori      r3,r3,0x0001
   stw      r3,PCIBR0(r4)

   addis    r3,0,0xC000 
   ori      r3,r3,0x0000
   stw      r3,PCIMSK1(r4)

   addis    r3,0,0x8000
   ori      r3,r3,0x0001
   stw      r3,PCIBR1(r4)

   addis    r3,0,0x3012
   ori      r3,r3,0x6754
   stw      r3,PPC_ALRH(r4)

   addi     r3,0,0x0003
   stb      r3,PPC_ACR(r4)

   // Security Co-Processor (SEC) configuration

   //program SEC Mask Register with value 0xFFFE0000 - 128 KB memory space
   addis    r3,0,0xFFFE
   ori      r3,r3,0x0000 
   stw      r3,SECMR(r4)
   // program SEC Base Register - IMMR + 0x40000
   mfspr    r5, 311
   addis    r3,r5,0x0004
   ori      r3,r3,0x0001
   stw      r3,SECBR(r4)


////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Copy the exception vectors from ROM to RAM
//
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	
	lis			r3, gInterruptVectorTable@h
	ori			r3, r3, gInterruptVectorTable@l
	subi		r3,r3,0x0004
	
	lis			r4, gInterruptVectorTableEnd@h
	ori			r4, r4, gInterruptVectorTableEnd@l
	
	lis			r5, 0xFFFF
	ori			r5,r5,0xFFFC
	
loop:
	lwzu		r6, 4(r3)
	stwu		r6, 4(r5)
	
	cmpw		r3,r4
	blt			loop
#endif //ROM_version
	
#ifdef CACHE_VERSION
	mfspr    r6,LR        // Save the Link Register value. The link register's
                          // value will be restored so that this function 
                          // can return to the calling address.
	bl		mmu_cache_init
	mtspr    LR,r6      // restore original Link Register value 
#endif
  
   blr 
}
