/**************************************************************************/
/* FILE NAME: tpu_nitc.h                       COPYRIGHT (c) MOTOROLA 2002 */
/* VERSION: 1.0                                   All Rights Reserved     */
/*                                                                        */
/* DESCRIPTION: This file defines the interface to the TPU NITC function  */
/* and provides useful #defines.                                          */
/*                                                                        */
/*========================================================================*/
/* HISTORY           ORIGINAL AUTHOR: Vernon Goler                        */
/* REV      AUTHOR      DATE       DESCRIPTION OF CHANGE                  */
/* ---   -----------  ---------    ---------------------                  */
/* 1.0   V. Goler   26/Aug/02    Initial version of function.             */
/**************************************************************************/
#include "m_common.h"
#include "m_tpu3.h"

/* Define HSR values */
#define TPU_NITC_INIT_TCR          0x1
#define TPU_NITC_INIT_PARAMETER    0x2

/* Define HSQ values */
#define TPU_NITC_SINGLE             0x0
#define TPU_NITC_CONTINUOUS         0x1 
#define TPU_NITC_NOLINK             0x0 
#define TPU_NITC_LINK               0x1

/* Define edge detect types		*/
#define TPU_NITC_RISING             0x1 
#define TPU_NITC_FALLING            0x2 
#define TPU_NITC_RISING_FALLING     0x3

/* Define tcr to capture when edge detected	*/
#define TPU_NITC_TCR1               0x0
#define TPU_NITC_TCR2               0x1

/* Define channel to start linking from	*/
#define TPU_NITC_START_LINK_CHANNEL_0	0x0
#define TPU_NITC_START_LINK_CHANNEL_1	0x1
#define TPU_NITC_START_LINK_CHANNEL_2   	0x2
#define TPU_NITC_START_LINK_CHANNEL_3  	0x3
#define TPU_NITC_START_LINK_CHANNEL_4 	0x4
#define TPU_NITC_START_LINK_CHANNEL_5	0x5
#define TPU_NITC_START_LINK_CHANNEL_6 	0x6
#define TPU_NITC_START_LINK_CHANNEL_7	0x7
#define TPU_NITC_START_LINK_CHANNEL_8	0x8
#define TPU_NITC_START_LINK_CHANNEL_9	0x9
#define TPU_NITC_START_LINK_CHANNEL_10	0xa
#define TPU_NITC_START_LINK_CHANNEL_11	0xb
#define TPU_NITC_START_LINK_CHANNEL_12	0xc
#define TPU_NITC_START_LINK_CHANNEL_13	0xd
#define TPU_NITC_START_LINK_CHANNEL_14	0xe
#define TPU_NITC_START_LINK_CHANNEL_15	0xf

/* Define the number of sequential channels to link	*/
#define TPU_NITC_LINK_ONE           0x1
#define TPU_NITC_LINK_TWO           0x2
#define TPU_NITC_LINK_THREE         0x3
#define TPU_NITC_LINK_FOUR          0x4
#define TPU_NITC_LINK_FIVE          0x5
#define TPU_NITC_LINK_SIX           0x6
#define TPU_NITC_LINK_SEVEN         0x7
#define TPU_NITC_LINK_EIGHT         0x8


/* Define to enable interrupts or not	*/
#define TPU_NITC_NOINTERRUPT        0x0
#define TPU_NITC_INTERRUPT          0x1


/* Define parameter RAM locations */
#define TPU_NITC_CHANNEL_CONTROL    0
#define TPU_NITC_CHANNEL_ATTRIBUTES 1
#define TPU_NITC_MAX_COUNT          2
#define TPU_NITC_TRANS_COUNT        3
#define TPU_NITC_FINAL_TRANS_TIME   4
#define TPU_NITC_LAST_TRANS_TIME    5

/* TPU NITC function prototypes */
void tpu_nitc_init_tcr_mode(struct TPU3_tag *tpu, UINT8 channel, \
	UINT8 priority, UINT8 detect_edge, INT16 max_count, \
	UINT8 single_continuous_operation, UINT8 tcr, \
	UINT8 nolink_link, UINT8 start_link_channel, \
	UINT8 link_channel_count, UINT8 nointerrupt_interrupt);

void tpu_nitc_init_parameter_mode(struct TPU3_tag *tpu, UINT8 channel, \
	UINT8 priority, UINT8 detect_edge, INT16 max_count, \
	UINT8 single_continuous_operation, UINT8 parameter_address, \
	UINT8 nolink_link, UINT8 start_link_channel, \
	UINT8 link_channel_count, UINT8 nointerrupt_interrupt);

void tpu_nitc_write_max_count(struct TPU3_tag *tpu, UINT8 channel, \
       INT16 max_count);

void tpu_nitc_write_trans_count(struct TPU3_tag *tpu, UINT8 channel, \
       INT16 trans_count);

INT16 tpu_nitc_read_max_count(struct TPU3_tag *tpu, UINT8 channel);

INT16 tpu_nitc_read_trans_count(struct TPU3_tag *tpu, UINT8 channel);

INT16 tpu_nitc_read_final_trans_time(struct TPU3_tag *tpu, UINT8 channel);

INT16 tpu_nitc_read_last_trans_time(struct TPU3_tag *tpu, UINT8 channel);


/*********************************************************************
 *
 * Copyright:
 *	MOTOROLA, INC. All Rights Reserved.  
 *  You are hereby granted a copyright license to use, modify, and
 *  distribute the SOFTWARE so long as this entire notice is
 *  retained without alteration in any modified and/or redistributed
 *  versions, and that such modified versions are clearly identified
 *  as such. No licenses are granted by implication, estoppel or
 *  otherwise under any patents or trademarks of Motorola, Inc. This 
 *  software is provided on an "AS IS" basis and without warranty.
 *
 *  To the maximum extent permitted by applicable law, MOTOROLA 
 *  DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED, INCLUDING 
 *  IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR
 *  PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH REGARD TO THE 
 *  SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF) AND ANY 
 *  ACCOMPANYING WRITTEN MATERIALS.
 * 
 *  To the maximum extent permitted by applicable law, IN NO EVENT
 *  SHALL MOTOROLA BE LIABLE FOR ANY DAMAGES WHATSOEVER (INCLUDING 
 *  WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS, BUSINESS 
 *  INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER PECUNIARY
 *  LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.   
 * 
 *  Motorola assumes no responsibility for the maintenance and support
 *  of this software
 ********************************************************************/
