/****************************************************************************/
/* FILE NAME: halld_comm_ex.c                     COPYRIGHT (c) MOTOROLA 2002     */
/* VERSION: 1.0                                                             */
/*                                                                          */
/* DESCRIPTION: This program demonstrates the use of the COMM and HALLD     */
/*              TPU functions. It sets up HALLD for three-channel           */
/*              operation and configures COMM to use a 16 entry commutation */
/*              state table running in sensored HALLD mode                  */
/*==========================================================================*/
/* COMPILER: Diab Data        VERSION: 4.3f                                 */
/*                                                                          */
/* HISTORY                                                                  */
/* REV      AUTHOR      DATE       DESCRIPTION OF CHANGE                    */
/* ---   -----------  ---------    ---------------------                    */
/* 1.0   K Terry       30/8/02      Demo. Program for TPU COMM/HALLD        */
/*                                  Function                                */
/****************************************************************************/
#include "mpc555.h"
#include "tpu_halld.h"
#include "tpu_comm.h"
#include "mpc500.c"        /* Configuration routines for MPC555 EVB */
#include "mpc500_util.h"   /* Utility routines for using MPC500 devices */


void main ()
{


	
		
	struct	TPU3_tag *tpua = &TPU_A;   /* pointer for TPU routines */	
	struct	halld_func *halld1;

	INT16 state = 0;
	INT16	state_no;
	INT16	tpu_comm_states[16] = {0x002c, 0x001a, 0x0034, 0x0031,
 				       0x0000, 0x0000, 0x0032, 0x0029,
 				       0x0029, 0x0032, 0x0000, 0x0000,
 				       0x0019, 0x0034, 0x001a, 0x002c
 				       };
			  	
	setup_mpc500(40);       /* Setup device and programm PLL to 40MHz */
 
/* 	initialise tpu comm function for tpu_a,

	master channel is 8     
 	no_of_pins = 6

 	update_period = 37 = 0x0025 - for sensored mode
 	UPDATE_PERIOD(min)(CPU clocks) = 64 + 14 * NO_OF_PINS
	UPDATE_PERIOD(min)(TCR1 clocks) = (64 + 14 * NO_OF_PINS) / 4
	- assumes DIV4 clock (TPUMCR3[EPSCKE] = 0, TPUMCR[PSCK] = 0
	and TPUMCR[TCR1P] = 00)
*/ 	
        tpu_comm_init_sensored(tpua, 8, 6, 0x0025, tpu_comm_states, 16);

/*      force STATE_0 for COMM function on tpua, master channel 8 */
        tpu_comm_force_state(tpua, 8, 0);
       

/*	enable COMM function master channel (8) for middle priority */
	tpu_enable(tpua, 8, TPU_PRIORITY_MIDDLE);

/*	wait for end of service (force_state) */

	while(tpu_get_hsr(tpua, 8)!=0);
	
	
/*	set up HALLD function for 3 channel mode using channels 3, 4 and 5
	initial value of DIRECTION = 0, state_no_address is set to 0x0083 
	to place the decoded STATE_NO value from HALLD into the required COMM
	RAM location for STATE_NO
*/ 

        tpu_halld_init(tpua, 3, HALLD_DIRECTION_0, 0x0083,
        HALLD_THREE_CHANNEL_MODE);
        
        tpu_halld_enable(tpua, 3, TPU_PRIORITY_MIDDLE);


/* The following loop of code is intended to demonstrate the operation of the 
   HALLD and COMM functions operating together. It will drive state values
   onto the QADC_A PORTQA[0..2] pins. If these are connected to the HALLD
   input channels(A, B and C], the HALLD function decodes the state values and
   supplies the decoded state number to the COMM function which in turn drives
   the appropriate commutation state value onto the TPU COMM channels */


	QADC_A.PORTQA.R = 0;
	QADC_A.DDRQA.R = 0xFF00;

	while(1)
	{
		tpu_halld_set_direction(tpua, 3, HALLD_DIRECTION_0);
		for (state = 0; state < 8; state++)
		{	
			QADC_A.PORTQA.R = state;
			
			/* wait for completion of COMM function service */	
			while (!((tpua->CISR.R) & (0x0001 << 8)));
					
			tpua->CISR.R = 0;					
			state_no = tpu_comm_get_state_no(tpua, 8);			
		}
		tpu_halld_set_direction(tpua, 3, HALLD_DIRECTION_1);

		for (state = 0; state < 8; state++)
		{
			QADC_A.PORTQA.R = state;
			
			/* wait for completion of COMM function service */		
			while (!((tpua->CISR.R) & (0x0001 << 8)));
			
			tpua->CISR.R = 0;					
			state_no = tpu_comm_get_state_no(tpua, 8);
		}
 	}	
}


/*********************************************************************
 *
 * Copyright:
 *	MOTOROLA, INC. All Rights Reserved.  
 *  You are hereby granted a copyright license to use, modify, and
 *  distribute the SOFTWARE so long as this entire notice is
 *  retained without alteration in any modified and/or redistributed
 *  versions, and that such modified versions are clearly identified
 *  as such. No licenses are granted by implication, estoppel or
 *  otherwise under any patents or trademarks of Motorola, Inc. This 
 *  software is provided on an "AS IS" basis and without warranty.
 *
 *  To the maximum extent permitted by applicable law, MOTOROLA 
 *  DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED, INCLUDING 
 *  IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR
 *  PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH REGARD TO THE 
 *  SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF) AND ANY 
 *  ACCOMPANYING WRITTEN MATERIALS.
 * 
 *  To the maximum extent permitted by applicable law, IN NO EVENT
 *  SHALL MOTOROLA BE LIABLE FOR ANY DAMAGES WHATSOEVER (INCLUDING 
 *  WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS, BUSINESS 
 *  INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER PECUNIARY
 *  LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.   
 * 
 *  Motorola assumes no responsibility for the maintenance and support
 *  of this software
 ********************************************************************/

